/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.route;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;
import org.jumpmind.symmetric.db.IDbDialect;
import org.jumpmind.symmetric.model.DataRef;
import org.jumpmind.symmetric.route.IDataToRouteGapDetector;
import org.jumpmind.symmetric.service.IDataService;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.service.ISqlProvider;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;

public class DataRefGapDetector
implements IDataToRouteGapDetector {
    final ILog log = LogFactory.getLog(this.getClass());
    private IDataService dataService;
    private IParameterService parameterService;
    private JdbcTemplate jdbcTemplate;
    private IDbDialect dbDialect;
    private ISqlProvider sqlProvider;

    public DataRefGapDetector(IDataService dataService, IParameterService parameterService, JdbcTemplate jdbcTemplate, IDbDialect dbDialect, ISqlProvider sqlProvider) {
        this.dataService = dataService;
        this.parameterService = parameterService;
        this.jdbcTemplate = jdbcTemplate;
        this.dbDialect = dbDialect;
        this.sqlProvider = sqlProvider;
    }

    public void beforeRouting() {
    }

    public void afterRouting() {
        final DataRef ref = this.dataService.getDataRef();
        long ts = System.currentTimeMillis();
        final int dataIdIncrementBy = this.parameterService.getInt("data.id.increment.by");
        long lastDataId = (Long)this.jdbcTemplate.query(this.sqlProvider.getSql("selectDistinctDataIdFromDataEventSql"), new Object[]{ref.getRefDataId()}, new int[]{4}, (ResultSetExtractor)new ResultSetExtractor<Long>(){

            public Long extractData(ResultSet rs) throws SQLException, DataAccessException {
                long lastDataId = ref.getRefDataId();
                while (rs.next()) {
                    long dataId = rs.getLong(1);
                    if (lastDataId == -1L || lastDataId + (long)dataIdIncrementBy == dataId || lastDataId == dataId) {
                        lastDataId = dataId;
                        continue;
                    }
                    if (DataRefGapDetector.this.dataService.countDataInRange(lastDataId, dataId) != 0) break;
                    if (DataRefGapDetector.this.dbDialect.supportsTransactionViews()) {
                        if (DataRefGapDetector.this.dbDialect.areDatabaseTransactionsPendingSince(DataRefGapDetector.this.dataService.findCreateTimeOfData(dataId).getTime() + 5000L) || DataRefGapDetector.this.dataService.countDataInRange(lastDataId, dataId) != 0) continue;
                        DataRefGapDetector.this.log.info("RouterSkippingDataIdsNoTransactions", lastDataId, dataId);
                        lastDataId = dataId;
                        continue;
                    }
                    if (!DataRefGapDetector.this.isDataGapExpired(dataId)) break;
                    DataRefGapDetector.this.log.info("RouterSkippingDataIdsGapExpired", lastDataId, dataId);
                    lastDataId = dataId;
                }
                return lastDataId;
            }
        });
        long updateTimeInMs = System.currentTimeMillis() - ts;
        if (updateTimeInMs > 10000L) {
            this.log.info("RoutedGapDetectionTime", updateTimeInMs);
        }
        if (ref.getRefDataId() != lastDataId) {
            this.dataService.saveDataRef(new DataRef(lastDataId, new Date()));
        }
    }

    protected boolean isDataGapExpired(long dataId) {
        long gapTimoutInMs = this.parameterService.getLong("routing.stale.dataid.gap.time.ms");
        Date createTime = this.dataService.findCreateTimeOfEvent(dataId);
        return createTime != null && System.currentTimeMillis() - createTime.getTime() > gapTimoutInMs;
    }
}

