/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.route;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.model.Data;
import org.jumpmind.symmetric.model.DataGap;
import org.jumpmind.symmetric.route.AbstractDataToRouteReader;
import org.jumpmind.symmetric.route.ChannelRouterContext;
import org.jumpmind.symmetric.service.IDataService;
import org.jumpmind.symmetric.service.ISqlProvider;
import org.jumpmind.symmetric.util.AppUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.support.JdbcUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataGapRouteReader
extends AbstractDataToRouteReader {
    private static final String SELECT_DATA_USING_GAPS_SQL = "selectDataUsingGapsSql";

    public DataGapRouteReader(ILog log, ISqlProvider sqlProvider, ChannelRouterContext context, IDataService dataService) {
        super(log, sqlProvider, context, dataService);
    }

    protected PreparedStatement prepareStatment(List<DataGap> dataGaps, int numberOfGapsToQualify, Connection c) throws SQLException {
        String channelId = this.context.getChannel().getChannelId();
        String sql = this.qualifyUsingDataGaps(dataGaps, numberOfGapsToQualify, this.getSql(SELECT_DATA_USING_GAPS_SQL, this.context.getChannel().getChannel()));
        PreparedStatement ps = c.prepareStatement(sql, 1003, 1007);
        ps.setQueryTimeout(this.jdbcTemplate.getQueryTimeout());
        ps.setFetchSize(this.jdbcTemplate.getFetchSize());
        ps.setString(1, channelId);
        for (int i = 0; i < numberOfGapsToQualify && i < dataGaps.size(); ++i) {
            DataGap gap = dataGaps.get(i);
            ps.setLong(i * 2 + 2, gap.getStartId());
            if (i + 1 == numberOfGapsToQualify && i + 1 < dataGaps.size()) {
                ps.setLong(i * 2 + 3, dataGaps.get(dataGaps.size() - 1).getEndId());
                continue;
            }
            ps.setLong(i * 2 + 3, gap.getEndId());
        }
        return ps;
    }

    protected String qualifyUsingDataGaps(List<DataGap> dataGaps, int numberOfGapsToQualify, String sql) {
        StringBuilder gapClause = new StringBuilder();
        for (int i = 0; i < numberOfGapsToQualify && i < dataGaps.size(); ++i) {
            if (i == 0) {
                gapClause.append(" and (");
            } else {
                gapClause.append(" or ");
            }
            gapClause.append("(d.data_id between ? and ?)");
        }
        gapClause.append(")");
        return AppUtils.replace("dataRange", gapClause.toString(), sql);
    }

    @Override
    protected void execute() {
        this.jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Integer doInConnection(Connection c) throws SQLException, DataAccessException {
                Integer n;
                int dataCount = 0;
                PreparedStatement ps = null;
                ResultSet rs = null;
                boolean autoCommit = c.getAutoCommit();
                try {
                    int numberOfGapsToQualify = DataGapRouteReader.this.dataService.getParameterService().getInt("routing.max.gaps.to.qualify.in.sql", 100);
                    List<DataGap> dataGaps = DataGapRouteReader.this.dataService.findDataGaps();
                    if (DataGapRouteReader.this.dbDialect.requiresAutoCommitFalseToSetFetchSize()) {
                        c.setAutoCommit(false);
                    }
                    String channelId = DataGapRouteReader.this.context.getChannel().getChannelId();
                    ps = DataGapRouteReader.this.prepareStatment(dataGaps, numberOfGapsToQualify, c);
                    long ts = System.currentTimeMillis();
                    rs = ps.executeQuery();
                    long executeTimeInMs = System.currentTimeMillis() - ts;
                    DataGapRouteReader.this.context.incrementStat(executeTimeInMs, "data.read.query.time.ms");
                    if (executeTimeInMs > 30000L) {
                        DataGapRouteReader.this.log.warn("RoutedDataSelectedInTime", executeTimeInMs, channelId);
                    } else if (DataGapRouteReader.this.log.isDebugEnabled()) {
                        DataGapRouteReader.this.log.debug("RoutedDataSelectedInTime", executeTimeInMs, channelId);
                    }
                    int maxQueueSize = DataGapRouteReader.this.dbDialect.getRouterDataPeekAheadCount();
                    int toRead = maxQueueSize - DataGapRouteReader.this.dataQueue.size();
                    ArrayList<Data> memQueue = new ArrayList<Data>(toRead);
                    ts = System.currentTimeMillis();
                    DataGap currentGap = dataGaps.remove(0);
                    while (rs.next() && DataGapRouteReader.this.reading && currentGap != null) {
                        long dataId;
                        boolean process = false;
                        while (!process && (dataId = rs.getLong(1)) >= currentGap.getStartId()) {
                            if (dataId <= currentGap.getEndId()) {
                                process = true;
                                break;
                            }
                            if (dataGaps.size() > 0) {
                                currentGap = dataGaps.remove(0);
                                continue;
                            }
                            currentGap = null;
                            break;
                        }
                        if (process) {
                            Data data = DataGapRouteReader.this.dataService.readData(rs);
                            DataGapRouteReader.this.context.setLastDataIdForTransactionId(data);
                            memQueue.add(data);
                            ++dataCount;
                            DataGapRouteReader.this.context.incrementStat(System.currentTimeMillis() - ts, "data.read.total.time.ms");
                        } else {
                            DataGapRouteReader.this.context.incrementStat(System.currentTimeMillis() - ts, "data.reread.time.ms");
                        }
                        ts = System.currentTimeMillis();
                        if (toRead == 0) {
                            DataGapRouteReader.this.copyToQueue(memQueue);
                            toRead = maxQueueSize - DataGapRouteReader.this.dataQueue.size();
                            memQueue = new ArrayList(toRead);
                        } else {
                            --toRead;
                        }
                        DataGapRouteReader.this.context.incrementStat(System.currentTimeMillis() - ts, "data.enqueue.time.ms");
                        ts = System.currentTimeMillis();
                    }
                    ts = System.currentTimeMillis();
                    DataGapRouteReader.this.copyToQueue(memQueue);
                    DataGapRouteReader.this.context.incrementStat(System.currentTimeMillis() - ts, "data.enqueue.time.ms");
                    n = dataCount;
                    Object var21_19 = null;
                }
                catch (Throwable throwable) {
                    Object var21_20 = null;
                    JdbcUtils.closeResultSet(rs);
                    JdbcUtils.closeStatement(ps);
                    rs = null;
                    ps = null;
                    if (DataGapRouteReader.this.dbDialect.requiresAutoCommitFalseToSetFetchSize()) {
                        c.commit();
                        c.setAutoCommit(autoCommit);
                    }
                    boolean done = false;
                    do {
                        if (done = DataGapRouteReader.this.dataQueue.offer(new AbstractDataToRouteReader.EOD())) continue;
                        AppUtils.sleep(50L);
                    } while (!done && DataGapRouteReader.this.reading);
                    DataGapRouteReader.this.reading = false;
                    throw throwable;
                }
                JdbcUtils.closeResultSet((ResultSet)rs);
                JdbcUtils.closeStatement((Statement)ps);
                rs = null;
                ps = null;
                if (DataGapRouteReader.this.dbDialect.requiresAutoCommitFalseToSetFetchSize()) {
                    c.commit();
                    c.setAutoCommit(autoCommit);
                }
                boolean done = false;
                do {
                    if (done = DataGapRouteReader.this.dataQueue.offer(new AbstractDataToRouteReader.EOD())) continue;
                    AppUtils.sleep(50L);
                } while (!done && DataGapRouteReader.this.reading);
                DataGapRouteReader.this.reading = false;
                return n;
            }
        });
    }
}

