/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.route;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;
import org.jumpmind.symmetric.db.IDbDialect;
import org.jumpmind.symmetric.model.DataGap;
import org.jumpmind.symmetric.route.IDataToRouteGapDetector;
import org.jumpmind.symmetric.service.IDataService;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.service.ISqlProvider;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataGapDetector
implements IDataToRouteGapDetector {
    final ILog log = LogFactory.getLog(this.getClass());
    private IDataService dataService;
    private IParameterService parameterService;
    private JdbcTemplate jdbcTemplate;
    private IDbDialect dbDialect;
    private ISqlProvider sqlProvider;

    public DataGapDetector() {
    }

    public DataGapDetector(IDataService dataService, IParameterService parameterService, JdbcTemplate jdbcTemplate, IDbDialect dbDialect, ISqlProvider sqlProvider) {
        this.dataService = dataService;
        this.parameterService = parameterService;
        this.jdbcTemplate = jdbcTemplate;
        this.dbDialect = dbDialect;
        this.sqlProvider = sqlProvider;
    }

    @Override
    public void afterRouting() {
    }

    @Override
    public void beforeRouting() {
        long updateTimeInMs;
        long ts = System.currentTimeMillis();
        List<DataGap> gaps = this.removeAbandonedGaps(this.dataService.findDataGaps());
        long lastDataId = -1L;
        final int dataIdIncrementBy = this.parameterService.getInt("data.id.increment.by");
        long maxDataToSelect = this.parameterService.getInt("routing.largest.gap.size");
        for (final DataGap dataGap : gaps) {
            final boolean lastGap = dataGap.equals(gaps.get(gaps.size() - 1));
            String sql = this.sqlProvider.getSql("selectDistinctDataIdFromDataEventUsingGapsSql");
            Object[] params = new Object[]{dataGap.getStartId(), dataGap.getEndId()};
            lastDataId = (Long)this.jdbcTemplate.query(sql, params, (ResultSetExtractor)new ResultSetExtractor<Long>(){

                public Long extractData(ResultSet rs) throws SQLException, DataAccessException {
                    long lastDataId = -1L;
                    while (rs.next()) {
                        long dataId = rs.getLong(1);
                        if (lastDataId == -1L && dataGap.getStartId() < dataId) {
                            DataGapDetector.this.dataService.insertDataGap(new DataGap(dataGap.getStartId(), dataId - 1L));
                        } else if (lastDataId != -1L && lastDataId + (long)dataIdIncrementBy != dataId && lastDataId != dataId) {
                            DataGapDetector.this.dataService.insertDataGap(new DataGap(lastDataId + 1L, dataId - 1L));
                        }
                        lastDataId = dataId;
                    }
                    if (lastDataId != -1L) {
                        if (!lastGap && lastDataId < dataGap.getEndId()) {
                            DataGapDetector.this.dataService.insertDataGap(new DataGap(lastDataId + 1L, dataGap.getEndId()));
                        }
                        DataGapDetector.this.dataService.updateDataGap(dataGap, DataGap.Status.OK);
                    } else if (!lastGap) {
                        if (DataGapDetector.this.dataService.countDataInRange(dataGap.getStartId() - 1L, dataGap.getEndId() + 1L) == 0) {
                            if (DataGapDetector.this.dbDialect.supportsTransactionViews()) {
                                long transactionViewClockSyncThresholdInMs = DataGapDetector.this.parameterService.getLong("oracle.transaction.view.clock.sync.threshold.ms", 60000L);
                                Date createTime = DataGapDetector.this.dataService.findCreateTimeOfData(dataGap.getEndId() + 1L);
                                if (createTime != null && !DataGapDetector.this.dbDialect.areDatabaseTransactionsPendingSince(createTime.getTime() + transactionViewClockSyncThresholdInMs) && DataGapDetector.this.dataService.countDataInRange(dataGap.getStartId() - 1L, dataGap.getEndId() + 1L) == 0) {
                                    DataGapDetector.this.log.info("RouterSkippingDataIdsNoTransactions", dataGap.getStartId(), dataGap.getEndId());
                                    DataGapDetector.this.dataService.updateDataGap(dataGap, DataGap.Status.SK);
                                }
                            } else if (DataGapDetector.this.isDataGapExpired(dataGap.getEndId() + 1L)) {
                                DataGapDetector.this.log.info("RouterSkippingDataIdsGapExpired", dataGap.getStartId(), dataGap.getEndId());
                                DataGapDetector.this.dataService.updateDataGap(dataGap, DataGap.Status.SK);
                            }
                        } else {
                            DataGapDetector.this.dataService.checkForAndUpdateMissingChannelIds(dataGap.getStartId() - 1L, dataGap.getEndId() + 1L);
                        }
                    }
                    return lastDataId;
                }
            });
        }
        if (lastDataId != -1L) {
            this.dataService.insertDataGap(new DataGap(lastDataId + 1L, lastDataId + maxDataToSelect));
        }
        if ((updateTimeInMs = System.currentTimeMillis() - ts) > 10000L) {
            this.log.info("RoutedGapDetectionTime", updateTimeInMs);
        }
    }

    protected List<DataGap> removeAbandonedGaps(List<DataGap> gaps) {
        ArrayList<DataGap> finalList = new ArrayList<DataGap>(gaps);
        for (DataGap dataGap1 : gaps) {
            for (DataGap dataGap2 : gaps) {
                if (dataGap1.equals(dataGap2) || !dataGap1.contains(dataGap2)) continue;
                finalList.remove(dataGap2);
                if (this.dataService == null) continue;
                this.dataService.updateDataGap(dataGap2, DataGap.Status.SK);
            }
        }
        return finalList;
    }

    protected boolean isDataGapExpired(long dataId) {
        long gapTimoutInMs = this.parameterService.getLong("routing.stale.dataid.gap.time.ms");
        Date createTime = this.dataService.findCreateTimeOfData(dataId);
        return createTime != null && System.currentTimeMillis() - createTime.getTime() > gapTimoutInMs;
    }
}

