/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.route;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jumpmind.symmetric.common.TableConstants;
import org.jumpmind.symmetric.common.logging.LogFactory;
import org.jumpmind.symmetric.model.DataEventType;
import org.jumpmind.symmetric.model.DataMetaData;
import org.jumpmind.symmetric.model.NetworkedNode;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.NodeGroupLink;
import org.jumpmind.symmetric.route.AbstractDataRouter;
import org.jumpmind.symmetric.route.IDataRouter;
import org.jumpmind.symmetric.route.IRouterContext;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.service.ITriggerRouterService;
import org.jumpmind.symmetric.transform.ITransformService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationChangedDataRouter
extends AbstractDataRouter
implements IDataRouter {
    final String CTX_KEY_RESYNC_NEEDED = "Resync." + ConfigurationChangedDataRouter.class.getSimpleName() + this.hashCode();
    final String CTX_KEY_FLUSH_CHANNELS_NEEDED = "FlushChannels." + ConfigurationChangedDataRouter.class.getSimpleName() + this.hashCode();
    final String CTX_KEY_FLUSH_TRANSFORMS_NEEDED = "FlushTransforms." + ConfigurationChangedDataRouter.class.getSimpleName() + this.hashCode();
    public static final String KEY = "symconfig";
    protected String tablePrefix;
    protected IConfigurationService configurationService;
    protected INodeService nodeService;
    protected ITriggerRouterService triggerRouterService;
    protected IParameterService parameterService;
    protected ITransformService transformService;

    @Override
    public Set<String> routeToNodes(IRouterContext routingContext, DataMetaData dataMetaData, Set<Node> possibleTargetNodes, boolean initialLoad) {
        HashSet<String> nodeIds = null;
        Map<String, String> columnValues = this.getDataMap(dataMetaData);
        Node me = this.findIdentity();
        NetworkedNode rootNetworkedNode = this.getRootNetworkNodeFromContext(routingContext);
        if (this.tableMatches(dataMetaData, "node") || this.tableMatches(dataMetaData, "node_security")) {
            if (this.didNodeSecurityChangeForNodeInitialization(dataMetaData)) {
                return null;
            }
            String nodeIdInQuestion = columnValues.get("NODE_ID");
            List<NodeGroupLink> nodeGroupLinks = this.getNodeGroupLinksFromContext(routingContext);
            for (Node nodeThatMayBeRoutedTo : possibleTargetNodes) {
                if (!this.isLinked(nodeIdInQuestion, nodeThatMayBeRoutedTo, rootNetworkedNode, me, nodeGroupLinks) || this.isSameNumberOfLinksAwayFromRoot(nodeThatMayBeRoutedTo, rootNetworkedNode, me)) continue;
                if (nodeIds == null) {
                    nodeIds = new HashSet();
                }
                nodeIds.add(nodeThatMayBeRoutedTo.getNodeId());
            }
        } else {
            for (Node nodeThatMayBeRoutedTo : possibleTargetNodes) {
                if (this.isSameNumberOfLinksAwayFromRoot(nodeThatMayBeRoutedTo, rootNetworkedNode, me)) continue;
                if (nodeIds == null) {
                    nodeIds = new HashSet<String>();
                }
                nodeIds.add(nodeThatMayBeRoutedTo.getNodeId());
            }
            if (StringUtils.isBlank((String)dataMetaData.getData().getSourceNodeId()) && (this.tableMatches(dataMetaData, "trigger") || this.tableMatches(dataMetaData, "trigger_router") || this.tableMatches(dataMetaData, "router") || this.tableMatches(dataMetaData, "node_group_link"))) {
                routingContext.getContextCache().put(this.CTX_KEY_RESYNC_NEEDED, Boolean.TRUE);
            }
            if (this.tableMatches(dataMetaData, "channel")) {
                routingContext.getContextCache().put(this.CTX_KEY_FLUSH_CHANNELS_NEEDED, Boolean.TRUE);
            }
            if (this.tableMatches(dataMetaData, "transform_column") || this.tableMatches(dataMetaData, "transform_table")) {
                routingContext.getContextCache().put(this.CTX_KEY_FLUSH_TRANSFORMS_NEEDED, Boolean.TRUE);
            }
        }
        return nodeIds;
    }

    protected boolean didNodeSecurityChangeForNodeInitialization(DataMetaData dataMetaData) {
        if (this.tableMatches(dataMetaData, "node_security") && dataMetaData.getData().getEventType() == DataEventType.UPDATE) {
            Map<String, String> oldData = this.getOldDataAsString("", dataMetaData);
            Map<String, String> newData = this.getNewDataAsString("", dataMetaData);
            if (newData.get("REGISTRATION_ENABLED") != null && !newData.get("REGISTRATION_ENABLED").equals(oldData.get("REGISTRATION_ENABLED"))) {
                return true;
            }
            if (newData.get("INITIAL_LOAD_ENABLED") != null && !newData.get("INITIAL_LOAD_ENABLED").equals(oldData.get("INITIAL_LOAD_ENABLED"))) {
                return true;
            }
        }
        return false;
    }

    protected Node findIdentity() {
        return this.nodeService.findIdentity();
    }

    protected List<NodeGroupLink> getNodeGroupLinksFromContext(IRouterContext routingContext) {
        List<NodeGroupLink> list = (List<NodeGroupLink>)routingContext.getContextCache().get(NodeGroupLink.class.getName());
        if (list == null) {
            list = this.configurationService.getNodeGroupLinks();
            routingContext.getContextCache().put(NodeGroupLink.class.getName(), list);
        }
        return list;
    }

    protected NetworkedNode getRootNetworkNodeFromContext(IRouterContext routingContext) {
        NetworkedNode root = (NetworkedNode)routingContext.getContextCache().get(NetworkedNode.class.getName());
        if (root == null) {
            root = this.nodeService.getRootNetworkedNode();
            routingContext.getContextCache().put(NetworkedNode.class.getName(), root);
        }
        return root;
    }

    private boolean isSameNumberOfLinksAwayFromRoot(Node nodeThatCouldBeRoutedTo, NetworkedNode root, Node me) {
        return root.getNumberOfLinksAwayFromRoot(nodeThatCouldBeRoutedTo.getNodeId()) == root.getNumberOfLinksAwayFromRoot(me.getNodeId());
    }

    private boolean isLinked(String nodeIdInQuestion, Node nodeThatCouldBeRoutedTo, NetworkedNode root, Node me, List<NodeGroupLink> allLinks) {
        if (!nodeIdInQuestion.equals(nodeThatCouldBeRoutedTo.getNodeId())) {
            NetworkedNode networkedNodeInQuestion = root.findNetworkedNode(nodeIdInQuestion);
            NetworkedNode networkedNodeThatCouldBeRoutedTo = root.findNetworkedNode(nodeThatCouldBeRoutedTo.getNodeId());
            if (networkedNodeInQuestion != null) {
                if (networkedNodeInQuestion.isInParentHierarchy(nodeThatCouldBeRoutedTo.getNodeId())) {
                    return true;
                }
                String createdAtNodeId = networkedNodeInQuestion.getNode().getCreatedAtNodeId();
                if (createdAtNodeId != null && !createdAtNodeId.equals(me.getNodeId()) && !networkedNodeInQuestion.getNode().getNodeId().equals(me.getNodeId())) {
                    if (createdAtNodeId.equals(nodeThatCouldBeRoutedTo.getNodeId())) {
                        return true;
                    }
                    return networkedNodeThatCouldBeRoutedTo.isInChildHierarchy(createdAtNodeId);
                }
                String groupId = networkedNodeInQuestion.getNode().getNodeGroupId();
                HashSet<String> groupsThatWillBeInterested = new HashSet<String>();
                for (NodeGroupLink nodeGroupLink : allLinks) {
                    if (nodeGroupLink.getTargetNodeGroupId().equals(groupId)) {
                        groupsThatWillBeInterested.add(nodeGroupLink.getSourceNodeGroupId());
                        continue;
                    }
                    if (!nodeGroupLink.getSourceNodeGroupId().equals(groupId)) continue;
                    groupsThatWillBeInterested.add(nodeGroupLink.getTargetNodeGroupId());
                }
                if (groupsThatWillBeInterested.contains(nodeThatCouldBeRoutedTo.getNodeGroupId())) {
                    return true;
                }
                return networkedNodeThatCouldBeRoutedTo.hasChildrenThatBelongToGroups(groupsThatWillBeInterested);
            }
            return false;
        }
        return true;
    }

    @Override
    public void contextCommitted(IRouterContext routingContext) {
        if (routingContext.getContextCache().get(this.CTX_KEY_FLUSH_CHANNELS_NEEDED) != null) {
            this.log.info("ChannelFlushed");
            this.configurationService.reloadChannels();
        }
        if (routingContext.getContextCache().get(this.CTX_KEY_RESYNC_NEEDED) != null && this.parameterService.is("auto.sync.triggers")) {
            this.log.info("ConfigurationChanged");
            this.triggerRouterService.syncTriggers();
        }
        if (routingContext.getContextCache().get(this.CTX_KEY_FLUSH_TRANSFORMS_NEEDED) != null && this.parameterService.is("auto.sync.configuration")) {
            this.log.info("ConfigurationChanged");
            this.transformService.resetCache();
        }
    }

    public void setTablePrefix(String tablePrefix) {
        this.tablePrefix = tablePrefix;
    }

    public void setConfigurationService(IConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public void setNodeService(INodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setTriggerRouterService(ITriggerRouterService triggerRouterService) {
        this.triggerRouterService = triggerRouterService;
    }

    public void setParameterService(IParameterService parameterService) {
        this.parameterService = parameterService;
        this.log = LogFactory.getLog(parameterService);
    }

    public void setTransformService(ITransformService transformService) {
        this.transformService = transformService;
    }

    private boolean tableMatches(DataMetaData dataMetaData, String tableName) {
        boolean matches = false;
        if (dataMetaData.getTable().getName().equalsIgnoreCase(TableConstants.getTableName(this.tablePrefix, tableName))) {
            matches = true;
        }
        return matches;
    }
}

