/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.profile;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.URL;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.config.SymmetricPropertiesFiles;
import org.jumpmind.symmetric.db.SqlScript;
import org.jumpmind.symmetric.profile.IProfile;
import org.springframework.core.io.Resource;

public class DefaultProfile
implements IProfile {
    private static final long serialVersionUID = 1L;
    final Log logger = LogFactory.getLog(this.getClass());
    protected String externalId;
    protected String nodeGroupId;
    protected String registrationUrl = "";
    protected URL configSqlFile;
    protected String name;
    protected String description;
    protected boolean needsConfig = true;

    public DefaultProfile() {
    }

    public DefaultProfile(String name, String description, boolean needsConfig) {
        this(null, null, null, name, description, needsConfig);
    }

    public DefaultProfile(String externalId, String nodeGroupId, URL configSqlFile, String name, String description, boolean needsConfig) {
        this.externalId = externalId;
        this.nodeGroupId = nodeGroupId;
        this.configSqlFile = configSqlFile;
        this.name = name;
        this.description = description;
        this.needsConfig = needsConfig;
    }

    public boolean isAutoRegister() {
        return false;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public String getNodeGroupId() {
        return this.nodeGroupId;
    }

    public void setNodeGroupId(String nodeGroupId) {
        this.nodeGroupId = nodeGroupId;
    }

    public URL getConfigSqlFile() {
        return this.configSqlFile;
    }

    public void setConfigSqlFile(URL configSqlFile) {
        this.configSqlFile = configSqlFile;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setRegistrationUrl(String registrationUrl) {
        this.registrationUrl = registrationUrl;
    }

    public String getRegistrationUrl() {
        return this.registrationUrl;
    }

    public void configure(ISymmetricEngine engine) throws Exception {
        if (this.needsConfig) {
            SymmetricPropertiesFiles propertiesFiles = (SymmetricPropertiesFiles)engine.getApplicationContext().getBean(SymmetricPropertiesFiles.class);
            Resource resource = propertiesFiles.findPreferredWritableResource();
            File file = resource.getFile();
            Properties properties = new Properties();
            if (file.exists()) {
                FileInputStream fis = new FileInputStream(file);
                properties.load(fis);
                fis.close();
            }
            boolean dirty = false;
            if (this.nodeGroupId != null) {
                properties.setProperty("group.id", this.nodeGroupId);
                dirty = true;
            }
            if (this.externalId != null) {
                properties.setProperty("external.id", this.externalId);
                dirty = true;
            }
            if (this.registrationUrl != null) {
                properties.setProperty("registration.url", this.registrationUrl);
                dirty = true;
            }
            if (dirty) {
                if (!file.exists()) {
                    file.getParentFile().mkdirs();
                }
                this.logger.info((Object)("Updating " + file.getCanonicalPath()));
                FileOutputStream fos = new FileOutputStream(file);
                properties.store(fos, "Saved by console at " + new Date());
                fos.close();
            }
            engine.getParameterService().rereadParameters();
            engine.getNodeService().deleteIdentity();
            if (this.configSqlFile != null) {
                this.logger.info((Object)("Applying " + this.configSqlFile.getFile()));
                SqlScript script = new SqlScript(this.configSqlFile, engine.getDataSource());
                script.setLineDeliminator("\\\\n");
                script.execute();
            }
        }
    }

    public boolean isCompatible(ISymmetricEngine engine) {
        return true;
    }

    public String toString() {
        return this.name;
    }
}

