/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.model;

import java.io.Serializable;
import java.util.Date;
import org.jumpmind.symmetric.model.BatchInfo;
import org.jumpmind.symmetric.model.DataEventType;

public class OutgoingBatch
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long batchId;
    private String nodeId;
    private String channelId;
    private Status status = Status.RT;
    private boolean loadFlag;
    private boolean errorFlag;
    private long routerMillis;
    private long networkMillis;
    private long filterMillis;
    private long loadMillis;
    private long extractMillis;
    private long byteCount;
    private long sentCount;
    private long extractCount;
    private long loadCount;
    private long dataEventCount;
    private long reloadEventCount;
    private long insertEventCount;
    private long updateEventCount;
    private long deleteEventCount;
    private long otherEventCount;
    private long failedDataId;
    private String sqlState;
    private int sqlCode;
    private String sqlMessage;
    private String lastUpdatedHostName;
    private Date lastUpdatedTime;
    private Date createTime;
    private long oldDataEventCount = 0L;
    private long oldByteCount = 0L;
    private long oldFilterMillis = 0L;
    private long oldExtractMillis = 0L;
    private long oldLoadMillis = 0L;
    private long oldNetworkMillis = 0L;

    public OutgoingBatch() {
    }

    public OutgoingBatch(String nodeId, String channelId, Status status) {
        this.nodeId = nodeId;
        this.channelId = channelId;
        this.status = status;
        this.createTime = new Date();
    }

    public void resetStats() {
        this.oldByteCount = this.byteCount;
        this.oldDataEventCount = this.dataEventCount;
        this.oldExtractMillis = this.extractMillis;
        this.oldLoadMillis = this.loadMillis;
        this.oldNetworkMillis = this.networkMillis;
        this.oldFilterMillis = this.filterMillis;
        this.dataEventCount = 0L;
        this.byteCount = 0L;
        this.filterMillis = 0L;
        this.extractMillis = 0L;
        this.loadMillis = 0L;
        this.networkMillis = 0L;
    }

    public void revertStatsOnError() {
        if (this.oldDataEventCount > 0L) {
            this.byteCount = this.oldByteCount;
            this.dataEventCount = this.oldDataEventCount;
            this.extractMillis = this.oldExtractMillis;
            this.loadMillis = this.oldLoadMillis;
            this.networkMillis = this.oldNetworkMillis;
            this.filterMillis = this.oldFilterMillis;
        }
    }

    public void setErrorFlag(boolean errorFlag) {
        this.errorFlag = errorFlag;
    }

    public boolean isErrorFlag() {
        return this.errorFlag;
    }

    public void setLoadFlag(boolean loadFlag) {
        this.loadFlag = loadFlag;
    }

    public boolean isLoadFlag() {
        return this.loadFlag;
    }

    public void setSentCount(long sentCount) {
        this.sentCount = sentCount;
    }

    public long getSentCount() {
        return this.sentCount;
    }

    public void setExtractCount(long extractCount) {
        this.extractCount = extractCount;
    }

    public long getExtractCount() {
        return this.extractCount;
    }

    public void setLoadCount(long loadCount) {
        this.loadCount = loadCount;
    }

    public long getLoadCount() {
        return this.loadCount;
    }

    public String getNodeBatchId() {
        return this.nodeId + "-" + this.batchId;
    }

    public long getBatchId() {
        return this.batchId;
    }

    public void setBatchId(long batchId) {
        this.batchId = batchId;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String locationId) {
        this.nodeId = locationId;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    public void setStatus(String status) {
        this.status = Status.valueOf(status);
    }

    public BatchInfo getBatchInfo() {
        return new BatchInfo(this.batchId);
    }

    public long getRouterMillis() {
        return this.routerMillis;
    }

    public void setUpdateEventCount(long updateEventCount) {
        this.updateEventCount = updateEventCount;
    }

    public long getUpdateEventCount() {
        return this.updateEventCount;
    }

    public void setDeleteEventCount(long deleteEventCount) {
        this.deleteEventCount = deleteEventCount;
    }

    public long getDeleteEventCount() {
        return this.deleteEventCount;
    }

    public void incrementEventCount(DataEventType type) {
        switch (type) {
            case RELOAD: {
                ++this.reloadEventCount;
                break;
            }
            case INSERT: {
                ++this.insertEventCount;
                break;
            }
            case UPDATE: {
                ++this.updateEventCount;
                break;
            }
            case DELETE: {
                ++this.deleteEventCount;
                break;
            }
            default: {
                ++this.otherEventCount;
            }
        }
    }

    public void setInsertEventCount(long insertEventCount) {
        this.insertEventCount = insertEventCount;
    }

    public long getInsertEventCount() {
        return this.insertEventCount;
    }

    public void setOtherEventCount(long otherEventCount) {
        this.otherEventCount = otherEventCount;
    }

    public long getOtherEventCount() {
        return this.otherEventCount;
    }

    public void setReloadEventCount(long reloadEventCount) {
        this.reloadEventCount = reloadEventCount;
    }

    public long getReloadEventCount() {
        return this.reloadEventCount;
    }

    public void setRouterMillis(long routerMillis) {
        this.routerMillis = routerMillis;
    }

    public long getNetworkMillis() {
        return this.networkMillis;
    }

    public void setNetworkMillis(long networkMillis) {
        this.networkMillis = networkMillis;
    }

    public long getFilterMillis() {
        return this.filterMillis;
    }

    public void setFilterMillis(long filterMillis) {
        this.filterMillis = filterMillis;
    }

    public long getLoadMillis() {
        return this.loadMillis;
    }

    public void setLoadMillis(long databaseMillis) {
        this.loadMillis = databaseMillis;
    }

    public long getByteCount() {
        return this.byteCount;
    }

    public void setByteCount(long byteCount) {
        this.byteCount = byteCount;
    }

    public long getDataEventCount() {
        return this.dataEventCount;
    }

    public void setDataEventCount(long dataEventCount) {
        this.dataEventCount = dataEventCount;
    }

    public void setExtractMillis(long extractMillis) {
        this.extractMillis = extractMillis;
    }

    public long getExtractMillis() {
        return this.extractMillis;
    }

    public void incrementDataEventCount() {
        ++this.dataEventCount;
    }

    public void incrementByteCount(int size) {
        this.byteCount += (long)size;
    }

    public long getFailedDataId() {
        return this.failedDataId;
    }

    public void setFailedDataId(long failedDataId) {
        this.failedDataId = failedDataId;
    }

    public String getSqlState() {
        return this.sqlState;
    }

    public void setSqlState(String sqlState) {
        this.sqlState = sqlState;
    }

    public int getSqlCode() {
        return this.sqlCode;
    }

    public void setSqlCode(int sqlCode) {
        this.sqlCode = sqlCode;
    }

    public String getSqlMessage() {
        return this.sqlMessage;
    }

    public void setSqlMessage(String sqlMessage) {
        this.sqlMessage = sqlMessage;
    }

    public String getLastUpdatedHostName() {
        return this.lastUpdatedHostName;
    }

    public void setLastUpdatedHostName(String lastUpdatedHostName) {
        this.lastUpdatedHostName = lastUpdatedHostName;
    }

    public Date getLastUpdatedTime() {
        if (this.lastUpdatedTime == null) {
            return new Date();
        }
        return this.lastUpdatedTime;
    }

    public void setLastUpdatedTime(Date lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public long totalEventCount() {
        return this.insertEventCount + this.updateEventCount + this.deleteEventCount + this.otherEventCount;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        RT("Routing"),
        NE("New"),
        QY("Querying"),
        SE("Sending"),
        LD("Loading"),
        ER("Error"),
        OK("Ok"),
        IG("Ignored");

        private String description;

        private Status(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }
    }
}

