/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.model;

import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jumpmind.symmetric.model.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkedNode
implements Comparable<NetworkedNode> {
    private Node node;
    private NetworkedNode parent;
    private Set<NetworkedNode> children;

    public NetworkedNode(Node node) {
        this.node = node;
    }

    public void addChild(NetworkedNode node) {
        if (this.children == null) {
            this.children = new TreeSet<NetworkedNode>();
        }
        node.parent = this;
        this.children.add(node);
    }

    public Node getNode() {
        return this.node;
    }

    public NetworkedNode getParent() {
        return this.parent;
    }

    public int getNumberOfLinksAwayFromRoot(String nodeId) {
        int numberOfLinksAwayFromRoot = this.getRoot().getNumberOfLinksAwayFromMe(nodeId, 0);
        if (numberOfLinksAwayFromRoot == 0 && !this.node.getNodeId().equals(nodeId)) {
            return -1;
        }
        return numberOfLinksAwayFromRoot;
    }

    protected int getNumberOfLinksAwayFromMe(String nodeId, int numberOfLinksIAmFromRoot) {
        if (!this.node.getNodeId().equals(nodeId) && this.children != null) {
            for (NetworkedNode child : this.children) {
                if (child.getNode().getNodeId().equals(nodeId)) {
                    return numberOfLinksIAmFromRoot + 1;
                }
                int numberOfLinksAwayFromMe = child.getNumberOfLinksAwayFromMe(nodeId, numberOfLinksIAmFromRoot + 1);
                if (numberOfLinksAwayFromMe <= numberOfLinksIAmFromRoot) continue;
                return numberOfLinksAwayFromMe;
            }
        }
        return numberOfLinksIAmFromRoot;
    }

    public NetworkedNode findNetworkedNode(String nodeId) {
        if (this.node.getNodeId().equals(nodeId)) {
            return this;
        }
        if (this.children != null) {
            for (NetworkedNode child : this.children) {
                if (child.getNode().getNodeId().equals(nodeId)) {
                    return child;
                }
                NetworkedNode foundIt = child.findNetworkedNode(nodeId);
                if (foundIt == null) continue;
                return foundIt;
            }
        }
        return null;
    }

    public boolean isInParentHierarchy(String nodeId) {
        if (this.parent != null) {
            if (this.parent.getNode().getNodeId().equals(nodeId)) {
                return true;
            }
            return this.parent.isInParentHierarchy(nodeId);
        }
        return false;
    }

    public boolean hasChildrenThatBelongToGroups(Set<String> groupIds) {
        if (this.children != null) {
            for (NetworkedNode child : this.children) {
                if (groupIds.contains(child.getNode().getNodeGroupId())) {
                    return true;
                }
                if (!child.hasChildrenThatBelongToGroups(groupIds)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isInChildHierarchy(String nodeId) {
        if (this.children != null) {
            for (NetworkedNode child : this.children) {
                if (child.getNode().getNodeId().equals(nodeId)) {
                    return true;
                }
                if (!child.isInChildHierarchy(nodeId)) continue;
                return true;
            }
        }
        return false;
    }

    public void addParents(Map<String, Node> nodes, Map<String, NetworkedNode> leaves) {
        String parentNodeId = this.node.getCreatedAtNodeId();
        if (parentNodeId != null && !parentNodeId.equals(this.node.getNodeId())) {
            Node parentNode;
            NetworkedNode parentNetworkedNode = leaves.get(parentNodeId);
            if (parentNetworkedNode == null && (parentNode = nodes.get(parentNodeId)) != null) {
                parentNetworkedNode = new NetworkedNode(parentNode);
                parentNetworkedNode.addParents(nodes, leaves);
                leaves.put(parentNodeId, parentNetworkedNode);
            }
            if (parentNetworkedNode != null) {
                parentNetworkedNode.addChild(this);
            }
            this.parent = parentNetworkedNode;
        }
    }

    public NetworkedNode getRoot() {
        if (this.parent != null) {
            return this.parent.getRoot();
        }
        return this;
    }

    @Override
    public int compareTo(NetworkedNode o) {
        return this.node.getNodeId().compareTo(o.getNode().getNodeId());
    }
}

