/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.load.csv;

import java.io.BufferedReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.jumpmind.symmetric.SymmetricException;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;
import org.jumpmind.symmetric.csv.CsvReader;
import org.jumpmind.symmetric.db.IDbDialect;
import org.jumpmind.symmetric.load.DataLoaderContext;
import org.jumpmind.symmetric.load.DataLoaderStatistics;
import org.jumpmind.symmetric.load.IBatchListener;
import org.jumpmind.symmetric.load.IColumnFilter;
import org.jumpmind.symmetric.load.IDataLoader;
import org.jumpmind.symmetric.load.IDataLoaderContext;
import org.jumpmind.symmetric.load.IDataLoaderFilter;
import org.jumpmind.symmetric.load.IDataLoaderStatistics;
import org.jumpmind.symmetric.load.IMissingTableHandler;
import org.jumpmind.symmetric.load.TableTemplate;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.statistic.IStatisticManager;
import org.jumpmind.symmetric.util.AppUtils;
import org.jumpmind.symmetric.util.CsvUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.SingleConnectionDataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsvLoader
implements IDataLoader {
    static final ILog log = LogFactory.getLog(CsvLoader.class);
    protected JdbcTemplate jdbcTemplate;
    protected IDbDialect dbDialect;
    protected IParameterService parameterService;
    protected INodeService nodeService;
    protected CsvReader csvReader;
    protected DataLoaderContext context;
    protected DataLoaderStatistics stats;
    protected List<IDataLoaderFilter> filters;
    protected IStatisticManager statisticManager;
    protected Map<String, List<IColumnFilter>> columnFilters;
    protected long bytesCount = 0L;
    protected long lineCount = 0L;
    protected Connection connection;
    protected boolean oldAutoCommitSetting;
    protected List<IBatchListener> batchListeners;
    private static Set<String> missingTables = new HashSet<String>();

    @Override
    public void open(BufferedReader reader, DataSource dataSource, List<IBatchListener> batchListeners) throws IOException {
        try {
            this.connection = dataSource.getConnection();
            this.oldAutoCommitSetting = this.connection.getAutoCommit();
            this.connection.setAutoCommit(false);
            this.batchListeners = batchListeners != null ? batchListeners : new ArrayList();
            this.jdbcTemplate = new JdbcTemplate((DataSource)new SingleConnectionDataSource(this.connection, true));
            this.jdbcTemplate.setQueryTimeout(this.dbDialect.getQueryTimeoutInSeconds());
            this.csvReader = CsvUtils.getCsvReader(reader);
            this.context = new DataLoaderContext(this.nodeService, this.jdbcTemplate);
            this.stats = new DataLoaderStatistics();
        }
        catch (SQLException ex) {
            this.close();
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void open(BufferedReader reader, DataSource dataSource, List<IBatchListener> batchListeners, List<IDataLoaderFilter> filters, Map<String, List<IColumnFilter>> columnFilters) throws IOException {
        this.open(reader, dataSource, batchListeners);
        this.filters = filters;
        this.columnFilters = columnFilters;
    }

    @Override
    public boolean hasNext() throws IOException {
        this.context.clearBatch();
        while (this.csvReader.readRecord()) {
            String[] tokens = this.csvReader.getValues();
            if (tokens[0].equals("batch")) {
                this.context.setBatchId(new Long(tokens[1]));
                this.stats = new DataLoaderStatistics();
                return true;
            }
            if (tokens[0].equals("nodeid")) {
                this.context.setSourceNodeId(tokens[1]);
                continue;
            }
            if (this.isMetaTokenParsed(tokens)) continue;
            log.debug("LoaderIgnoringToken", tokens[0]);
        }
        return false;
    }

    @Override
    public void skip() throws IOException {
        this.context.setSkipping(true);
        this.load();
    }

    private void logTableIgnored() {
        String tableName;
        TableTemplate tableTemplate = this.context.getTableTemplate();
        if (tableTemplate != null && !missingTables.contains(tableName = tableTemplate.getFullyQualifiedTableName())) {
            log.warn("LoaderTableMissing", tableName);
            missingTables.add(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void load() throws IOException {
        block56: {
            this.dbDialect.disableSyncTriggers(this.jdbcTemplate, this.context.getSourceNodeId());
            long rowsBeforeCommit = this.parameterService.getLong("dataloader.max.rows.before.commit");
            long rowsProcessed = 0L;
            this.lineCount = 0L;
            this.bytesCount = 0L;
            long ts = System.currentTimeMillis();
            this.prepareTableForDataLoad();
            while (this.csvReader.readRecord()) {
                long executeTimeInMs;
                TableTemplate tableTemplate = this.context.getTableTemplate();
                Object[] tokens = this.csvReader.getValues();
                if (tokens != null && tokens.length > 0 && tokens[0] != null) {
                    this.stats.incrementLineCount();
                    ++this.lineCount;
                    long numberOfBytes = this.csvReader.getRawRecord().length();
                    this.stats.incrementByteCount(numberOfBytes);
                    this.bytesCount += numberOfBytes;
                    if (tokens[0].equals("insert")) {
                        if (tableTemplate == null) {
                            throw new IllegalStateException("The table metadata was missing from the protocol.  Please turn on debug level logging to analyze the CSV data.");
                        }
                        if (tableTemplate.isIgnoreThisTable() && !this.willFiltersHandleMissingTable(this.context)) {
                            this.logTableIgnored();
                        } else if (!this.context.isSkipping()) {
                            this.insert((String[])tokens);
                            ++rowsProcessed;
                        }
                    } else if (tokens[0].equals("update")) {
                        if (tableTemplate == null) {
                            throw new IllegalStateException("The table metadata was missing from the protocol.  Please turn on debug level logging to analyze the CSV data.");
                        }
                        if (tableTemplate.isIgnoreThisTable() && !this.willFiltersHandleMissingTable(this.context)) {
                            this.logTableIgnored();
                        } else if (!this.context.isSkipping()) {
                            this.update((String[])tokens);
                            ++rowsProcessed;
                        }
                    } else if (tokens[0].equals("delete")) {
                        if (tableTemplate == null) {
                            throw new IllegalStateException("The table metadata was missing from the protocol.  Please turn on debug level logging to analyze the CSV data.");
                        }
                        if (tableTemplate.isIgnoreThisTable() && !this.willFiltersHandleMissingTable(this.context)) {
                            this.logTableIgnored();
                        } else if (!this.context.isSkipping()) {
                            this.delete((String[])tokens);
                            ++rowsProcessed;
                        }
                    } else if (tokens[0].equals("old")) {
                        this.context.setOldData((String[])ArrayUtils.subarray((Object[])tokens, (int)1, (int)tokens.length));
                    } else {
                        if (this.isMetaTokenParsed((String[])tokens)) continue;
                        if (((String)tokens[0]).equals("commit")) break;
                        if (((String)tokens[0]).equals("sql")) {
                            if (tableTemplate == null) {
                                throw new IllegalStateException("The table metadata was missing from the protocol.  Please turn on debug level logging to analyze the CSV data.");
                            }
                            if (tableTemplate.isIgnoreThisTable()) {
                                this.logTableIgnored();
                            } else if (!this.context.isSkipping()) {
                                this.runSql((String)tokens[1]);
                                ++rowsProcessed;
                            }
                        } else if (((String)tokens[0]).equals("bsh")) {
                            if (!this.context.isSkipping()) {
                                HashMap<String, Object> variables = new HashMap<String, Object>();
                                Node identity = this.nodeService.findIdentity();
                                variables.put("SOURCE_NODE_ID", this.context.getNodeId());
                                variables.put("DATASOURCE", this.dbDialect.getJdbcTemplate().getDataSource());
                                if (identity != null) {
                                    variables.put("TARGET_NODE_ID", identity.getNodeId());
                                    variables.put("TARGET_EXTERNAL_ID", identity.getExternalId());
                                    variables.put("TARGET_NODE", identity);
                                }
                                AppUtils.runBsh(variables, (String)tokens[1]);
                                ++rowsProcessed;
                            }
                        } else if (((String)tokens[0]).equals("create")) {
                            if (!this.context.isSkipping()) {
                                this.runDdl((String)tokens[1]);
                                ++rowsProcessed;
                            }
                        } else {
                            log.warn("LoaderTokenUnexpected", tokens[0], this.stats.getLineCount(), this.context.getBatch());
                        }
                    }
                }
                if (rowsProcessed > rowsBeforeCommit && rowsBeforeCommit > 0L) {
                    rowsProcessed = 0L;
                    this.fireEarlyCommit();
                    this.connection.commit();
                    AppUtils.sleep(5L);
                }
                if (this.bytesCount > 1024L) {
                    this.statisticManager.incrementDataBytesLoaded(this.context.getChannelId(), this.bytesCount);
                    this.bytesCount = 0L;
                }
                if (this.lineCount > 512L) {
                    this.statisticManager.incrementDataLoaded(this.context.getChannelId(), this.lineCount);
                    this.lineCount = 0L;
                }
                if ((executeTimeInMs = System.currentTimeMillis() - ts) <= 600000L) continue;
                log.warn("LongRunningOperation", "loaded " + this.stats.getLineCount() + " data so far for batch " + this.context.getBatchId(), executeTimeInMs);
                ts = System.currentTimeMillis();
            }
            this.fireBatchComplete();
            this.connection.commit();
            this.fireBatchCommitted();
            long l = 0L;
            Object var14_11 = null;
            try {
                if (this.bytesCount > 0L) {
                    this.statisticManager.incrementDataBytesLoaded(this.context.getChannelId(), this.bytesCount);
                }
                if (this.lineCount > 0L) {
                    this.statisticManager.incrementDataLoaded(this.context.getChannelId(), this.lineCount);
                }
                this.cleanupAfterDataLoad();
                Object var16_13 = null;
            }
            catch (Throwable throwable) {
                Object var16_14 = null;
                try {
                    this.dbDialect.enableSyncTriggers(this.jdbcTemplate);
                }
                catch (Exception ex) {
                    log.error(ex);
                }
                throw throwable;
            }
            try {
                this.dbDialect.enableSyncTriggers(this.jdbcTemplate);
            }
            catch (Exception ex) {
                log.error(ex);
            }
            break block56;
            {
                catch (RuntimeException ex) {
                    this.rollback(ex);
                    throw ex;
                }
                catch (Exception ex) {
                    this.rollback(ex);
                    throw new RuntimeException(ex);
                }
            }
            catch (Throwable throwable) {
                Object var14_12 = null;
                try {
                    if (this.bytesCount > 0L) {
                        this.statisticManager.incrementDataBytesLoaded(this.context.getChannelId(), this.bytesCount);
                    }
                    if (this.lineCount > 0L) {
                        this.statisticManager.incrementDataLoaded(this.context.getChannelId(), this.lineCount);
                    }
                    this.cleanupAfterDataLoad();
                    Object var16_15 = null;
                }
                catch (Throwable throwable2) {
                    Object var16_16 = null;
                    try {
                        this.dbDialect.enableSyncTriggers(this.jdbcTemplate);
                    }
                    catch (Exception ex) {
                        log.error(ex);
                    }
                    throw throwable2;
                }
                try {
                    this.dbDialect.enableSyncTriggers(this.jdbcTemplate);
                }
                catch (Exception ex) {
                    log.error(ex);
                }
                throw throwable;
            }
        }
    }

    protected boolean willFiltersHandleMissingTable(DataLoaderContext context) {
        if (this.filters != null) {
            for (IDataLoaderFilter filter : this.filters) {
                if (!(filter instanceof IMissingTableHandler) || !((IMissingTableHandler)((Object)filter)).isHandlingMissingTable(context)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rollback(Exception ex) {
        try {
            try {
                this.connection.rollback();
            }
            catch (Exception ex2) {
                log.warn(ex2);
                Object var4_3 = null;
                this.fireBatchRolledback(ex);
            }
            Object var4_2 = null;
            this.fireBatchRolledback(ex);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.fireBatchRolledback(ex);
            throw throwable;
        }
    }

    protected boolean isMetaTokenParsed(String[] tokens) {
        boolean isMetaTokenParsed = true;
        if (tokens[0].equals("schema")) {
            this.context.setSchemaName(StringUtils.isBlank((String)tokens[1]) ? null : tokens[1]);
        } else if (tokens[0].equals("catalog")) {
            this.context.setCatalogName(StringUtils.isBlank((String)tokens[1]) ? null : tokens[1]);
        } else if (tokens[0].equals("table")) {
            this.context.setTableName(tokens[1]);
            this.resetTable();
        } else if (tokens[0].equals("keys")) {
            this.context.setKeyNames((String[])ArrayUtils.subarray((Object[])tokens, (int)1, (int)tokens.length));
        } else if (tokens[0].equals("columns")) {
            this.context.setColumnNames((String[])ArrayUtils.subarray((Object[])tokens, (int)1, (int)tokens.length));
        } else if (tokens[0].equals("binary")) {
            this.context.setBinaryEncodingType(tokens[1]);
        } else if (tokens[0].equals("channel")) {
            this.context.setChannelId(tokens[1]);
        } else {
            isMetaTokenParsed = false;
        }
        return isMetaTokenParsed;
    }

    protected void resetTable() {
        this.cleanupAfterDataLoad();
        this.context.chooseTableTemplate();
        if (this.context.getTableTemplate() == null) {
            this.context.setTableTemplate(new TableTemplate(this.jdbcTemplate, this.dbDialect, this.context.getTableName(), this.columnFilters != null ? this.columnFilters.get(this.context.getTableName()) : null, this.parameterService.is("dont.include.keys.in.update.statement"), this.context.getSchemaName(), this.context.getCatalogName()));
        }
        this.prepareTableForDataLoad();
    }

    protected void prepareTableForDataLoad() {
        if (this.context != null && this.context.getTableTemplate() != null) {
            this.dbDialect.allowIdentityInserts(this.jdbcTemplate, this.context.getTableTemplate().getTable());
        }
    }

    protected void cleanupAfterDataLoad() {
        if (this.context != null && this.context.getTableTemplate() != null) {
            this.dbDialect.revertAllowIdentityInserts(this.jdbcTemplate, this.context.getTableTemplate().getTable());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int insert(String[] tokens) {
        this.stats.incrementStatementCount();
        String[] columnValues = this.context.getTableTemplate().parseColumns(tokens, 1);
        int rows = 0;
        boolean continueToLoad = true;
        if (this.filters != null) {
            this.stats.startTimer();
            for (IDataLoaderFilter filter : this.filters) {
                continueToLoad &= filter.filterInsert(this.context, columnValues);
            }
            this.stats.incrementFilterMillis(this.stats.endTimer());
        }
        if (continueToLoad) {
            String[] keyValues = this.context.getTableTemplate().parseKeys(tokens, 1);
            boolean attemptFallbackUpdate = false;
            RuntimeException insertException = null;
            try {
                block11: {
                    this.stats.startTimer();
                    try {
                        rows = this.context.getTableTemplate().insert(this.context, columnValues, keyValues);
                        if (rows == 0 && !(attemptFallbackUpdate = this.parameterService.is("dataloader.enable.fallback.update"))) {
                            throw new SymmetricException("LoaderInsertingFailed", (Throwable)insertException, this.context.getTableTemplate().getTable().toVerboseString(), ArrayUtils.toString((Object)tokens));
                        }
                    }
                    catch (RuntimeException e) {
                        insertException = e;
                        boolean bl = attemptFallbackUpdate = this.dbDialect.isPrimaryKeyViolation(e) && this.parameterService.is("dataloader.enable.fallback.update");
                        if (attemptFallbackUpdate) break block11;
                        throw e;
                    }
                }
                if (attemptFallbackUpdate) {
                    if (log.isDebugEnabled()) {
                        log.debug("LoaderInsertingFailedUpdating", this.context.getTableName(), ArrayUtils.toString((Object)tokens));
                    }
                    this.stats.incrementFallbackUpdateCount();
                    rows = this.context.getTableTemplate().update(this.context, columnValues, keyValues);
                    if (rows == 0) {
                        throw new SymmetricException("LoaderFallbackUpdateFailed", (Throwable)insertException, this.context.getTableTemplate().getTable().toVerboseString(), ArrayUtils.toString((Object)tokens), ArrayUtils.toString((Object)keyValues));
                    }
                }
                Object var10_10 = null;
                this.stats.incrementDatabaseMillis(this.stats.endTimer());
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                this.stats.incrementDatabaseMillis(this.stats.endTimer());
                throw throwable;
            }
        }
        return rows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int update(String[] tokens) {
        try {
            this.stats.incrementStatementCount();
            TableTemplate tableTemplate = this.context.getTableTemplate();
            String[] columnValues = tableTemplate.parseColumns(tokens, 1);
            String[] keyValues = tableTemplate.parseKeys(tokens, 1 + columnValues.length);
            int rows = 0;
            boolean continueToLoad = true;
            if (this.filters != null) {
                this.stats.startTimer();
                for (IDataLoaderFilter filter : this.filters) {
                    continueToLoad &= filter.filterUpdate(this.context, columnValues, keyValues);
                }
                this.stats.incrementFilterMillis(this.stats.endTimer());
            }
            if (continueToLoad) {
                boolean enableFallbackInsert = this.parameterService.is("dataloader.enable.fallback.insert");
                this.stats.startTimer();
                rows = this.context.getTableTemplate().update(this.context, columnValues, keyValues);
                if (rows == 0) {
                    if (!enableFallbackInsert) {
                        this.stats.incrementDatabaseMillis(this.stats.endTimer());
                        throw new SymmetricException("LoaderUpdatingFailed", this.context.getTableName(), ArrayUtils.toString((Object)tokens));
                    }
                    log.debug("LoaderUpdatingFailedInserting", this.context.getTableName(), ArrayUtils.toString((Object)tokens));
                    this.stats.incrementFallbackInsertCount();
                    rows = this.context.getTableTemplate().insert(this.context, columnValues, keyValues);
                } else if (rows > 1) {
                    log.warn("LoaderRowsUpdatingFailed", rows, this.context.getTableName(), ArrayUtils.toString((Object)tokens));
                } else if (rows < 0) {
                    rows = this.context.getTableTemplate().delete(this.context, keyValues);
                    rows = this.context.getTableTemplate().insert(this.context, columnValues, keyValues);
                }
                this.stats.incrementDatabaseMillis(this.stats.endTimer());
            }
            int n = rows;
            Object var10_11 = null;
            this.context.getTableTemplate().setOldData(null);
            return n;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            this.context.getTableTemplate().setOldData(null);
            throw throwable;
        }
    }

    protected int delete(String[] tokens) {
        this.stats.incrementStatementCount();
        String[] keyValues = this.context.getTableTemplate().parseKeys(tokens, 1);
        int rows = 0;
        boolean continueToLoad = true;
        if (this.filters != null) {
            this.stats.startTimer();
            for (IDataLoaderFilter filter : this.filters) {
                continueToLoad &= filter.filterDelete(this.context, keyValues);
            }
            this.stats.incrementFilterMillis(this.stats.endTimer());
        }
        if (continueToLoad) {
            boolean allowMissingDelete = this.parameterService.is("dataloader.allow.missing.delete");
            this.stats.startTimer();
            rows = this.context.getTableTemplate().delete(this.context, keyValues);
            this.stats.incrementDatabaseMillis(this.stats.endTimer());
            if (rows == 0) {
                if (allowMissingDelete) {
                    log.warn("LoaderDeleteMissing", this.context.getTableName(), ArrayUtils.toString((Object)tokens));
                    this.stats.incrementMissingDeleteCount();
                } else {
                    throw new SymmetricException("LoaderDeleteMissing", this.context.getTableName(), ArrayUtils.toString((Object)tokens));
                }
            }
        }
        return rows;
    }

    protected void runSql(String sql) {
        this.stats.incrementStatementCount();
        log.debug("ScriptRunning", sql);
        this.jdbcTemplate.execute(sql);
        if (this.context.getTableTemplate() != null) {
            this.context.getTableTemplate().resetMetaData(false);
        }
    }

    protected void runDdl(String xml) {
        this.stats.incrementStatementCount();
        log.debug("DDLRunning", xml);
        this.dbDialect.createTables(xml);
        if (this.context.getTableTemplate() != null) {
            this.context.getTableTemplate().resetMetaData(false);
        }
    }

    @Override
    public IDataLoader clone() {
        CsvLoader dataLoader = new CsvLoader();
        dataLoader.setDbDialect(this.dbDialect);
        dataLoader.setParameterService(this.parameterService);
        dataLoader.setNodeService(this.nodeService);
        dataLoader.setStatisticManager(this.statisticManager);
        return dataLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void close() {
        try {
            if (this.csvReader != null) {
                this.csvReader.close();
            }
            var2_1 = null;
            ** if (this.connection == null) goto lbl-1000
        }
        catch (Throwable var1_13) {
            var2_2 = null;
            if (this.connection != null) {
                try {
                    try {
                        this.connection.setAutoCommit(this.oldAutoCommitSetting);
                        this.connection.close();
                    }
                    catch (SQLException ex) {
                        CsvLoader.log.error(ex);
                        var5_7 = null;
                        this.connection = null;
                    }
                    var5_6 = null;
                    this.connection = null;
                }
                catch (Throwable var4_12) {
                    var5_8 = null;
                    this.connection = null;
                    throw var4_12;
                }
            }
            throw var1_13;
        }
lbl-1000:
        // 1 sources

        {
            try {
                try {
                    this.connection.setAutoCommit(this.oldAutoCommitSetting);
                    this.connection.close();
                }
                catch (SQLException ex) {
                    CsvLoader.log.error(ex);
                    var5_4 = null;
                    this.connection = null;
                }
                var5_3 = null;
                this.connection = null;
            }
            catch (Throwable var4_11) {
                var5_5 = null;
                this.connection = null;
                throw var4_11;
            }
        }
lbl-1000:
        // 1 sources

        {
        }
    }

    private void fireEarlyCommit() {
        if (this.batchListeners != null) {
            long ts = System.currentTimeMillis();
            for (IBatchListener listener : this.batchListeners) {
                listener.earlyCommit(this, this.context.getBatch());
            }
            this.stats.setFilterMillis(this.stats.getFilterMillis() + (System.currentTimeMillis() - ts));
        }
    }

    private void fireBatchComplete() {
        if (this.batchListeners != null) {
            long ts = System.currentTimeMillis();
            for (IBatchListener listener : this.batchListeners) {
                listener.batchComplete(this, this.context.getBatch());
            }
            this.stats.setFilterMillis(this.stats.getFilterMillis() + (System.currentTimeMillis() - ts));
        }
    }

    private void fireBatchCommitted() {
        if (this.batchListeners != null) {
            long ts = System.currentTimeMillis();
            for (IBatchListener listener : this.batchListeners) {
                listener.batchCommitted(this, this.context.getBatch());
            }
            this.stats.setFilterMillis(this.stats.getFilterMillis() + (System.currentTimeMillis() - ts));
        }
    }

    private void fireBatchRolledback(Exception ex) {
        if (this.batchListeners != null) {
            long ts = System.currentTimeMillis();
            for (IBatchListener listener : this.batchListeners) {
                listener.batchRolledback(this, this.context.getBatch(), ex);
            }
            this.stats.setFilterMillis(this.stats.getFilterMillis() + (System.currentTimeMillis() - ts));
        }
    }

    @Override
    public IDataLoaderContext getContext() {
        return this.context;
    }

    @Override
    public IDataLoaderStatistics getStatistics() {
        return this.stats;
    }

    public void setDbDialect(IDbDialect dbDialect) {
        this.dbDialect = dbDialect;
    }

    public void setParameterService(IParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setNodeService(INodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setStatisticManager(IStatisticManager statisticManager) {
        this.statisticManager = statisticManager;
    }
}

