/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.load;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.jumpmind.symmetric.db.IDbDialect;
import org.jumpmind.symmetric.ddl.model.Column;
import org.jumpmind.symmetric.ddl.model.Table;
import org.jumpmind.symmetric.load.IColumnFilter;
import org.jumpmind.symmetric.load.IDataLoaderContext;
import org.jumpmind.symmetric.load.StatementBuilder;
import org.jumpmind.symmetric.util.ArgTypePreparedStatementSetter;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementSetter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableTemplate {
    private JdbcTemplate jdbcTemplate;
    private IDbDialect dbDialect;
    private Table table;
    private String schema;
    private String catalog;
    private String tableName;
    private String[] keyNames;
    private String[] columnNames;
    private String[] filteredColumnNames;
    private String[] oldData;
    private Map<String, Column> allMetaData;
    private HashMap<StatementBuilder.DmlType, StatementBuilder> statementMap;
    private List<IColumnFilter> columnFilters = new ArrayList<IColumnFilter>();
    private boolean dontIncludeKeysInUpdateStatement = false;

    public TableTemplate(JdbcTemplate jdbcTemplate, IDbDialect dbDialect, String tableName, List<IColumnFilter> columnFilters, boolean dontIncludeKeysInUpdateStatement, String schema, String catalog) {
        this.jdbcTemplate = jdbcTemplate;
        this.dbDialect = dbDialect;
        this.tableName = tableName;
        this.schema = StringUtils.isBlank((String)schema) ? null : schema;
        this.catalog = StringUtils.isBlank((String)catalog) ? null : catalog;
        this.setupColumnFilters(columnFilters, dbDialect);
        this.dontIncludeKeysInUpdateStatement = dontIncludeKeysInUpdateStatement;
        this.resetMetaData(true);
    }

    public void resetMetaData(boolean useCache) {
        this.table = this.dbDialect.getTable(this.catalog, this.schema, this.tableName, useCache);
        this.allMetaData = new HashMap<String, Column>();
        this.statementMap = new HashMap();
        if (this.table != null) {
            for (Column column : this.table.getColumns()) {
                this.allMetaData.put(column.getName().trim().toUpperCase(), column);
            }
        }
    }

    private void setupColumnFilters(List<IColumnFilter> pluginFilters, IDbDialect dbDialect) {
        IColumnFilter filter;
        if (pluginFilters != null) {
            for (IColumnFilter columnFilter : pluginFilters) {
                this.columnFilters.add(columnFilter);
            }
        }
        if ((filter = dbDialect.newDatabaseColumnFilter()) != null) {
            this.columnFilters.add(filter);
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    public final boolean isIgnoreThisTable() {
        return this.table == null;
    }

    public int insert(IDataLoaderContext ctx, String[] columnValues, String[] keyValues) {
        StatementBuilder st = this.getStatementBuilder(ctx, StatementBuilder.DmlType.INSERT, this.columnNames);
        return this.execute(ctx, st, columnValues, keyValues);
    }

    public int update(IDataLoaderContext ctx, String[] columnValues, String[] keyValues) {
        StatementBuilder st = null;
        ArrayList<String> changedColumnNameList = new ArrayList<String>();
        ArrayList<String> changedColumnValueList = new ArrayList<String>();
        ArrayList<Column> changedColumnMetaList = new ArrayList<Column>();
        for (int i = 0; i < columnValues.length; ++i) {
            Column column = this.allMetaData.get(this.columnNames[i].trim().toUpperCase());
            if (column == null || !this.doesColumnNeedUpdated(ctx, i, column, keyValues, columnValues)) continue;
            if (column.isDistributionKey()) {
                return -1;
            }
            changedColumnNameList.add(this.columnNames[i]);
            changedColumnMetaList.add(column);
            changedColumnValueList.add(columnValues[i]);
        }
        if (changedColumnNameList.size() > 0) {
            st = this.getStatementBuilder(ctx, StatementBuilder.DmlType.UPDATE, changedColumnNameList.toArray(new String[changedColumnNameList.size()]));
            columnValues = changedColumnValueList.toArray(new String[changedColumnValueList.size()]);
            if (keyValues == null || keyValues.length == 0) {
                keyValues = this.oldData;
            }
            return this.execute(ctx, st, columnValues, keyValues);
        }
        return 1;
    }

    private final boolean doesColumnNeedUpdated(IDataLoaderContext ctx, int columnIndex, Column column, String[] keyValues, String[] columnValues) {
        boolean needsUpdated = true;
        if (this.oldData != null) {
            needsUpdated = !StringUtils.equals((String)columnValues[columnIndex], (String)this.oldData[columnIndex]) || this.dbDialect.isLob(column.getTypeCode()) && (this.dbDialect.needsToSelectLobData() || StringUtils.isBlank((String)this.oldData[columnIndex]));
        } else if (this.dontIncludeKeysInUpdateStatement) {
            needsUpdated = !column.isPrimaryKey() || !StringUtils.equals((String)columnValues[columnIndex], (String)this.getKeyValue(ctx, column, keyValues));
        }
        return needsUpdated;
    }

    protected String getKeyValue(IDataLoaderContext ctx, Column column, String[] keyValues) {
        int index = ctx.getKeyIndex(column.getName());
        if (index >= 0 && keyValues != null && keyValues.length > index) {
            return keyValues[index];
        }
        return null;
    }

    public int delete(IDataLoaderContext ctx, String[] keyValues) {
        StatementBuilder st = this.getStatementBuilder(ctx, StatementBuilder.DmlType.DELETE, this.columnNames);
        if (keyValues == null || keyValues.length == 0) {
            keyValues = this.oldData;
        }
        return this.execute(ctx, st, null, keyValues);
    }

    public int count(IDataLoaderContext ctx, String[] keyValues) {
        StatementBuilder st = this.getStatementBuilder(ctx, StatementBuilder.DmlType.COUNT, this.columnNames);
        if (this.columnFilters != null) {
            for (IColumnFilter columnFilter : this.columnFilters) {
                keyValues = columnFilter.filterColumnsValues(ctx, st.getDmlType(), this.getTable(), keyValues);
            }
        }
        Object[] objectValues = this.dbDialect.getObjectValues(ctx.getBinaryEncoding(), keyValues, st.getKeys());
        return this.jdbcTemplate.queryForInt(st.getSql(), objectValues, st.getTypes());
    }

    public String getFullyQualifiedTableName() {
        return this.getFullyQualifiedTableName(false);
    }

    public String getFullyQualifiedTableName(boolean preventQuotes) {
        String quote = !preventQuotes ? this.dbDialect.getIdentifierQuoteString() : "";
        String tableName = quote + (this.table != null ? this.table.getName() : this.tableName) + quote;
        if (!StringUtils.isBlank((String)this.schema)) {
            tableName = this.schema + "." + tableName;
        }
        if (!StringUtils.isBlank((String)this.catalog)) {
            tableName = this.catalog + "." + tableName;
        }
        return tableName;
    }

    private final StatementBuilder getStatementBuilder(IDataLoaderContext ctx, StatementBuilder.DmlType type, String[] preFilteredColumnNames) {
        StatementBuilder st = this.statementMap.get((Object)type);
        if (st == null) {
            this.filteredColumnNames = preFilteredColumnNames;
            if (this.columnFilters != null) {
                for (IColumnFilter columnFilter : this.columnFilters) {
                    this.filteredColumnNames = columnFilter.filterColumnsNames(ctx, type, this.getTable(), this.filteredColumnNames);
                }
            }
            String tableName = this.getFullyQualifiedTableName();
            String[] lookupColumnNames = this.keyNames;
            if (type == StatementBuilder.DmlType.UPDATE || type == StatementBuilder.DmlType.DELETE) {
                lookupColumnNames = this.getLookupValues();
            }
            st = this.dbDialect.createStatementBuilder(type, tableName, this.getColumnMetaData(lookupColumnNames), this.getColumnMetaData(this.filteredColumnNames), this.getColumnMetaData(preFilteredColumnNames));
            if (type != StatementBuilder.DmlType.UPDATE) {
                this.statementMap.put(type, st);
            }
        }
        return st;
    }

    protected String[] getLookupValues() {
        if (this.keyNames == null || this.keyNames.length == 0) {
            return this.columnNames;
        }
        return this.keyNames;
    }

    public Object[] getObjectValues(IDataLoaderContext ctx, String[] values) {
        return this.dbDialect.getObjectValues(ctx.getBinaryEncoding(), values, this.getColumnMetaData(this.columnNames));
    }

    public Object[] getObjectKeyValues(IDataLoaderContext ctx, String[] values) {
        return this.dbDialect.getObjectValues(ctx.getBinaryEncoding(), values, this.getColumnMetaData(this.keyNames));
    }

    private final int execute(IDataLoaderContext ctx, StatementBuilder st, String[] columnValues, String[] keyValues) {
        if (this.columnFilters != null) {
            for (IColumnFilter columnFilter : this.columnFilters) {
                columnValues = columnFilter.filterColumnsValues(ctx, st.getDmlType(), this.getTable(), columnValues);
            }
        }
        Object[] objectValues = this.dbDialect.getObjectValues(ctx.getBinaryEncoding(), st.getValueArray(columnValues, keyValues), st.getMetaData(false));
        return this.jdbcTemplate.update(st.getSql(), (PreparedStatementSetter)new ArgTypePreparedStatementSetter(objectValues, st.getTypes(), this.dbDialect.getLobHandler()));
    }

    public String[] parseKeys(String[] tokens, int startIndex) {
        if (this.keyNames == null) {
            return null;
        }
        if (this.keyNames.length == 0) {
            return new String[0];
        }
        int keyLength = this.getKeyNames().length;
        return this.parseValues("key", tokens, startIndex, startIndex + keyLength);
    }

    public String[] parseValues(String name, String[] tokens, int startIndex, int endIndex) {
        if (tokens.length < endIndex) {
            throw new RuntimeException("Expected to have " + (endIndex - startIndex) + " " + name + " values for " + this.getTableName() + ": " + ArrayUtils.toString((Object)tokens));
        }
        return (String[])ArrayUtils.subarray((Object[])tokens, (int)startIndex, (int)endIndex);
    }

    public String[] parseColumns(String[] tokens, int startIndex) {
        if (this.getColumnNames() == null) {
            throw new RuntimeException("Column names were not specified for table " + this.getTableName());
        }
        int columnLength = this.getColumnNames().length;
        return this.parseValues("column", tokens, startIndex, startIndex + columnLength);
    }

    public void setKeyNames(String[] keyNames) {
        this.keyNames = keyNames;
        this.clear();
    }

    public void setColumnNames(String[] columnNames) {
        this.columnNames = columnNames;
        this.clear();
    }

    public void setOldData(String[] oldData) {
        this.oldData = oldData;
    }

    private final void clear() {
        this.statementMap.clear();
        this.oldData = null;
    }

    private final Column[] getColumnMetaData(String[] names) {
        if (names != null) {
            Column[] columns = new Column[names.length];
            for (int i = 0; i < names.length; ++i) {
                columns[i] = this.allMetaData.get(names[i].trim().toUpperCase());
            }
            return columns;
        }
        return new Column[0];
    }

    public String[] getKeyNames() {
        return this.keyNames;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public String[] getFilteredColumnNames() {
        return this.filteredColumnNames != null ? this.filteredColumnNames : this.columnNames;
    }

    public Table getTable() {
        return this.table;
    }

    public String[] getOldData() {
        return this.oldData;
    }
}

