/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.job;

import org.jumpmind.symmetric.job.AbstractJob;
import org.jumpmind.symmetric.model.RemoteNodeStatuses;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.IPullService;

public class PullJob
extends AbstractJob {
    private IPullService pullService;
    private INodeService nodeService;

    public long doJob() throws Exception {
        RemoteNodeStatuses statuses = this.pullService.pullData();
        while (this.nodeService.isDataLoadStarted() && !statuses.errorOccurred() && statuses.wasBatchProcessed()) {
            this.log.info("DataPullingInReloadMode");
            statuses = this.pullService.pullData();
        }
        return statuses.getDataProcessedCount();
    }

    public String getClusterLockName() {
        return "PULL";
    }

    public boolean isClusterable() {
        return true;
    }

    public void setPullService(IPullService service) {
        this.pullService = service;
    }

    public void setNodeService(INodeService nodeService) {
        this.nodeService = nodeService;
    }
}

