/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.job;

import java.util.List;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;
import org.jumpmind.symmetric.job.IJob;
import org.jumpmind.symmetric.job.IJobManager;
import org.jumpmind.symmetric.service.IParameterService;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobManager
implements IJobManager {
    ILog log = LogFactory.getLog(JobManager.class);
    private List<IJob> jobs;
    private ThreadPoolTaskScheduler taskScheduler;

    @Override
    public IJob getJob(String name) {
        for (IJob job : this.jobs) {
            if (!job.getName().equals(name)) continue;
            return job;
        }
        return null;
    }

    @Override
    public synchronized void startJobs() {
        for (IJob job : this.jobs) {
            if (job.isAutoStartConfigured()) {
                job.start();
                continue;
            }
            this.log.info("JobNoAutoStart", job.getName());
        }
    }

    @Override
    public synchronized void stopJobs() {
        for (IJob job : this.jobs) {
            job.stop();
        }
    }

    @Override
    public synchronized void destroy() {
        this.stopJobs();
        if (this.taskScheduler != null) {
            this.taskScheduler.shutdown();
        }
    }

    public void setJobs(List<IJob> jobs) {
        this.jobs = jobs;
    }

    @Override
    public List<IJob> getJobs() {
        return this.jobs;
    }

    public void setTaskScheduler(ThreadPoolTaskScheduler taskScheduler) {
        this.taskScheduler = taskScheduler;
    }

    public void setParameterService(IParameterService parameterService) {
        this.log = LogFactory.getLog(parameterService);
    }
}

