/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.job;

import java.util.Date;
import java.util.concurrent.ScheduledFuture;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.StandaloneSymmetricEngine;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;
import org.jumpmind.symmetric.job.IJob;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.service.IRegistrationService;
import org.jumpmind.symmetric.statistic.IStatisticManager;
import org.jumpmind.symmetric.util.RandomTimeSlot;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedMetric;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.support.CronTrigger;

@ManagedResource(description="The management interface for a job")
public abstract class AbstractJob
implements Runnable,
BeanNameAware,
IJob {
    protected DataSource dataSource;
    protected ILog log = LogFactory.getLog(this.getClass());
    protected IParameterService parameterService;
    private String jobName;
    private boolean requiresRegistration = true;
    private IRegistrationService registrationService;
    private boolean paused = false;
    private Date lastFinishTime;
    private boolean running = false;
    private long lastExecutionTimeInMs;
    private long totalExecutionTimeInMs;
    private long lastExecutionProcessCount = 0L;
    private long numberOfRuns;
    private boolean started;
    private long timeBetweenRunsInMs = -1L;
    private String cronExpression;
    private boolean hasNotRegisteredMessageBeenLogged = false;
    private ThreadPoolTaskScheduler taskScheduler;
    private String autoStartParameterName;
    private ScheduledFuture<?> scheduledJob;
    private RandomTimeSlot randomTimeSlot;
    private boolean autoStartConfigured;
    protected IStatisticManager statisticManager;

    protected void init() {
        this.autoStartConfigured = this.parameterService.is(this.autoStartParameterName);
        this.cronExpression = this.parameterService.getString(this.jobName + ".cron", null);
        this.timeBetweenRunsInMs = this.parameterService.getInt(this.jobName + ".period.time.ms", -1);
    }

    public boolean isAutoStartConfigured() {
        return this.autoStartConfigured;
    }

    public void start() {
        if (this.scheduledJob == null) {
            this.log.info("JobStarting", this.jobName);
            if (!StringUtils.isBlank((String)this.cronExpression)) {
                this.scheduledJob = this.taskScheduler.schedule((Runnable)this, (Trigger)new CronTrigger(this.cronExpression));
                this.started = true;
            } else {
                int startDelay = this.randomTimeSlot.getRandomValueSeededByExternalId();
                if (this.timeBetweenRunsInMs > 0L) {
                    this.scheduledJob = this.taskScheduler.scheduleWithFixedDelay((Runnable)this, new Date(System.currentTimeMillis() + (long)startDelay), this.timeBetweenRunsInMs);
                    this.started = true;
                } else {
                    this.log.error("JobFailedToSchedule", this.jobName);
                }
            }
        }
    }

    public boolean stop() {
        boolean success = false;
        if (this.scheduledJob != null) {
            success = this.scheduledJob.cancel(true);
            this.scheduledJob = null;
            if (success) {
                this.log.info("JobCancelled", this.jobName);
                this.started = false;
            } else {
                this.log.warn("JobFailedToCancel", this.jobName);
            }
        }
        return success;
    }

    public String getName() {
        return this.jobName;
    }

    @ManagedOperation(description="Run this job is it isn't already running")
    public boolean invoke() {
        return this.invoke(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean invoke(boolean force) {
        boolean ran;
        block14: {
            ran = false;
            try {
                ISymmetricEngine engine = StandaloneSymmetricEngine.findEngineByName(this.parameterService.getString("engine.name"));
                if (engine == null) {
                    this.log.info("SymmetricEngineMissing", this.jobName);
                    break block14;
                }
                if (engine.isStarted()) {
                    if (this.paused && !force || this.running) break block14;
                    this.running = true;
                    AbstractJob abstractJob = this;
                    synchronized (abstractJob) {
                        ran = true;
                        long startTime = System.currentTimeMillis();
                        long processCount = 0L;
                        try {
                            if (!this.requiresRegistration || this.requiresRegistration && this.registrationService.isRegisteredWithServer()) {
                                this.hasNotRegisteredMessageBeenLogged = false;
                                processCount = this.doJob();
                            } else if (!this.hasNotRegisteredMessageBeenLogged) {
                                this.log.warn("SymmetricEngineNotRegistered", this.getName());
                                this.hasNotRegisteredMessageBeenLogged = true;
                            }
                            Object var10_8 = null;
                            this.lastFinishTime = new Date();
                            this.lastExecutionProcessCount = processCount;
                        }
                        catch (Throwable throwable) {
                            Object var10_9 = null;
                            this.lastFinishTime = new Date();
                            this.lastExecutionProcessCount = processCount;
                            long endTime = System.currentTimeMillis();
                            this.lastExecutionTimeInMs = endTime - startTime;
                            this.totalExecutionTimeInMs += this.lastExecutionTimeInMs;
                            if (this.lastExecutionProcessCount > 0L || this.lastExecutionTimeInMs > 30000L) {
                                this.statisticManager.addJobStats(this.jobName, startTime, endTime, this.lastExecutionProcessCount);
                            }
                            ++this.numberOfRuns;
                            this.running = false;
                            throw throwable;
                        }
                        long endTime = System.currentTimeMillis();
                        this.lastExecutionTimeInMs = endTime - startTime;
                        this.totalExecutionTimeInMs += this.lastExecutionTimeInMs;
                        if (this.lastExecutionProcessCount > 0L || this.lastExecutionTimeInMs > 30000L) {
                            this.statisticManager.addJobStats(this.jobName, startTime, endTime, this.lastExecutionProcessCount);
                        }
                        ++this.numberOfRuns;
                        {
                        }
                        this.running = false;
                        break block14;
                    }
                }
                this.log.info("SymmetricEngineNotStarted");
            }
            catch (Throwable ex) {
                this.log.error(ex);
            }
        }
        return ran;
    }

    public void run() {
        this.invoke(false);
    }

    abstract long doJob() throws Exception;

    public void setBeanName(String beanName) {
        this.jobName = beanName;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setParameterService(IParameterService parameterService) {
        this.parameterService = parameterService;
        this.log = LogFactory.getLog(parameterService);
    }

    public void setRequiresRegistration(boolean requiresRegistration) {
        this.requiresRegistration = requiresRegistration;
    }

    public void setRegistrationService(IRegistrationService registrationService) {
        this.registrationService = registrationService;
    }

    @ManagedOperation(description="Pause this job")
    public void pause() {
        this.setPaused(true);
    }

    @ManagedOperation(description="Resume the job")
    public void unpause() {
        this.setPaused(false);
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    @ManagedAttribute(description="If true, this job has been paused")
    public boolean isPaused() {
        return this.paused;
    }

    @ManagedAttribute(description="If true, this job has been started")
    public boolean isStarted() {
        return this.started;
    }

    @ManagedMetric(description="The amount of time this job spent in execution during it's last run")
    public long getLastExecutionTimeInMs() {
        return this.lastExecutionTimeInMs;
    }

    @ManagedMetric(description="The count of elements this job processed during it's last run")
    public long getLastExecutionProcessCount() {
        return this.lastExecutionProcessCount;
    }

    @ManagedAttribute(description="The last time this job completed execution")
    public Date getLastFinishTime() {
        return this.lastFinishTime;
    }

    @ManagedAttribute(description="If true, the job is already running")
    public boolean isRunning() {
        return this.running;
    }

    @ManagedMetric(description="The number of times this job has been run during the lifetime of the JVM")
    public long getNumberOfRuns() {
        return this.numberOfRuns;
    }

    @ManagedMetric(description="The total amount of time this job has spent in execution during the lifetime of the JVM")
    public long getTotalExecutionTimeInMs() {
        return this.totalExecutionTimeInMs;
    }

    @ManagedMetric(description="The total amount of time this job has spend in execution during the lifetime of the JVM")
    public long getAverageExecutionTimeInMs() {
        if (this.numberOfRuns > 0L) {
            return this.totalExecutionTimeInMs / this.numberOfRuns;
        }
        return 0L;
    }

    public void setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
    }

    @ManagedAttribute(description="If set, this is the cron expression that governs when the job will run")
    public String getCronExpression() {
        return this.cronExpression;
    }

    public void setTimeBetweenRunsInMs(long timeBetweenRunsInMs) {
        this.timeBetweenRunsInMs = timeBetweenRunsInMs;
    }

    @ManagedAttribute(description="If the cron expression isn't set.  This is the amount of time that will pass before the periodic job runs again.")
    public long getTimeBetweenRunsInMs() {
        return this.timeBetweenRunsInMs;
    }

    public void setTaskScheduler(ThreadPoolTaskScheduler taskScheduler) {
        this.taskScheduler = taskScheduler;
    }

    public void setAutoStartParameterName(String autoStartParameterName) {
        this.autoStartParameterName = autoStartParameterName;
    }

    public void setRandomTimeSlot(RandomTimeSlot randomTimeSlot) {
        this.randomTimeSlot = randomTimeSlot;
    }

    public void setStatisticManager(IStatisticManager statisticManager) {
        this.statisticManager = statisticManager;
    }
}

