/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.Writer;
import org.jumpmind.symmetric.util.AppUtils;

public class ThresholdFileWriter
extends Writer {
    private File file;
    private String tempFileCategory;
    private BufferedWriter fileWriter;
    private StringBuilder buffer;
    private long threshhold;

    public ThresholdFileWriter(long threshold, File file) {
        this.file = file;
        this.buffer = new StringBuilder();
        this.threshhold = threshold;
    }

    public ThresholdFileWriter(long threshold, String tempFileCategory) {
        this.tempFileCategory = tempFileCategory;
        this.buffer = new StringBuilder();
        this.threshhold = threshold;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void close() throws IOException {
        if (this.fileWriter != null) {
            this.fileWriter.close();
            this.fileWriter = null;
        }
    }

    public void flush() throws IOException {
        if (this.fileWriter != null) {
            this.fileWriter.flush();
        }
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this.fileWriter != null) {
            this.fileWriter.write(cbuf, off, len);
        } else if ((long)(len + this.buffer.length()) > this.threshhold) {
            if (this.file == null) {
                this.file = AppUtils.createTempFile(this.tempFileCategory == null ? "threshold.file.writer" : this.tempFileCategory);
            }
            this.fileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), "UTF-8"));
            this.fileWriter.write(this.buffer.toString());
            this.fileWriter.write(cbuf, off, len);
            this.fileWriter.flush();
        } else {
            this.buffer.append(new String(cbuf), off, len);
        }
    }

    public BufferedReader getReader() throws IOException {
        if (this.file != null && this.file.exists()) {
            return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), "UTF-8"));
        }
        return new BufferedReader(new StringReader(this.buffer.toString()));
    }

    public void reset() {
        this.file = null;
        this.fileWriter = null;
        this.buffer.setLength(0);
    }

    public void delete() {
        if (this.file != null && this.file.exists()) {
            this.file.delete();
        }
        this.file = null;
        this.buffer.setLength(0);
    }
}

