/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class GzipConfigurableOutputStream
extends DeflaterOutputStream {
    protected CRC32 crc = new CRC32();
    private static final int GZIP_MAGIC = 35615;

    public GzipConfigurableOutputStream(OutputStream out, int size, int compression) throws IOException {
        super(out, new Deflater(compression, true), size);
        this.writeHeader();
        this.crc.reset();
    }

    public GzipConfigurableOutputStream(OutputStream out, int compression) throws IOException {
        this(out, 512, compression);
    }

    public synchronized void write(byte[] buf, int off, int len) throws IOException {
        super.write(buf, off, len);
        this.crc.update(buf, off, len);
    }

    public void finish() throws IOException {
        if (!this.def.finished()) {
            this.def.finish();
            while (!this.def.finished()) {
                this.deflate();
            }
            this.writeTrailer();
        }
    }

    public void close() throws IOException {
        this.finish();
        this.out.close();
    }

    private void writeHeader() throws IOException {
        this.writeShort(35615);
        this.out.write(8);
        this.out.write(0);
        this.writeInt(0);
        this.out.write(0);
        this.out.write(0);
    }

    private void writeTrailer() throws IOException {
        this.writeInt((int)this.crc.getValue());
        this.writeInt(this.def.getTotalIn());
    }

    private void writeInt(int i) throws IOException {
        this.writeShort(i & 0xFFFF);
        this.writeShort(i >> 16 & 0xFFFF);
    }

    private void writeShort(int s) throws IOException {
        this.out.write(s & 0xFF);
        this.out.write(s >> 8 & 0xFF);
    }
}

