/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.extract.csv;

import java.io.IOException;
import java.io.Writer;
import org.jumpmind.symmetric.extract.DataExtractorContext;
import org.jumpmind.symmetric.extract.csv.AbstractStreamDataCommand;
import org.jumpmind.symmetric.model.Data;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.TriggerRouter;
import org.jumpmind.symmetric.service.IDataExtractorService;
import org.jumpmind.symmetric.service.INodeService;

class StreamReloadDataCommand
extends AbstractStreamDataCommand {
    private IDataExtractorService dataExtractorService;
    private INodeService nodeService;

    StreamReloadDataCommand() {
    }

    public void execute(Writer out, Data data, String routerId, DataExtractorContext context) throws IOException {
        String triggerId = data.getTriggerHistory().getTriggerId();
        TriggerRouter triggerRouter = this.triggerRouterService.findTriggerRouterById(triggerId, routerId);
        if (triggerRouter != null) {
            if (data.getRowData() != null) {
                triggerRouter.setInitialLoadSelect(data.getRowData());
            }
            Node node = this.nodeService.findNode(context.getBatch().getNodeId());
            this.dataExtractorService.extractInitialLoadWithinBatchFor(node, triggerRouter, out, context, data.getTriggerHistory());
            out.flush();
        } else {
            this.log.error("TriggerRouterUnavailable", triggerId, routerId);
        }
    }

    public void setDataExtractorService(IDataExtractorService dataExtractorService) {
        this.dataExtractorService = dataExtractorService;
    }

    public void setNodeService(INodeService nodeService) {
        this.nodeService = nodeService;
    }

    public boolean isTriggerHistoryRequired() {
        return true;
    }
}

