/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.extract.csv;

import java.io.IOException;
import java.io.Writer;
import org.apache.commons.lang.StringUtils;
import org.jumpmind.symmetric.extract.DataExtractorContext;
import org.jumpmind.symmetric.extract.csv.AbstractStreamDataCommand;
import org.jumpmind.symmetric.model.Data;
import org.jumpmind.symmetric.util.CsvUtils;

class StreamInsertDataCommand
extends AbstractStreamDataCommand {
    StreamInsertDataCommand() {
    }

    public void execute(Writer writer, Data data, String routerId, DataExtractorContext context) throws IOException {
        this.selectAndEnhanceWithLobsIfEnabled(data, context);
        String rowData = data.getRowData();
        if (!StringUtils.isBlank((String)rowData)) {
            context.incrementByteCount(CsvUtils.write(writer, "insert", ", ", rowData));
            CsvUtils.writeLineFeed(writer);
            context.incrementDataEventCount();
        } else {
            this.log.error("DataExtractorMissingRowData", data.getDataId());
        }
    }

    public boolean isTriggerHistoryRequired() {
        return true;
    }
}

