/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.extract.csv;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.jumpmind.symmetric.db.IDbDialect;
import org.jumpmind.symmetric.extract.DataExtractorContext;
import org.jumpmind.symmetric.extract.IDataExtractor;
import org.jumpmind.symmetric.extract.csv.IStreamDataCommand;
import org.jumpmind.symmetric.model.Data;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.OutgoingBatch;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.util.CsvUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsvExtractor14
implements IDataExtractor {
    private Map<String, String> legacyTableMapping = new HashMap<String, String>();
    protected Map<String, IStreamDataCommand> dictionary = null;
    protected IParameterService parameterService;
    protected IDbDialect dbDialect;
    protected INodeService nodeService;

    public CsvExtractor14() {
        this.legacyTableMapping.put("sym_trigger", "sym_trigger_old");
    }

    @Override
    public void init(Writer writer, DataExtractorContext context) throws IOException {
        Node nodeIdentity = this.nodeService.findIdentity();
        String nodeId = nodeIdentity == null ? this.parameterService.getString("external.id") : nodeIdentity.getNodeId();
        context.incrementByteCount(CsvUtils.write(writer, "nodeid", ", ", nodeId));
        CsvUtils.writeLineFeed(writer);
    }

    @Override
    public void begin(OutgoingBatch batch, Writer writer) throws IOException {
        batch.incrementByteCount(CsvUtils.write(writer, "batch", ", ", Long.toString(batch.getBatchId())));
        CsvUtils.writeLineFeed(writer);
        batch.incrementByteCount(CsvUtils.write(writer, "binary", ", ", this.dbDialect.getBinaryEncoding().name()));
        CsvUtils.writeLineFeed(writer);
    }

    @Override
    public void commit(OutgoingBatch batch, Writer writer) throws IOException {
        batch.incrementByteCount(CsvUtils.write(writer, "commit", ", ", Long.toString(batch.getBatchId())));
        CsvUtils.writeLineFeed(writer);
    }

    @Override
    public void write(Writer writer, Data data, String routerId, DataExtractorContext context) throws IOException {
        this.preprocessTable(data, routerId, writer, context);
        this.dictionary.get(data.getEventType().getCode()).execute(writer, data, routerId, context);
    }

    @Override
    public void preprocessTable(Data data, String routerId, Writer out, DataExtractorContext context) throws IOException {
        if (data.getTriggerHistory() != null) {
            String historyId = Integer.toString(data.getTriggerHistory().getTriggerHistoryId()).intern();
            if (!context.getHistoryRecordsWritten().contains(historyId)) {
                CsvUtils.write(out, "table", ", ", data.getTableName());
                CsvUtils.writeLineFeed(out);
                CsvUtils.write(out, "keys", ", ", data.getTriggerHistory().getPkColumnNames());
                CsvUtils.writeLineFeed(out);
                CsvUtils.write(out, "columns", ", ", data.getTriggerHistory().getColumnNames());
                CsvUtils.writeLineFeed(out);
                context.addHistoryRecordWritten(data.getTableName(), historyId);
            } else if (!context.isLastDataFromSameTriggerAndRouter(historyId, routerId)) {
                CsvUtils.write(out, "table", ", ", data.getTableName());
                CsvUtils.writeLineFeed(out);
            }
            context.setLastRouterId(routerId);
            context.setLastTriggerHistoryId(historyId);
        }
    }

    public void setDictionary(Map<String, IStreamDataCommand> dictionary) {
        this.dictionary = dictionary;
    }

    public void setDbDialect(IDbDialect dbDialect) {
        this.dbDialect = dbDialect;
    }

    public void setParameterService(IParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setNodeService(INodeService nodeService) {
        this.nodeService = nodeService;
    }

    @Override
    public String getLegacyTableName(String currentTableName) {
        String result = currentTableName;
        if (this.legacyTableMapping.get(currentTableName.toLowerCase()) != null) {
            result = this.legacyTableMapping.get(currentTableName.toLowerCase());
        }
        return result;
    }
}

