/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.extract.csv;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.jumpmind.symmetric.db.IDbDialect;
import org.jumpmind.symmetric.extract.DataExtractorContext;
import org.jumpmind.symmetric.extract.IDataExtractor;
import org.jumpmind.symmetric.extract.csv.IStreamDataCommand;
import org.jumpmind.symmetric.model.Data;
import org.jumpmind.symmetric.model.OutgoingBatch;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.util.CsvUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsvExtractor13
implements IDataExtractor {
    private Map<String, IStreamDataCommand> dictionary = null;
    private IParameterService parameterService;
    private IDbDialect dbDialect;
    private String tablePrefix;

    @Override
    public void init(Writer writer, DataExtractorContext context) throws IOException {
        CsvUtils.write(writer, "nodeid", ", ", this.parameterService.getString("external.id"));
        CsvUtils.writeLineFeed(writer);
    }

    @Override
    public void begin(OutgoingBatch batch, Writer writer) throws IOException {
        CsvUtils.write(writer, "batch", ", ", Long.toString(batch.getBatchId()));
        CsvUtils.writeLineFeed(writer);
        CsvUtils.write(writer, "binary", ", ", this.dbDialect.getBinaryEncoding().name());
        CsvUtils.writeLineFeed(writer);
    }

    @Override
    public void commit(OutgoingBatch batch, Writer writer) throws IOException {
        CsvUtils.write(writer, "commit", ", ", Long.toString(batch.getBatchId()));
        CsvUtils.writeLineFeed(writer);
    }

    @Override
    public void write(Writer writer, Data data, String routerId, DataExtractorContext context) throws IOException {
        this.preprocessTable(data, routerId, writer, context);
        this.dictionary.get(data.getEventType().getCode()).execute(writer, data, routerId, context);
    }

    @Override
    public void preprocessTable(Data data, String routerId, Writer out, DataExtractorContext context) throws IOException {
        if (data.getTriggerHistory() == null) {
            throw new RuntimeException("Missing trigger_hist for table " + data.getTableName() + ": try running syncTriggers() or restarting SymmetricDS");
        }
        String historyId = Integer.toString(data.getTriggerHistory().getTriggerHistoryId()).intern();
        if (!context.getHistoryRecordsWritten().contains(historyId)) {
            CsvUtils.write(out, "table, ", data.getTableName());
            CsvUtils.writeLineFeed(out);
            CsvUtils.write(out, "keys, ", data.getTriggerHistory().getPkColumnNames());
            CsvUtils.writeLineFeed(out);
            String columns = data.getTriggerHistory().getColumnNames();
            if (data.getTableName().equalsIgnoreCase(this.tablePrefix + "_node_security")) {
                columns = columns.replaceFirst(",node_password,", ",password,");
                columns = columns.replaceFirst(",NODE_PASSWORD,", ",PASSWORD,");
            }
            CsvUtils.write(out, "columns, ", columns);
            CsvUtils.writeLineFeed(out);
            context.addHistoryRecordWritten(data.getTableName(), historyId);
        } else if (!context.isLastDataFromSameTriggerAndRouter(historyId, routerId)) {
            CsvUtils.write(out, "table, ", data.getTableName());
            CsvUtils.writeLineFeed(out);
        }
        context.setLastRouterId(routerId);
        context.setLastTriggerHistoryId(historyId);
    }

    public void setDictionary(Map<String, IStreamDataCommand> dictionary) {
        this.dictionary = dictionary;
    }

    public void setDbDialect(IDbDialect dbDialect) {
        this.dbDialect = dbDialect;
    }

    public void setTablePrefix(String tablePrefix) {
        this.tablePrefix = tablePrefix;
    }

    public void setParameterService(IParameterService parameterService) {
        this.parameterService = parameterService;
    }

    @Override
    public String getLegacyTableName(String currentTableName) {
        return currentTableName;
    }
}

