/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.extract;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jumpmind.symmetric.db.BinaryEncoding;
import org.jumpmind.symmetric.db.IDbDialect;
import org.jumpmind.symmetric.ext.ICacheContext;
import org.jumpmind.symmetric.extract.IDataExtractor;
import org.jumpmind.symmetric.model.OutgoingBatch;
import org.jumpmind.symmetric.service.INodeService;
import org.springframework.jdbc.core.JdbcTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataExtractorContext
implements Cloneable,
ICacheContext {
    private Map<String, String> historyRecordsWritten = new HashMap<String, String>();
    private String lastTriggerHistoryId;
    private String lastRouterId;
    private OutgoingBatch batch;
    private IDataExtractor dataExtractor;
    private IDbDialect dbDialect;
    private Map<String, Object> cache;
    private JdbcTemplate jdbcTemplate;
    private INodeService nodeService;

    public DataExtractorContext copy(IDataExtractor extractor) {
        this.dataExtractor = extractor;
        try {
            DataExtractorContext newVersion = (DataExtractorContext)super.clone();
            newVersion.historyRecordsWritten = new HashMap<String, String>();
            newVersion.cache = null;
            return newVersion;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long getBatchId() {
        return this.batch != null ? this.batch.getBatchId() : -1L;
    }

    @Override
    public BinaryEncoding getBinaryEncoding() {
        return this.dbDialect.getBinaryEncoding();
    }

    @Override
    public Map<String, Object> getContextCache() {
        if (this.cache == null) {
            this.cache = new HashMap<String, Object>();
        }
        return this.cache;
    }

    @Override
    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    @Override
    public String getSourceNodeId() {
        return this.nodeService.findIdentityNodeId();
    }

    public Collection<String> getHistoryRecordsWritten() {
        return this.historyRecordsWritten.values();
    }

    public void addHistoryRecordWritten(String tableName, String triggerHistoryId) {
        this.historyRecordsWritten.put(tableName, triggerHistoryId);
    }

    public void setLastTriggerHistoryId(String triggerHistoryId) {
        this.lastTriggerHistoryId = triggerHistoryId;
    }

    public void setLastRouterId(String lastRouterId) {
        this.lastRouterId = lastRouterId;
    }

    public boolean isLastDataFromSameTriggerAndRouter(String currentTriggerHistoryId, String currentRouterId) {
        return this.lastTriggerHistoryId != null && this.lastTriggerHistoryId.equals(currentTriggerHistoryId) && this.lastRouterId != null && this.lastRouterId.equals(currentRouterId);
    }

    public OutgoingBatch getBatch() {
        return this.batch;
    }

    public void setBatch(OutgoingBatch batch) {
        this.batch = batch;
    }

    public IDataExtractor getDataExtractor() {
        return this.dataExtractor;
    }

    public void incrementDataEventCount() {
        if (this.batch != null) {
            this.batch.incrementDataEventCount();
        }
    }

    public void incrementByteCount(int size) {
        if (this.batch != null) {
            this.batch.incrementByteCount(size);
        }
    }

    public void setDbDialect(IDbDialect dbDialect) {
        this.dbDialect = dbDialect;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public void setNodeService(INodeService nodeService) {
        this.nodeService = nodeService;
    }
}

