/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db.mssql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.lang.StringUtils;
import org.jumpmind.symmetric.db.AbstractDbDialect;
import org.jumpmind.symmetric.db.AutoIncrementColumnFilter;
import org.jumpmind.symmetric.db.BinaryEncoding;
import org.jumpmind.symmetric.db.IDbDialect;
import org.jumpmind.symmetric.ddl.model.Table;
import org.jumpmind.symmetric.load.IColumnFilter;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;

public class MsSqlDbDialect
extends AbstractDbDialect
implements IDbDialect {
    protected boolean allowsNullForIdentityColumn() {
        return false;
    }

    public IColumnFilter newDatabaseColumnFilter() {
        return new AutoIncrementColumnFilter();
    }

    public void removeTrigger(StringBuilder sqlBuffer, final String catalogName, String schemaName, final String triggerName, String tableName, TriggerHistory oldHistory) {
        schemaName = schemaName == null ? "" : schemaName + ".";
        final String sql = "drop trigger " + schemaName + triggerName;
        this.logSql(sql, sqlBuffer);
        if (this.parameterService.is("auto.sync.triggers")) {
            this.jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                public Object doInConnection(Connection con) throws SQLException, DataAccessException {
                    block12: {
                        Statement stmt;
                        String previousCatalog;
                        block11: {
                            previousCatalog = con.getCatalog();
                            stmt = null;
                            if (catalogName != null) {
                                con.setCatalog(catalogName);
                            }
                            stmt = con.createStatement();
                            stmt.execute(sql);
                            Object var6_4 = null;
                            if (catalogName == null) break block11;
                            con.setCatalog(previousCatalog);
                        }
                        try {
                            stmt.close();
                        }
                        catch (Exception e2) {}
                        break block12;
                        {
                            catch (Exception e) {
                                MsSqlDbDialect.this.log.warn("TriggerDropError", triggerName, e.getMessage());
                                Object var6_5 = null;
                                if (catalogName != null) {
                                    con.setCatalog(previousCatalog);
                                }
                                try {
                                    stmt.close();
                                }
                                catch (Exception e2) {}
                            }
                        }
                        catch (Throwable throwable) {
                            Object var6_6 = null;
                            if (catalogName != null) {
                                con.setCatalog(previousCatalog);
                            }
                            try {
                                stmt.close();
                            }
                            catch (Exception e2) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                    }
                    return Boolean.FALSE;
                }
            });
        }
    }

    protected String switchCatalogForTriggerInstall(String catalog, Connection c) throws SQLException {
        if (catalog != null) {
            String previousCatalog = c.getCatalog();
            c.setCatalog(catalog);
            return previousCatalog;
        }
        return null;
    }

    public void allowIdentityInserts(JdbcTemplate template, Table table) {
        if (table != null && table.getAutoIncrementColumns().length > 0) {
            template.execute("SET IDENTITY_INSERT " + table.getFullyQualifiedTableName() + " ON");
        }
    }

    public void revertAllowIdentityInserts(JdbcTemplate template, Table table) {
        if (table != null && table.getAutoIncrementColumns().length > 0) {
            template.execute("SET IDENTITY_INSERT " + table.getFullyQualifiedTableName() + " OFF");
        }
    }

    public BinaryEncoding getBinaryEncoding() {
        return BinaryEncoding.BASE64;
    }

    protected boolean doesTriggerExistOnPlatform(final String catalogName, String schema, String tableName, final String triggerName) {
        return (Boolean)this.jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Boolean doInConnection(Connection con) throws SQLException, DataAccessException {
                PreparedStatement stmt;
                String previousCatalog;
                block5: {
                    Boolean bl;
                    block6: {
                        previousCatalog = con.getCatalog();
                        stmt = con.prepareStatement("select count(*) from sysobjects where type = 'TR' AND name = ?");
                        try {
                            if (catalogName != null) {
                                con.setCatalog(catalogName);
                            }
                            stmt.setString(1, triggerName);
                            ResultSet rs = stmt.executeQuery();
                            if (!rs.next()) break block5;
                            int count = rs.getInt(1);
                            bl = count > 0;
                            Object var8_7 = null;
                            if (catalogName == null) break block6;
                        }
                        catch (Throwable throwable) {
                            Object var8_9 = null;
                            if (catalogName != null) {
                                con.setCatalog(previousCatalog);
                            }
                            stmt.close();
                            throw throwable;
                        }
                        con.setCatalog(previousCatalog);
                    }
                    stmt.close();
                    return bl;
                }
                Object var8_8 = null;
                if (catalogName != null) {
                    con.setCatalog(previousCatalog);
                }
                stmt.close();
                return Boolean.FALSE;
            }
        });
    }

    public void disableSyncTriggers(JdbcTemplate jdbcTemplate, String nodeId) {
        if (nodeId == null) {
            nodeId = "";
        }
        jdbcTemplate.update("DECLARE @CI VarBinary(128);SET @CI=cast ('1" + nodeId + "' as varbinary(128));" + "SET context_info @CI;");
    }

    public void enableSyncTriggers(JdbcTemplate jdbcTemplate) {
        jdbcTemplate.update("set context_info 0x0");
    }

    public String getSyncTriggersExpression() {
        return "$(defaultCatalog)dbo." + this.tablePrefix + "_triggers_disabled() = 0";
    }

    public String getTransactionTriggerExpression(String defaultCatalog, String defaultSchema, Trigger trigger) {
        return "@TransactionId";
    }

    public boolean supportsTransactionId() {
        return true;
    }

    public boolean isNonBlankCharColumnSpacePadded() {
        return true;
    }

    public boolean isCharColumnSpaceTrimmed() {
        return false;
    }

    public boolean isTransactionIdOverrideSupported() {
        return false;
    }

    public boolean isDateOverrideToTimestamp() {
        return true;
    }

    public boolean isEmptyStringNulled() {
        return false;
    }

    public void purge() {
    }

    public String getDefaultCatalog() {
        return (String)this.jdbcTemplate.queryForObject("select DB_NAME()", String.class);
    }

    public String getDefaultSchema() {
        String defaultSchema = super.getDefaultSchema();
        if (StringUtils.isBlank((String)defaultSchema)) {
            defaultSchema = (String)this.jdbcTemplate.queryForObject("select SCHEMA_NAME()", String.class);
        }
        return defaultSchema;
    }

    public boolean needsToSelectLobData() {
        return true;
    }
}

