/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db.interbase;

import java.util.List;
import org.jumpmind.symmetric.db.AbstractDbDialect;
import org.jumpmind.symmetric.db.BinaryEncoding;
import org.jumpmind.symmetric.db.IDbDialect;
import org.jumpmind.symmetric.db.SequenceIdentifier;
import org.jumpmind.symmetric.model.Trigger;
import org.springframework.jdbc.UncategorizedSQLException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SingleColumnRowMapper;

public class InterbaseDbDialect
extends AbstractDbDialect
implements IDbDialect {
    public static final String CONTEXT_TABLE_NAME = "context";
    static final String CONTEXT_TABLE_CREATE = "create global temporary table %s (id varchar(30), context_value varchar(30)) on commit preserve rows";
    static final String CONTEXT_TABLE_INSERT = "insert into %s (id, context_value) values (?, ?)";
    static final String SYNC_TRIGGERS_DISABLED_USER_VARIABLE = "sync_triggers_disabled";
    static final String SYNC_TRIGGERS_DISABLED_NODE_VARIABLE = "sync_node_disabled";

    protected void initTablesAndFunctionsForSpecificDialect() {
        String contextTableName = this.tablePrefix + "_" + CONTEXT_TABLE_NAME;
        try {
            this.jdbcTemplate.queryForInt("select count(*) from " + contextTableName);
        }
        catch (Exception e) {
            try {
                this.log.info("GlobalTempTableCreating", contextTableName);
                this.jdbcTemplate.execute(String.format(CONTEXT_TABLE_CREATE, contextTableName));
            }
            catch (Exception ex) {
                this.log.error("InterbaseDialectInitializingError", ex);
            }
        }
    }

    protected void createRequiredFunctions() {
        super.createRequiredFunctions();
        try {
            this.jdbcTemplate.queryForObject("select sym_escape('') from rdb$database", String.class);
        }
        catch (UncategorizedSQLException e) {
            if (e.getSQLException().getErrorCode() == -804) {
                this.log.error("InterbaseSymUdfMissing");
            }
            throw new RuntimeException("InterbaseSymEscapeMissing", e);
        }
    }

    protected boolean doesTriggerExistOnPlatform(String catalogName, String schema, String tableName, String triggerName) {
        return this.jdbcTemplate.queryForInt("select count(*) from rdb$triggers where rdb$trigger_name = ?", new Object[]{triggerName.toUpperCase()}) > 0;
    }

    public void disableSyncTriggers(JdbcTemplate jdbcTemplate, String nodeId) {
        String contextTableName = this.tablePrefix + "_" + CONTEXT_TABLE_NAME;
        jdbcTemplate.update(String.format(CONTEXT_TABLE_INSERT, contextTableName), new Object[]{SYNC_TRIGGERS_DISABLED_USER_VARIABLE, "1"});
        if (nodeId != null) {
            jdbcTemplate.update(String.format(CONTEXT_TABLE_INSERT, contextTableName), new Object[]{SYNC_TRIGGERS_DISABLED_NODE_VARIABLE, nodeId});
        }
    }

    public void enableSyncTriggers(JdbcTemplate jdbcTemplate) {
        String contextTableName = this.tablePrefix + "_" + CONTEXT_TABLE_NAME;
        jdbcTemplate.update("delete from " + contextTableName);
    }

    public String getSyncTriggersExpression() {
        return ":sync_triggers_disabled is null";
    }

    protected String getSequenceName(SequenceIdentifier identifier) {
        switch (identifier) {
            case OUTGOING_BATCH: {
                return "SYM_OUTGOING_BATCH_BATCH_ID";
            }
            case DATA: {
                return "SYM_DATA_DATA_ID";
            }
            case TRIGGER_HIST: {
                return "SYM_TRIGGER_TRIGGER_HIST_ID";
            }
        }
        return null;
    }

    public String getTransactionTriggerExpression(String defaultCatalog, String defaultSchema, Trigger trigger) {
        return "null";
    }

    public String getSelectLastInsertIdSql(String sequenceName) {
        return "select gen_id(gen_" + sequenceName + ", 0) from rdb$database";
    }

    public boolean isBlobSyncSupported() {
        return true;
    }

    public BinaryEncoding getBinaryEncoding() {
        return BinaryEncoding.HEX;
    }

    public boolean isNonBlankCharColumnSpacePadded() {
        return true;
    }

    public boolean isCharColumnSpaceTrimmed() {
        return false;
    }

    public boolean isEmptyStringNulled() {
        return false;
    }

    protected boolean allowsNullForIdentityColumn() {
        return true;
    }

    public void purge() {
    }

    public String getName() {
        return super.getName();
    }

    public String getDefaultCatalog() {
        return null;
    }

    public boolean supportsOpenCursorsAcrossCommit() {
        return false;
    }

    public boolean supportsTransactionId() {
        return false;
    }

    public boolean supportsBatchUpdates() {
        return false;
    }

    public void truncateTable(String tableName) {
        this.jdbcTemplate.update("delete from " + tableName);
    }

    public void cleanupTriggers() {
        List names = this.jdbcTemplate.query("select rdb$trigger_name from rdb$triggers where rdb$trigger_name like '" + this.tablePrefix.toUpperCase() + "_%'", (RowMapper)new SingleColumnRowMapper());
        int count = 0;
        for (String name : names) {
            count += this.jdbcTemplate.update("drop trigger " + name);
        }
        this.log.info("RemovedTriggers", count);
    }
}

