/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db.firebird;

import org.jumpmind.symmetric.db.AbstractDbDialect;
import org.jumpmind.symmetric.db.BinaryEncoding;
import org.jumpmind.symmetric.db.IDbDialect;
import org.jumpmind.symmetric.model.Trigger;
import org.springframework.jdbc.UncategorizedSQLException;
import org.springframework.jdbc.core.JdbcTemplate;

public class FirebirdDbDialect
extends AbstractDbDialect
implements IDbDialect {
    static final String SYNC_TRIGGERS_DISABLED_USER_VARIABLE = "sync_triggers_disabled";
    static final String SYNC_TRIGGERS_DISABLED_NODE_VARIABLE = "sync_node_disabled";

    protected void createRequiredFunctions() {
        super.createRequiredFunctions();
        try {
            this.jdbcTemplate.queryForInt("select char_length(sym_escape('')) from rdb$database");
        }
        catch (UncategorizedSQLException e) {
            if (e.getSQLException().getErrorCode() == -804) {
                this.log.error("FirebirdSymUdfMissing");
            }
            throw new RuntimeException("FirebirdSymEscapeMissing", e);
        }
    }

    protected boolean doesTriggerExistOnPlatform(String catalogName, String schema, String tableName, String triggerName) {
        return this.jdbcTemplate.queryForInt("select count(*) from rdb$triggers where rdb$trigger_name = ?", new Object[]{triggerName.toUpperCase()}) > 0;
    }

    public void disableSyncTriggers(JdbcTemplate jdbcTemplate, String nodeId) {
        jdbcTemplate.queryForInt("select rdb$set_context('USER_SESSION','sync_triggers_disabled',1) from rdb$database");
        if (nodeId != null) {
            jdbcTemplate.queryForInt("select rdb$set_context('USER_SESSION','sync_node_disabled','" + nodeId + "') from rdb$database");
        }
    }

    public void enableSyncTriggers(JdbcTemplate jdbcTemplate) {
        jdbcTemplate.queryForInt("select rdb$set_context('USER_SESSION','sync_triggers_disabled',null) from rdb$database");
        jdbcTemplate.queryForInt("select rdb$set_context('USER_SESSION','sync_node_disabled',null) from rdb$database");
    }

    public String getSyncTriggersExpression() {
        return "rdb$get_context('USER_SESSION','sync_triggers_disabled') is null";
    }

    public String getTransactionTriggerExpression(String defaultCatalog, String defaultSchema, Trigger trigger) {
        return "current_transaction||''";
    }

    public boolean supportsReturningKeys() {
        return true;
    }

    public boolean isBlobSyncSupported() {
        return true;
    }

    public BinaryEncoding getBinaryEncoding() {
        return BinaryEncoding.HEX;
    }

    public boolean isNonBlankCharColumnSpacePadded() {
        return true;
    }

    public boolean isCharColumnSpaceTrimmed() {
        return false;
    }

    public boolean isEmptyStringNulled() {
        return false;
    }

    protected boolean allowsNullForIdentityColumn() {
        return true;
    }

    public void purge() {
    }

    public String getName() {
        return super.getName().substring(0, 49);
    }

    public String getDefaultCatalog() {
        return null;
    }

    public boolean supportsOpenCursorsAcrossCommit() {
        return false;
    }

    public boolean supportsTransactionId() {
        return true;
    }

    public void truncateTable(String tableName) {
        this.jdbcTemplate.update("delete from " + tableName);
    }
}

