/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db.derby;

import org.apache.commons.lang.StringUtils;
import org.jumpmind.symmetric.db.AbstractDbDialect;
import org.jumpmind.symmetric.db.BinaryEncoding;
import org.jumpmind.symmetric.db.IDbDialect;
import org.jumpmind.symmetric.model.Trigger;
import org.springframework.jdbc.core.JdbcTemplate;

public class DerbyDbDialect
extends AbstractDbDialect
implements IDbDialect {
    protected boolean doesTriggerExistOnPlatform(String catalog, String schema, String tableName, String triggerName) {
        schema = schema == null ? (this.getDefaultSchema() == null ? null : this.getDefaultSchema()) : schema;
        return this.jdbcTemplate.queryForInt("select count(*) from sys.systriggers where triggername = ?", new Object[]{triggerName.toUpperCase()}) > 0;
    }

    public boolean supportsTransactionId() {
        return true;
    }

    public boolean isBlobSyncSupported() {
        return true;
    }

    public boolean isClobSyncSupported() {
        return true;
    }

    public BinaryEncoding getBinaryEncoding() {
        return BinaryEncoding.BASE64;
    }

    public void disableSyncTriggers(JdbcTemplate jdbcTemplate, String nodeId) {
        jdbcTemplate.queryForInt(String.format("values %s_sync_triggers_set_disabled(1)", this.tablePrefix));
        if (nodeId != null) {
            jdbcTemplate.queryForObject(String.format("values %s_sync_node_set_disabled('%s')", this.tablePrefix, nodeId), String.class);
        }
    }

    public void enableSyncTriggers(JdbcTemplate jdbcTemplate) {
        jdbcTemplate.queryForInt(String.format("values %s_sync_triggers_set_disabled(0)", this.tablePrefix));
        jdbcTemplate.queryForObject(String.format("values %s_sync_node_set_disabled(null)", this.tablePrefix), String.class);
    }

    public String getSyncTriggersExpression() {
        return String.format("%s_sync_triggers_disabled() = 0", this.tablePrefix);
    }

    public String getTransactionTriggerExpression(String defaultCatalog, String defaultSchema, Trigger trigger) {
        return String.format("%s_transaction_id()", this.tablePrefix);
    }

    public String getSelectLastInsertIdSql(String sequenceName) {
        return "values IDENTITY_VAL_LOCAL()";
    }

    public boolean isNonBlankCharColumnSpacePadded() {
        return true;
    }

    public boolean isCharColumnSpaceTrimmed() {
        return false;
    }

    public boolean isEmptyStringNulled() {
        return false;
    }

    public boolean supportsGetGeneratedKeys() {
        return false;
    }

    protected boolean allowsNullForIdentityColumn() {
        return false;
    }

    public void purge() {
    }

    public String getDefaultCatalog() {
        return null;
    }

    public String getDefaultSchema() {
        String defaultSchema = super.getDefaultSchema();
        if (StringUtils.isBlank((String)defaultSchema)) {
            defaultSchema = (String)this.jdbcTemplate.queryForObject("values CURRENT SCHEMA", String.class);
        }
        return defaultSchema;
    }

    public void truncateTable(String tableName) {
        this.jdbcTemplate.update("delete from " + tableName);
    }

    public boolean needsToSelectLobData() {
        return true;
    }
}

