/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db.db2;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jumpmind.symmetric.db.AbstractDbDialect;
import org.jumpmind.symmetric.db.BinaryEncoding;
import org.jumpmind.symmetric.db.IDbDialect;
import org.jumpmind.symmetric.db.SequenceIdentifier;
import org.jumpmind.symmetric.model.Trigger;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.support.JdbcUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Db2zSeriesDbDialect
extends AbstractDbDialect
implements IDbDialect {
    static final Log logger = LogFactory.getLog(Db2zSeriesDbDialect.class);
    private String userName;

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Override
    protected boolean doesTriggerExistOnPlatform(String catalog, String schema, String tableName, String triggerName) {
        schema = schema == null ? (this.getDefaultSchema() == null ? null : this.getDefaultSchema()) : schema;
        return this.jdbcTemplate.queryForInt("SELECT COUNT(*) FROM SYSIBM.SYSTRIGGERS WHERE NAME = ?", new Object[]{triggerName.toUpperCase()}) > 0;
    }

    @Override
    public boolean isBlobSyncSupported() {
        return true;
    }

    @Override
    public boolean isClobSyncSupported() {
        return true;
    }

    @Override
    public BinaryEncoding getBinaryEncoding() {
        return BinaryEncoding.HEX;
    }

    @Override
    public String getTransactionTriggerExpression(String defaultCatalog, String defaultSchema, Trigger trigger) {
        return "nullif('','')";
    }

    @Override
    public String getSelectLastInsertIdSql(String sequenceName) {
        return "values IDENTITY_VAL_LOCAL()";
    }

    @Override
    public boolean isNonBlankCharColumnSpacePadded() {
        return true;
    }

    @Override
    public boolean isCharColumnSpaceTrimmed() {
        return false;
    }

    @Override
    public boolean isEmptyStringNulled() {
        return false;
    }

    @Override
    public boolean supportsGetGeneratedKeys() {
        return true;
    }

    @Override
    protected boolean allowsNullForIdentityColumn() {
        return false;
    }

    @Override
    public void purge() {
    }

    @Override
    public String getDefaultCatalog() {
        return null;
    }

    @Override
    public void disableSyncTriggers(JdbcTemplate jdbcTemplate, String nodeId) {
    }

    @Override
    public void enableSyncTriggers(JdbcTemplate jdbcTemplate) {
    }

    @Override
    public String getSyncTriggersExpression() {
        return "";
    }

    @Override
    public long insertWithGeneratedKey(final String sql, final SequenceIdentifier sequenceId, final PreparedStatementCallback<Object> callback) {
        return (Long)this.jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<Long>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Long doInConnection(Connection conn) throws SQLException, DataAccessException {
                long key = 0L;
                PreparedStatement ps = null;
                try {
                    block16: {
                        boolean supportsGetGeneratedKeys = Db2zSeriesDbDialect.this.supportsGetGeneratedKeys();
                        boolean supportsReturningKeys = Db2zSeriesDbDialect.this.supportsReturningKeys();
                        if (Db2zSeriesDbDialect.this.allowsNullForIdentityColumn()) {
                            ps = supportsGetGeneratedKeys ? conn.prepareStatement(sql, new int[]{1}) : (supportsReturningKeys ? conn.prepareStatement(sql + " returning " + Db2zSeriesDbDialect.this.getSequenceKeyName(sequenceId)) : conn.prepareStatement(sql));
                        } else {
                            String replaceSql = sql.replaceFirst("\\(\\w*,", "(").replaceFirst("\\(null,", "(");
                            System.out.println("======================================");
                            System.out.println(replaceSql);
                            System.out.println("======================================");
                            ps = supportsGetGeneratedKeys ? conn.prepareStatement(replaceSql, 1) : conn.prepareStatement(replaceSql);
                        }
                        ps.setQueryTimeout(Db2zSeriesDbDialect.this.jdbcTemplate.getQueryTimeout());
                        if (callback != null) {
                            callback.doInPreparedStatement(ps);
                        }
                        ResultSet rs = null;
                        if (supportsGetGeneratedKeys) {
                            ps.executeUpdate();
                            try {
                                rs = ps.getGeneratedKeys();
                                if (rs.next()) {
                                    key = rs.getLong(1);
                                }
                                Object var9_7 = null;
                            }
                            catch (Throwable throwable) {
                                Object var9_8 = null;
                                JdbcUtils.closeResultSet((ResultSet)rs);
                                throw throwable;
                            }
                            JdbcUtils.closeResultSet((ResultSet)rs);
                            {
                                break block16;
                            }
                        }
                        if (supportsReturningKeys) {
                            try {
                                rs = ps.executeQuery();
                                if (rs.next()) {
                                    key = rs.getLong(1);
                                }
                                Object var11_11 = null;
                            }
                            catch (Throwable throwable) {
                                Object var11_12 = null;
                                JdbcUtils.closeResultSet((ResultSet)rs);
                                throw throwable;
                            }
                            JdbcUtils.closeResultSet((ResultSet)rs);
                            {
                                break block16;
                            }
                        }
                        Statement st = null;
                        ps.executeUpdate();
                        try {
                            st = conn.createStatement();
                            rs = st.executeQuery(Db2zSeriesDbDialect.this.getSelectLastInsertIdSql(Db2zSeriesDbDialect.this.getSequenceName(sequenceId)));
                            if (rs.next()) {
                                key = rs.getLong(1);
                            }
                            Object var13_14 = null;
                        }
                        catch (Throwable throwable) {
                            Object var13_15 = null;
                            JdbcUtils.closeResultSet((ResultSet)rs);
                            JdbcUtils.closeStatement((Statement)st);
                            throw throwable;
                        }
                        JdbcUtils.closeResultSet((ResultSet)rs);
                        JdbcUtils.closeStatement((Statement)st);
                        {
                        }
                    }
                    Object var15_17 = null;
                }
                catch (Throwable throwable) {
                    Object var15_18 = null;
                    JdbcUtils.closeStatement(ps);
                    throw throwable;
                }
                JdbcUtils.closeStatement((Statement)ps);
                return key;
            }
        });
    }
}

