/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db;

import java.util.Map;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.StringUtils;
import org.jumpmind.symmetric.Version;
import org.jumpmind.symmetric.db.IDbDialect;
import org.jumpmind.symmetric.db.mssql.MsSqlDbDialect;
import org.jumpmind.symmetric.db.postgresql.PostgreSqlDbDialect;
import org.jumpmind.symmetric.ddl.model.Column;
import org.jumpmind.symmetric.ddl.model.Table;
import org.jumpmind.symmetric.model.Channel;
import org.jumpmind.symmetric.model.DataEventType;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.jumpmind.symmetric.model.TriggerRouter;
import org.jumpmind.symmetric.util.AppUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlTemplate {
    private static final String ORIG_TABLE_ALIAS = "orig";
    static final String INSERT_TRIGGER_TEMPLATE = "insertTriggerTemplate";
    static final String UPDATE_TRIGGER_TEMPLATE = "updateTriggerTemplate";
    static final String DELETE_TRIGGER_TEMPLATE = "deleteTriggerTemplate";
    static final String INITIAL_LOAD_SQL_TEMPLATE = "initialLoadSqlTemplate";
    private Map<String, String> sqlTemplates;
    private Map<String, String> functionTemplatesToInstall;
    private String functionInstalledSql;
    private String emptyColumnTemplate = "''";
    private String stringColumnTemplate;
    private String xmlColumnTemplate;
    private String arrayColumnTemplate;
    private String numberColumnTemplate;
    private String datetimeColumnTemplate;
    private String timeColumnTemplate;
    private String dateColumnTemplate;
    private String clobColumnTemplate;
    private String blobColumnTemplate;
    private String wrappedBlobColumnTemplate;
    private String booleanColumnTemplate;
    private String triggerConcatCharacter;
    private String newTriggerValue;
    private String oldTriggerValue;
    private String oldColumnPrefix = "";
    private String newColumnPrefix = "";
    private String otherColumnTemplate;

    public String createInitalLoadSql(Node node, IDbDialect dialect, TriggerRouter triggerRouter, Table table, TriggerHistory triggerHistory, Channel channel) {
        String sql = this.sqlTemplates.get(INITIAL_LOAD_SQL_TEMPLATE);
        Column[] columns = dialect.orderColumns(triggerHistory.getParsedColumnNames(), table);
        String columnsText = this.buildColumnString((String)dialect.getInitialLoadTableAlias(), (String)dialect.getInitialLoadTableAlias(), (String)"", (Column[])columns, (IDbDialect)dialect, (DataEventType)DataEventType.INSERT, (boolean)false, (Channel)channel, (Trigger)triggerRouter.getTrigger()).columnString;
        sql = AppUtils.replace("columns", columnsText, sql);
        sql = AppUtils.replace("whereClause", StringUtils.isBlank((String)triggerRouter.getInitialLoadSelect()) ? "1=1" : triggerRouter.getInitialLoadSelect(), sql);
        sql = AppUtils.replace("tableName", this.quote(table.getName(), dialect), sql);
        sql = AppUtils.replace("schemaName", triggerHistory == null ? this.getSourceTablePrefix(triggerRouter.getTrigger(), dialect) : this.getSourceTablePrefix(triggerHistory, dialect), sql);
        sql = AppUtils.replace("primaryKeyWhereString", this.getPrimaryKeyWhereString(dialect.getInitialLoadTableAlias(), table.getPrimaryKeyColumns()), sql);
        sql = AppUtils.replace("groupId", node.getNodeGroupId(), sql);
        sql = AppUtils.replace("externalId", node.getExternalId(), sql);
        sql = AppUtils.replace("nodeId", node.getNodeId(), sql);
        sql = this.replaceDefaultSchemaAndCatalog(dialect, triggerRouter.getTrigger(), sql);
        sql = AppUtils.replace("prefixName", dialect.getTablePrefix(), sql);
        sql = AppUtils.replace("oracleToClob", triggerRouter.getTrigger().isUseCaptureLobs() ? "to_clob('')||" : "", sql);
        return sql;
    }

    protected String getSourceTablePrefix(Trigger trigger, IDbDialect dbDialect) {
        String schemaPlus = trigger.getSourceSchemaName() != null ? trigger.getSourceSchemaName() + "." : "";
        String catalogPlus = (trigger.getSourceCatalogName() != null ? trigger.getSourceCatalogName() + "." : "") + schemaPlus;
        return catalogPlus;
    }

    protected String getSourceTablePrefix(TriggerHistory triggerHistory, IDbDialect dbDialect) {
        String schemaPlus = triggerHistory.getSourceSchemaName() != null ? triggerHistory.getSourceSchemaName() + "." : "";
        String catalogPlus = (triggerHistory.getSourceCatalogName() != null ? triggerHistory.getSourceCatalogName() + "." : "") + schemaPlus;
        return catalogPlus;
    }

    protected String quote(String name, IDbDialect dbDialect) {
        String quote = dbDialect.getIdentifierQuoteString();
        if (StringUtils.isNotBlank((String)quote)) {
            return quote + name + quote;
        }
        return name;
    }

    protected String replaceDefaultSchemaAndCatalog(IDbDialect dbDialect, Trigger trigger, String sql) {
        String defaultCatalog = dbDialect.getDefaultCatalog();
        String defaultSchema = dbDialect.getDefaultSchema();
        boolean resolveSchemaAndCatalogs = trigger.getSourceCatalogName() != null || trigger.getSourceSchemaName() != null;
        sql = AppUtils.replace("defaultSchema", resolveSchemaAndCatalogs && defaultSchema != null && defaultSchema.length() > 0 ? defaultSchema + "." : "", sql);
        return AppUtils.replace("defaultCatalog", resolveSchemaAndCatalogs && defaultCatalog != null && defaultCatalog.length() > 0 ? defaultCatalog + "." : "", sql);
    }

    public String createCsvDataSql(IDbDialect dialect, Trigger trigger, TriggerHistory triggerHistory, Table table, Channel channel, String whereClause) {
        String sql = this.sqlTemplates.get(INITIAL_LOAD_SQL_TEMPLATE);
        Column[] columns = trigger.orderColumnsForTable(table);
        String columnsText = this.buildColumnString((String)dialect.getInitialLoadTableAlias(), (String)dialect.getInitialLoadTableAlias(), (String)"", (Column[])columns, (IDbDialect)dialect, (DataEventType)DataEventType.INSERT, (boolean)false, (Channel)channel, (Trigger)trigger).columnString;
        sql = AppUtils.replace("columns", columnsText, sql);
        sql = AppUtils.replace("oracleToClob", trigger.isUseCaptureLobs() ? "to_clob('')||" : "", sql);
        sql = AppUtils.replace("tableName", this.quote(table.getName(), dialect), sql);
        sql = AppUtils.replace("schemaName", triggerHistory == null ? this.getSourceTablePrefix(trigger, dialect) : this.getSourceTablePrefix(triggerHistory, dialect), sql);
        sql = AppUtils.replace("whereClause", whereClause, sql);
        sql = AppUtils.replace("primaryKeyWhereString", this.getPrimaryKeyWhereString(dialect.getInitialLoadTableAlias(), table.getPrimaryKeyColumns()), sql);
        sql = this.replaceDefaultSchemaAndCatalog(dialect, trigger, sql);
        return sql;
    }

    public String createCsvPrimaryKeySql(IDbDialect dialect, Trigger trigger, TriggerHistory triggerHistory, Table table, Channel channel, String whereClause) {
        String sql = this.sqlTemplates.get(INITIAL_LOAD_SQL_TEMPLATE);
        Column[] columns = table.getPrimaryKeyColumns();
        String columnsText = this.buildColumnString(dialect.getInitialLoadTableAlias(), dialect.getInitialLoadTableAlias(), "", columns, dialect, DataEventType.INSERT, false, channel, trigger).toString();
        sql = AppUtils.replace("columns", columnsText, sql);
        sql = AppUtils.replace("oracleToClob", trigger.isUseCaptureLobs() ? "to_clob('')||" : "", sql);
        sql = AppUtils.replace("tableName", this.quote(table.getName(), dialect), sql);
        sql = AppUtils.replace("schemaName", triggerHistory == null ? this.getSourceTablePrefix(trigger, dialect) : this.getSourceTablePrefix(triggerHistory, dialect), sql);
        sql = AppUtils.replace("whereClause", whereClause, sql);
        sql = AppUtils.replace("primaryKeyWhereString", this.getPrimaryKeyWhereString(dialect.getInitialLoadTableAlias(), columns), sql);
        return sql;
    }

    public String[] getFunctionsToInstall() {
        if (this.functionTemplatesToInstall != null) {
            return this.functionTemplatesToInstall.keySet().toArray(new String[this.functionTemplatesToInstall.size()]);
        }
        return new String[0];
    }

    public String createTriggerDDL(IDbDialect dialect, DataEventType dml, Trigger trigger, TriggerHistory history, Channel channel, String tablePrefix, Table table, String defaultCatalog, String defaultSchema) {
        String ddl = this.sqlTemplates.get(dml.name().toLowerCase() + "TriggerTemplate");
        if (ddl == null) {
            throw new NotImplementedException(dml.name() + " trigger is not implemented for " + dialect.getPlatform().getName());
        }
        return this.replaceTemplateVariables(dialect, dml, trigger, history, channel, tablePrefix, table, defaultCatalog, defaultSchema, ddl);
    }

    public String createPostTriggerDDL(IDbDialect dialect, DataEventType dml, Trigger trigger, TriggerHistory history, Channel channel, String tablePrefix, Table table, String defaultCatalog, String defaultSchema) {
        String ddl = this.sqlTemplates.get(dml.name().toLowerCase() + "PostTriggerTemplate");
        return this.replaceTemplateVariables(dialect, dml, trigger, history, channel, tablePrefix, table, defaultCatalog, defaultSchema, ddl);
    }

    private String getDefaultTargetTableName(Trigger trigger, TriggerHistory history) {
        String targetTableName = null;
        targetTableName = history != null ? history.getSourceTableName() : trigger.getSourceTableName();
        return targetTableName;
    }

    public String replaceTemplateVariables(IDbDialect dialect, DataEventType dml, Trigger trigger, TriggerHistory history, Channel channel, String tablePrefix, Table table, String defaultCatalog, String defaultSchema, String ddl) {
        ddl = AppUtils.replace("targetTableName", this.getDefaultTargetTableName(trigger, history), ddl);
        ddl = AppUtils.replace("triggerName", history.getTriggerNameForDmlType(dml), ddl);
        ddl = AppUtils.replace("channelName", trigger.getChannelId(), ddl);
        ddl = AppUtils.replace("triggerHistoryId", Integer.toString(history == null ? -1 : history.getTriggerHistoryId()), ddl);
        String triggerExpression = dialect.getTransactionTriggerExpression(defaultCatalog, defaultSchema, trigger);
        if (dialect.isTransactionIdOverrideSupported() && !StringUtils.isBlank((String)trigger.getTxIdExpression())) {
            triggerExpression = trigger.getTxIdExpression();
        }
        ddl = AppUtils.replace("txIdExpression", dialect.preProcessTriggerSqlClause(triggerExpression), ddl);
        ddl = AppUtils.replace("externalSelect", trigger.getExternalSelect() == null ? "null" : "(" + dialect.preProcessTriggerSqlClause(trigger.getExternalSelect()) + ")", ddl);
        ddl = AppUtils.replace("syncOnInsertCondition", dialect.preProcessTriggerSqlClause(trigger.getSyncOnInsertCondition()), ddl);
        ddl = AppUtils.replace("syncOnUpdateCondition", dialect.preProcessTriggerSqlClause(trigger.getSyncOnUpdateCondition()), ddl);
        ddl = AppUtils.replace("syncOnDeleteCondition", dialect.preProcessTriggerSqlClause(trigger.getSyncOnDeleteCondition()), ddl);
        ddl = AppUtils.replace("dataHasChangedCondition", dialect.preProcessTriggerSqlClause(dialect.getDataHasChangedCondition(trigger)), ddl);
        ddl = AppUtils.replace("sourceNodeExpression", dialect.getSourceNodeExpression(), ddl);
        ddl = AppUtils.replace("oracleLobType", trigger.isUseCaptureLobs() ? "clob" : "long", ddl);
        String syncTriggersExpression = dialect.getSyncTriggersExpression();
        ddl = AppUtils.replace("syncOnIncomingBatchCondition", trigger.isSyncOnIncomingBatch() ? "1=1" : syncTriggersExpression, ddl);
        ddl = AppUtils.replace("origTableAlias", ORIG_TABLE_ALIAS, ddl);
        Column[] columns = trigger.orderColumnsForTable(table);
        ColumnString columnString = this.buildColumnString(ORIG_TABLE_ALIAS, this.newTriggerValue, this.newColumnPrefix, columns, dialect, dml, false, channel, trigger);
        ddl = AppUtils.replace("columns", columnString.toString(), ddl);
        ddl = this.replaceDefaultSchemaAndCatalog(dialect, trigger, ddl);
        ddl = AppUtils.replace("virtualOldNewTable", this.buildVirtualTableSql(dialect, this.oldColumnPrefix, this.newColumnPrefix, table.getColumns()), ddl);
        ddl = AppUtils.replace("oldColumns", this.buildColumnString(ORIG_TABLE_ALIAS, this.oldTriggerValue, this.oldColumnPrefix, columns, dialect, dml, true, channel, trigger).toString(), ddl);
        ddl = this.eval(columnString.isBlobClob, "containsBlobClobColumns", ddl);
        ddl = AppUtils.replace("tableName", history == null ? this.quote(trigger.getSourceTableName(), dialect) : this.quote(history.getSourceTableName(), dialect), ddl);
        ddl = AppUtils.replace("schemaName", history == null ? this.getSourceTablePrefix(trigger, dialect) : this.getSourceTablePrefix(history, dialect), ddl);
        columns = table.getPrimaryKeyColumns();
        ddl = AppUtils.replace("oldKeys", this.buildColumnString(ORIG_TABLE_ALIAS, this.oldTriggerValue, this.oldColumnPrefix, columns, dialect, dml, true, channel, trigger).toString(), ddl);
        ddl = AppUtils.replace("oldNewPrimaryKeyJoin", this.aliasedPrimaryKeyJoin(this.oldTriggerValue, this.newTriggerValue, columns.length == 0 ? table.getColumns() : columns), ddl);
        ddl = AppUtils.replace("tableNewPrimaryKeyJoin", this.aliasedPrimaryKeyJoin(ORIG_TABLE_ALIAS, this.newTriggerValue, columns.length == 0 ? table.getColumns() : columns), ddl);
        ddl = AppUtils.replace("primaryKeyWhereString", this.getPrimaryKeyWhereString(dml == DataEventType.DELETE ? this.oldTriggerValue : this.newTriggerValue, columns), ddl);
        ddl = AppUtils.replace("declareOldKeyVariables", this.buildKeyVariablesDeclare(columns, "old"), ddl);
        ddl = AppUtils.replace("declareNewKeyVariables", this.buildKeyVariablesDeclare(columns, "new"), ddl);
        String builtString = this.buildColumnNameString(this.oldTriggerValue, columns);
        ddl = AppUtils.replace("oldKeyNames", StringUtils.isNotBlank((String)builtString) ? "," + builtString : "", ddl);
        builtString = this.buildColumnNameString(this.newTriggerValue, columns);
        ddl = AppUtils.replace("newKeyNames", StringUtils.isNotBlank((String)builtString) ? "," + builtString : "", ddl);
        builtString = this.buildKeyVariablesString(columns, "old");
        ddl = AppUtils.replace("oldKeyVariables", StringUtils.isNotBlank((String)builtString) ? "," + builtString : "", ddl);
        builtString = this.buildKeyVariablesString(columns, "new");
        ddl = AppUtils.replace("newKeyVariables", StringUtils.isNotBlank((String)builtString) ? "," + builtString : "", ddl);
        ddl = AppUtils.replace("varNewPrimaryKeyJoin", this.aliasedPrimaryKeyJoinVar(this.newTriggerValue, "new", columns), ddl);
        ddl = AppUtils.replace("varOldPrimaryKeyJoin", this.aliasedPrimaryKeyJoinVar(this.oldTriggerValue, "old", columns), ddl);
        ddl = AppUtils.replace("newTriggerValue", this.newTriggerValue, ddl);
        ddl = AppUtils.replace("oldTriggerValue", this.oldTriggerValue, ddl);
        ddl = AppUtils.replace("newColumnPrefix", this.newColumnPrefix, ddl);
        ddl = AppUtils.replace("oldColumnPrefix", this.oldColumnPrefix, ddl);
        ddl = AppUtils.replace("prefixName", tablePrefix, ddl);
        ddl = this.replaceDefaultSchemaAndCatalog(dialect, trigger, ddl);
        ddl = AppUtils.replace("oracleToClob", trigger.isUseCaptureLobs() ? "to_clob('')||" : "", ddl);
        switch (dml) {
            case DELETE: {
                ddl = AppUtils.replace("curTriggerValue", this.oldTriggerValue, ddl);
                ddl = AppUtils.replace("curColumnPrefix", this.oldColumnPrefix, ddl);
                break;
            }
            default: {
                ddl = AppUtils.replace("curTriggerValue", this.newTriggerValue, ddl);
                ddl = AppUtils.replace("curColumnPrefix", this.newColumnPrefix, ddl);
            }
        }
        return ddl;
    }

    private String buildVirtualTableSql(IDbDialect dialect, String oldTriggerValue, String newTriggerValue, Column[] columns) {
        String column;
        if (oldTriggerValue.indexOf(".") >= 0) {
            oldTriggerValue = oldTriggerValue.substring(oldTriggerValue.indexOf(".") + 1);
        }
        if (newTriggerValue.indexOf(".") >= 0) {
            newTriggerValue = newTriggerValue.substring(newTriggerValue.indexOf(".") + 1);
        }
        StringBuilder b = new StringBuilder("(SELECT ");
        for (Column columnType : columns) {
            column = columnType.getName();
            b.append("? as ");
            b.append("\"").append(newTriggerValue).append(column).append("\",");
        }
        for (Column columnType : columns) {
            column = columnType.getName();
            b.append("? AS ");
            b.append("\"").append(oldTriggerValue).append(column).append("\",");
        }
        b.deleteCharAt(b.length() - 1);
        b.append(" FROM DUAL) T ");
        return b.toString();
    }

    private String eval(boolean condition, String prop, String ddl) {
        if (ddl != null) {
            String ifStmt = "$(if:" + prop + ")";
            String elseStmt = "$(else:" + prop + ")";
            String endStmt = "$(end:" + prop + ")";
            int ifIndex = ddl.indexOf(ifStmt);
            if (ifIndex >= 0) {
                int endIndex = ddl.indexOf(endStmt);
                if (endIndex >= 0) {
                    String onTrue = ddl.substring(ifIndex + ifStmt.length(), endIndex);
                    String onFalse = "";
                    int elseIndex = onTrue.indexOf(elseStmt);
                    if (elseIndex >= 0) {
                        onFalse = onTrue.substring(elseIndex + elseStmt.length());
                        onTrue = onTrue.substring(0, elseIndex);
                    }
                    ddl = condition ? ddl.substring(0, ifIndex) + onTrue + ddl.substring(endIndex + endStmt.length()) : ddl.substring(0, ifIndex) + onFalse + ddl.substring(endIndex + endStmt.length());
                } else {
                    throw new IllegalStateException(ifStmt + " has to have a " + endStmt);
                }
            }
        }
        return ddl;
    }

    private String aliasedPrimaryKeyJoin(String aliasOne, String aliasTwo, Column[] columns) {
        StringBuilder b = new StringBuilder();
        for (Column column : columns) {
            b.append(aliasOne).append(".\"").append(column.getName()).append("\"");
            b.append("=").append(aliasTwo).append(".\"").append(column.getName()).append("\"");
            if (column.equals((Object)columns[columns.length - 1])) continue;
            b.append(" and ");
        }
        return b.toString();
    }

    private String aliasedPrimaryKeyJoinVar(String alias, String prefix, Column[] columns) {
        String text = "";
        for (int i = 0; i < columns.length; ++i) {
            text = text + alias + ".\"" + columns[i].getName() + "\"";
            text = text + "=@" + prefix + "pk" + i;
            if (i + 1 >= columns.length) continue;
            text = text + " and ";
        }
        return text;
    }

    private String getPrimaryKeyWhereString(String alias, Column[] columns) {
        StringBuilder b = new StringBuilder("'");
        for (Column column : columns) {
            b.append("\"").append(column.getName()).append("\"=");
            switch (column.getTypeCode()) {
                case -7: 
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 16: {
                    b.append("'").append(this.triggerConcatCharacter);
                    b.append("rtrim(char(").append(alias).append(".\"").append(column.getName()).append("\"))");
                    b.append(this.triggerConcatCharacter).append("'");
                    break;
                }
                case -1: 
                case 1: 
                case 12: {
                    b.append("'''").append(this.triggerConcatCharacter);
                    b.append(alias).append(".\"").append(column.getName()).append("\"");
                    b.append(this.triggerConcatCharacter).append("'''");
                    break;
                }
                case 91: 
                case 93: {
                    b.append("{ts '''").append(this.triggerConcatCharacter);
                    b.append("rtrim(char(").append(alias).append(".\"").append(column.getName()).append("\"))");
                    b.append(this.triggerConcatCharacter).append("'''}");
                }
            }
            if (column.equals((Object)columns[columns.length - 1])) continue;
            b.append(" and ");
        }
        b.append("'");
        return b.toString();
    }

    private ColumnString buildColumnString(String origTableAlias, String tableAlias, String columnPrefix, Column[] columns, IDbDialect dbDialect, DataEventType dml, boolean isOld, Channel channel, Trigger trigger) {
        String columnsText = "";
        boolean isLob = false;
        String lastCommandToken = dbDialect.escapesTemplatesForDatabaseInserts() ? this.triggerConcatCharacter + "'',''" + this.triggerConcatCharacter : this.triggerConcatCharacter + "','" + this.triggerConcatCharacter;
        for (int i = 0; i < columns.length; ++i) {
            Column column = columns[i];
            if (column == null) continue;
            String templateToUse = null;
            switch (column.getTypeCode()) {
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    templateToUse = this.numberColumnTemplate;
                    break;
                }
                case 1: 
                case 12: {
                    templateToUse = this.stringColumnTemplate;
                    break;
                }
                case -1: {
                    templateToUse = this.stringColumnTemplate;
                    isLob = true;
                    break;
                }
                case 2009: {
                    templateToUse = this.xmlColumnTemplate;
                    break;
                }
                case 2003: {
                    templateToUse = this.arrayColumnTemplate;
                    break;
                }
                case 2005: {
                    templateToUse = isOld && dbDialect.needsToSelectLobData() ? this.emptyColumnTemplate : this.clobColumnTemplate;
                    isLob = true;
                    break;
                }
                case 2004: {
                    if (dbDialect instanceof PostgreSqlDbDialect) {
                        templateToUse = this.wrappedBlobColumnTemplate;
                        isLob = true;
                        break;
                    }
                }
                case -10: 
                case -4: 
                case -3: 
                case -2: {
                    templateToUse = isOld && dbDialect.needsToSelectLobData() ? this.emptyColumnTemplate : this.blobColumnTemplate;
                    isLob = true;
                    break;
                }
                case 91: {
                    if (this.noDateColumnTemplate()) {
                        templateToUse = this.datetimeColumnTemplate;
                        break;
                    }
                    templateToUse = this.dateColumnTemplate;
                    break;
                }
                case 92: {
                    if (this.noTimeColumnTemplate()) {
                        templateToUse = this.datetimeColumnTemplate;
                        break;
                    }
                    templateToUse = this.timeColumnTemplate;
                    break;
                }
                case 93: {
                    templateToUse = this.datetimeColumnTemplate;
                    break;
                }
                case -7: 
                case 16: {
                    templateToUse = this.booleanColumnTemplate;
                    break;
                }
                case 0: 
                case 1111: {
                    templateToUse = this.otherColumnTemplate;
                    break;
                }
                default: {
                    if (column.getJdbcTypeName() != null && column.getJdbcTypeName().equalsIgnoreCase("interval")) {
                        templateToUse = this.numberColumnTemplate;
                        break;
                    }
                    throw new NotImplementedException(column.getName() + " is of type " + column.getType() + " with JDBC type of " + column.getJdbcTypeName());
                }
            }
            if (dml == DataEventType.DELETE && isLob && dbDialect instanceof MsSqlDbDialect) {
                templateToUse = this.emptyColumnTemplate;
            } else if (isLob && trigger.isUseStreamLobs()) {
                templateToUse = this.emptyColumnTemplate;
            }
            if (templateToUse == null) {
                throw new NotImplementedException();
            }
            templateToUse = templateToUse.trim();
            String formattedColumnText = AppUtils.replace("columnName", String.format("%s%s", columnPrefix, column.getName()), templateToUse);
            formattedColumnText = AppUtils.replace("masterCollation", dbDialect.getMasterCollation(), formattedColumnText);
            if (isLob) {
                formattedColumnText = dbDialect.massageForLob(formattedColumnText, channel);
            }
            columnsText = columnsText + "\n          " + formattedColumnText + lastCommandToken;
        }
        if (columnsText.endsWith(lastCommandToken)) {
            columnsText = columnsText.substring(0, columnsText.length() - lastCommandToken.length());
        }
        columnsText = AppUtils.replace("origTableAlias", origTableAlias, columnsText);
        columnsText = AppUtils.replace("tableAlias", tableAlias, columnsText);
        columnsText = AppUtils.replace("prefixName", dbDialect.getTablePrefix(), columnsText);
        return new ColumnString(columnsText, isLob);
    }

    public String getOtherColumnTemplate() {
        return this.otherColumnTemplate;
    }

    public void setOtherColumnTemplate(String otherColumnTemplate) {
        this.otherColumnTemplate = otherColumnTemplate;
    }

    private boolean noTimeColumnTemplate() {
        return this.timeColumnTemplate == null || this.timeColumnTemplate.equals("null") || this.timeColumnTemplate.trim().equals("");
    }

    private boolean noDateColumnTemplate() {
        return this.dateColumnTemplate == null || this.dateColumnTemplate.equals("null") || this.dateColumnTemplate.trim().equals("");
    }

    private String buildColumnNameString(String tableAlias, Column[] columns) {
        String columnsText = "";
        for (int i = 0; i < columns.length; ++i) {
            columnsText = columnsText + tableAlias + ".\"" + columns[i].getName() + "\"";
            if (i + 1 >= columns.length) continue;
            columnsText = columnsText + ", ";
        }
        return columnsText;
    }

    private String buildKeyVariablesDeclare(Column[] columns, String prefix) {
        String text = "";
        block13: for (int i = 0; i < columns.length; ++i) {
            text = text + "declare @" + prefix + "pk" + i + " ";
            switch (columns[i].getTypeCode()) {
                case -6: 
                case -5: 
                case 4: 
                case 5: {
                    text = text + "bigint\n";
                    continue block13;
                }
                case 2: 
                case 3: {
                    text = text + "decimal\n";
                    continue block13;
                }
                case 6: 
                case 7: 
                case 8: {
                    text = text + "float\n";
                    continue block13;
                }
                case -1: 
                case 1: 
                case 12: {
                    text = text + "varchar(1000)\n";
                    continue block13;
                }
                case 91: {
                    text = text + "date\n";
                    continue block13;
                }
                case 92: {
                    text = text + "time\n";
                    continue block13;
                }
                case 93: {
                    text = text + "datetime\n";
                    continue block13;
                }
                case -7: 
                case 16: {
                    text = text + "bit\n";
                    continue block13;
                }
                case 2005: {
                    text = text + "varchar(max)\n";
                    continue block13;
                }
                case -10: 
                case -4: 
                case -3: 
                case -2: 
                case 2004: {
                    text = text + "varbinary(max)\n";
                    continue block13;
                }
                case 1111: {
                    text = text + "varbinary(max)\n";
                    continue block13;
                }
                default: {
                    if (columns[i].getJdbcTypeName() != null && columns[i].getJdbcTypeName().equalsIgnoreCase("interval")) {
                        text = text + "interval";
                        continue block13;
                    }
                    throw new NotImplementedException(columns[i] + " is of type " + columns[i].getType());
                }
            }
        }
        return text;
    }

    private String buildKeyVariablesString(Column[] columns, String prefix) {
        String text = "";
        for (int i = 0; i < columns.length; ++i) {
            text = text + "@" + prefix + "pk" + i;
            if (i + 1 >= columns.length) continue;
            text = text + ", ";
        }
        return text;
    }

    public void setStringColumnTemplate(String columnTemplate) {
        this.stringColumnTemplate = columnTemplate;
    }

    public void setXmlColumnTemplate(String columnTemplate) {
        this.xmlColumnTemplate = columnTemplate;
    }

    public void setArrayColumnTemplate(String arrayColumnTemplate) {
        this.arrayColumnTemplate = arrayColumnTemplate;
    }

    public void setDatetimeColumnTemplate(String datetimeColumnTemplate) {
        this.datetimeColumnTemplate = datetimeColumnTemplate;
    }

    public void setNumberColumnTemplate(String numberColumnTemplate) {
        this.numberColumnTemplate = numberColumnTemplate;
    }

    public void setSqlTemplates(Map<String, String> sqlTemplates) {
        this.sqlTemplates = sqlTemplates;
    }

    public String getClobColumnTemplate() {
        return this.clobColumnTemplate;
    }

    public void setClobColumnTemplate(String clobColumnTemplate) {
        this.clobColumnTemplate = clobColumnTemplate;
    }

    public void setBooleanColumnTemplate(String booleanColumnTemplate) {
        this.booleanColumnTemplate = booleanColumnTemplate;
    }

    public void setTriggerConcatCharacter(String triggerConcatCharacter) {
        this.triggerConcatCharacter = triggerConcatCharacter;
    }

    public String getNewTriggerValue() {
        return this.newTriggerValue;
    }

    public void setNewTriggerValue(String newTriggerValue) {
        this.newTriggerValue = newTriggerValue;
    }

    public String getOldTriggerValue() {
        return this.oldTriggerValue;
    }

    public void setOldTriggerValue(String oldTriggerValue) {
        this.oldTriggerValue = oldTriggerValue;
    }

    public String getBlobColumnTemplate() {
        return this.blobColumnTemplate;
    }

    public void setBlobColumnTemplate(String blobColumnTemplate) {
        this.blobColumnTemplate = blobColumnTemplate;
    }

    public String getWrappedBlobColumnTemplate() {
        return this.wrappedBlobColumnTemplate;
    }

    public void setWrappedBlobColumnTemplate(String wrappedBlobColumnTemplate) {
        this.wrappedBlobColumnTemplate = wrappedBlobColumnTemplate;
    }

    public void setFunctionInstalledSql(String functionInstalledSql) {
        this.functionInstalledSql = functionInstalledSql;
    }

    public void setFunctionTemplatesToInstall(Map<String, String> functionTemplatesToInstall) {
        this.functionTemplatesToInstall = functionTemplatesToInstall;
    }

    public void setOldColumnPrefix(String oldColumnPrefix) {
        this.oldColumnPrefix = oldColumnPrefix;
    }

    public void setEmptyColumnTemplate(String emptyColumnTemplate) {
        this.emptyColumnTemplate = emptyColumnTemplate;
    }

    public void setNewColumnPrefix(String newColumnPrefix) {
        this.newColumnPrefix = newColumnPrefix;
    }

    public String getFunctionSql(String functionKey, String functionName, String defaultSchema) {
        if (this.functionTemplatesToInstall != null) {
            String ddl = AppUtils.replace("functionName", functionName, this.functionTemplatesToInstall.get(functionKey));
            ddl = AppUtils.replace("version", Version.versionWithUnderscores(), ddl);
            ddl = AppUtils.replace("defaultSchema", defaultSchema != null && defaultSchema.length() > 0 ? defaultSchema + "." : "", ddl);
            return ddl;
        }
        return null;
    }

    public String getFunctionInstalledSql(String functionName, String defaultSchema) {
        if (this.functionInstalledSql != null) {
            String ddl = AppUtils.replace("functionName", functionName, this.functionInstalledSql);
            ddl = AppUtils.replace("version", Version.versionWithUnderscores(), ddl);
            ddl = AppUtils.replace("defaultSchema", defaultSchema != null && defaultSchema.length() > 0 ? defaultSchema : "", ddl);
            return ddl;
        }
        return null;
    }

    public String getTimeColumnTemplate() {
        return this.timeColumnTemplate;
    }

    public void setTimeColumnTemplate(String timeColumnTemplate) {
        this.timeColumnTemplate = timeColumnTemplate;
    }

    public String getDateColumnTemplate() {
        return this.dateColumnTemplate;
    }

    public void setDateColumnTemplate(String dateColumnTemplate) {
        this.dateColumnTemplate = dateColumnTemplate;
    }

    private class ColumnString {
        String columnString;
        boolean isBlobClob = false;

        ColumnString(String columnExpression, boolean isBlobClob) {
            this.columnString = columnExpression;
            this.isBlobClob = isBlobClob;
        }

        public String toString() {
            return StringUtils.isBlank((String)this.columnString) ? "null" : this.columnString;
        }
    }
}

