/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db;

import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.lang.StringUtils;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourceFactoryBean
implements FactoryBean<DataSource>,
ApplicationContextAware {
    static final ILog log = LogFactory.getLog(DataSourceFactoryBean.class);
    private String jndiName;
    private String beanName;
    private ApplicationContext applicationContext;
    private String connectionProperties;

    public DataSource getObject() throws Exception {
        DataSource dataSource = null;
        dataSource = this.jndiName == null || this.jndiName.trim().length() == 0 ? (this.beanName.startsWith("parent.") && this.applicationContext.getParent() != null ? (DataSource)this.applicationContext.getParent().getBean(this.beanName.substring("parent.".length())) : (DataSource)this.applicationContext.getBean(this.beanName)) : (DataSource)this.applicationContext.getBean("jndiDataSource");
        this.applyConnectionProperties(dataSource);
        return dataSource;
    }

    protected void applyConnectionProperties(DataSource dataSource) {
        if (StringUtils.isNotBlank((String)this.connectionProperties) && dataSource instanceof BasicDataSource) {
            String[] properties;
            BasicDataSource bds = (BasicDataSource)dataSource;
            for (String property : properties = this.connectionProperties.split(";")) {
                String[] keyValue = property.split("=");
                if (keyValue == null || keyValue.length <= 1) continue;
                log.info("DatabaseSettingConnectionProperty", keyValue[0], keyValue[1]);
                bds.addConnectionProperty(keyValue[0], keyValue[1]);
            }
        }
    }

    public Class<DataSource> getObjectType() {
        return DataSource.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void setConnectionProperties(String connectionProperties) {
        this.connectionProperties = connectionProperties;
    }
}

