/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db;

import java.util.ArrayList;
import org.apache.commons.collections.CollectionUtils;
import org.jumpmind.symmetric.ddl.model.Column;
import org.jumpmind.symmetric.ddl.model.Table;
import org.jumpmind.symmetric.load.IColumnFilter;
import org.jumpmind.symmetric.load.IDataLoaderContext;
import org.jumpmind.symmetric.load.StatementBuilder;

public class AutoIncrementColumnFilter
implements IColumnFilter {
    int[] indexesToRemove = null;

    public String[] filterColumnsNames(IDataLoaderContext ctx, StatementBuilder.DmlType dml, Table table, String[] columnNames) {
        Column[] autoIncrementColumns;
        this.indexesToRemove = null;
        if (dml == StatementBuilder.DmlType.UPDATE && (autoIncrementColumns = table.getAutoIncrementColumns()) != null && autoIncrementColumns.length > 0) {
            ArrayList columns = new ArrayList();
            CollectionUtils.addAll(columns, (Object[])columnNames);
            this.indexesToRemove = new int[autoIncrementColumns.length];
            int i = 0;
            for (Column column : autoIncrementColumns) {
                String name = column.getName();
                int index = columns.indexOf(name);
                if (index < 0) {
                    name = name.toLowerCase();
                    index = columns.indexOf(name);
                }
                if (index < 0) {
                    name = name.toUpperCase();
                    index = columns.indexOf(name);
                }
                this.indexesToRemove[i++] = index;
                columns.remove(name);
            }
            columnNames = columns.toArray(new String[columns.size()]);
        }
        return columnNames;
    }

    public String[] filterColumnsValues(IDataLoaderContext ctx, StatementBuilder.DmlType dml, Table table, String[] columnValues) {
        if (dml == StatementBuilder.DmlType.UPDATE && this.indexesToRemove != null) {
            ArrayList values = new ArrayList();
            CollectionUtils.addAll(values, (Object[])columnValues);
            for (int index : this.indexesToRemove) {
                if (index < 0) continue;
                values.remove(index);
            }
            return values.toArray(new String[values.size()]);
        }
        return columnValues;
    }

    public boolean isAutoRegister() {
        return false;
    }
}

