/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.lang.time.FastDateFormat;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;
import org.jumpmind.symmetric.db.BinaryEncoding;
import org.jumpmind.symmetric.db.DatabaseModel;
import org.jumpmind.symmetric.db.IDbDialect;
import org.jumpmind.symmetric.db.SequenceIdentifier;
import org.jumpmind.symmetric.db.SqlScript;
import org.jumpmind.symmetric.db.SqlTemplate;
import org.jumpmind.symmetric.db.sybase.SybaseDbDialect;
import org.jumpmind.symmetric.ddl.Platform;
import org.jumpmind.symmetric.ddl.io.DatabaseIO;
import org.jumpmind.symmetric.ddl.model.Column;
import org.jumpmind.symmetric.ddl.model.Database;
import org.jumpmind.symmetric.ddl.model.ForeignKey;
import org.jumpmind.symmetric.ddl.model.Index;
import org.jumpmind.symmetric.ddl.model.Table;
import org.jumpmind.symmetric.ddl.platform.SqlBuilder;
import org.jumpmind.symmetric.ext.IDatabaseUpgradeListener;
import org.jumpmind.symmetric.load.IColumnFilter;
import org.jumpmind.symmetric.load.StatementBuilder;
import org.jumpmind.symmetric.model.Channel;
import org.jumpmind.symmetric.model.DataEventType;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.jumpmind.symmetric.model.TriggerRouter;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.util.AppUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.TransientDataAccessResourceException;
import org.springframework.jdbc.UncategorizedSQLException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.lob.LobHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDbDialect
implements IDbDialect {
    protected ILog log = LogFactory.getLog(this.getClass());
    public static final String REQUIRED_FIELD_NULL_SUBSTITUTE = " ";
    public static final String[] TIMESTAMP_PATTERNS = new String[]{"yyyy-MM-dd HH:mm:ss.S", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy-MM-dd"};
    public static final String[] TIME_PATTERNS = new String[]{"HH:mm:ss.S", "HH:mm:ss", "yyyy-MM-dd HH:mm:ss.S", "yyyy-MM-dd HH:mm:ss"};
    public static final FastDateFormat JDBC_TIMESTAMP_FORMATTER = FastDateFormat.getInstance((String)"yyyy-MM-dd hh:mm:ss.SSS");
    public static final int MAX_SYMMETRIC_SUPPORTED_TRIGGER_SIZE = 50;
    protected JdbcTemplate jdbcTemplate;
    protected Platform platform;
    protected DatabaseModel cachedModel = new DatabaseModel();
    protected long lastTimeCachedModelClearedInMs = System.currentTimeMillis();
    protected SqlTemplate sqlTemplate;
    protected IParameterService parameterService;
    protected String tablePrefix;
    protected int streamingResultsFetchSize;
    protected Boolean supportsGetGeneratedKeys;
    protected String databaseName;
    protected String driverVersion;
    protected String driverName;
    protected int databaseMajorVersion;
    protected int databaseMinorVersion;
    protected String databaseProductVersion;
    protected String identifierQuoteString = "";
    protected Set<String> sqlKeywords;
    private String defaultSchema;
    protected LobHandler lobHandler;
    protected boolean supportsTransactionViews = false;
    protected int queryTimeoutInSeconds = 300;
    protected int[] primaryKeyViolationCodes;
    protected String[] primaryKeyViolationSqlStates;
    protected List<IDatabaseUpgradeListener> databaseUpgradeListeners = new ArrayList<IDatabaseUpgradeListener>();

    protected AbstractDbDialect() {
    }

    @Override
    public String encodeForCsv(byte[] data) {
        if (data != null) {
            BinaryEncoding encoding = this.getBinaryEncoding();
            if (BinaryEncoding.BASE64.equals((Object)encoding)) {
                return new String(Base64.encodeBase64((byte[])data));
            }
            if (BinaryEncoding.HEX.equals((Object)encoding)) {
                return new String(Hex.encodeHex((byte[])data));
            }
            throw new NotImplementedException();
        }
        return null;
    }

    @Override
    public String toFormattedTimestamp(Date time) {
        StringBuilder ts = new StringBuilder("{ts '");
        ts.append(JDBC_TIMESTAMP_FORMATTER.format(time));
        ts.append("'}");
        return ts.toString();
    }

    @Override
    public IColumnFilter newDatabaseColumnFilter() {
        return null;
    }

    @Override
    public void allowIdentityInserts(JdbcTemplate jdbcTemplate, Table table) {
    }

    @Override
    public void revertAllowIdentityInserts(JdbcTemplate jdbcTemplate, Table table) {
    }

    protected boolean allowsNullForIdentityColumn() {
        return true;
    }

    @Override
    public boolean requiresAutoCommitFalseToSetFetchSize() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetCachedTableModel() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            this.cachedModel.resetTableIndexCache();
            Table[] tables = this.cachedModel.getTables();
            if (tables != null) {
                for (Table table : tables) {
                    this.cachedModel.removeTable(table);
                }
            }
        }
    }

    @Override
    public int getMaxTriggerNameLength() {
        int max = this.getPlatform().getPlatformInfo().getMaxColumnNameLength();
        return max < 50 && max > 0 ? max : 50;
    }

    public void init(Platform pf, int queryTimeout, JdbcTemplate jdbcTemplate) {
        this.log.info("DbDialectInUse", this.getClass().getName());
        this.jdbcTemplate = jdbcTemplate;
        this.queryTimeoutInSeconds = queryTimeout;
        this.jdbcTemplate.setQueryTimeout(queryTimeout);
        this.platform = pf;
        this.identifierQuoteString = "\"";
        jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<Object>(){

            public Object doInConnection(Connection c) throws SQLException, DataAccessException {
                DatabaseMetaData meta = c.getMetaData();
                AbstractDbDialect.this.databaseName = meta.getDatabaseProductName();
                AbstractDbDialect.this.databaseMajorVersion = meta.getDatabaseMajorVersion();
                AbstractDbDialect.this.databaseMinorVersion = meta.getDatabaseMinorVersion();
                AbstractDbDialect.this.databaseProductVersion = meta.getDatabaseProductVersion();
                AbstractDbDialect.this.driverName = meta.getDriverName();
                AbstractDbDialect.this.driverVersion = meta.getDriverVersion();
                return null;
            }
        });
        this.initLobHandler();
    }

    @Override
    public int getQueryTimeoutInSeconds() {
        return this.queryTimeoutInSeconds;
    }

    protected void initTablesAndFunctionsForSpecificDialect() {
    }

    @Override
    public void initTablesAndFunctions() {
        this.initTablesAndFunctionsForSpecificDialect();
        this.createTablesIfNecessary();
        this.createRequiredFunctions();
        this.resetCachedTableModel();
    }

    @Override
    public final boolean doesTriggerExist(String catalogName, String schema, String tableName, String triggerName) {
        try {
            return this.doesTriggerExistOnPlatform(catalogName, schema, tableName, triggerName);
        }
        catch (Exception ex) {
            this.log.warn("TriggerMayExist", ex);
            return false;
        }
    }

    protected void createRequiredFunctions() {
        String[] functions = this.sqlTemplate.getFunctionsToInstall();
        for (int i = 0; i < functions.length; ++i) {
            String funcName = this.tablePrefix + "_" + functions[i];
            if (this.jdbcTemplate.queryForInt(this.sqlTemplate.getFunctionInstalledSql(funcName, this.getDefaultSchema())) != 0) continue;
            this.jdbcTemplate.update(this.sqlTemplate.getFunctionSql(functions[i], funcName, this.getDefaultSchema()));
            this.log.info("FunctionInstalled", funcName);
        }
    }

    @Override
    public BinaryEncoding getBinaryEncoding() {
        return BinaryEncoding.NONE;
    }

    @Override
    public boolean isDateOverrideToTimestamp() {
        return false;
    }

    protected abstract boolean doesTriggerExistOnPlatform(String var1, String var2, String var3, String var4);

    @Override
    public String getTransactionTriggerExpression(String defaultCatalog, String defaultSchema, Trigger trigger) {
        return "null";
    }

    @Override
    public String createInitialLoadSqlFor(Node node, TriggerRouter trigger, Table table, TriggerHistory triggerHistory, Channel channel) {
        return this.sqlTemplate.createInitalLoadSql(node, this, trigger, table, triggerHistory, channel).trim();
    }

    @Override
    public String createPurgeSqlFor(Node node, TriggerRouter triggerRouter) {
        return String.format(this.parameterService.getString("initial.load.delete.first.sql"), triggerRouter.qualifiedTargetTableName());
    }

    @Override
    public String createCsvDataSql(Trigger trigger, TriggerHistory triggerHistory, Channel channel, String whereClause) {
        return this.sqlTemplate.createCsvDataSql(this, trigger, triggerHistory, this.getTable(trigger.getSourceCatalogName(), trigger.getSourceSchemaName(), trigger.getSourceTableName(), true), channel, whereClause).trim();
    }

    @Override
    public String createCsvPrimaryKeySql(Trigger trigger, TriggerHistory triggerHistory, Channel channel, String whereClause) {
        return this.sqlTemplate.createCsvPrimaryKeySql(this, trigger, triggerHistory, this.getTable(trigger.getSourceCatalogName(), trigger.getSourceSchemaName(), trigger.getSourceTableName(), true), channel, whereClause).trim();
    }

    @Override
    public Table getTable(Trigger trigger, boolean useCache) {
        return this.getTable(trigger.getSourceCatalogName(), trigger.getSourceSchemaName(), trigger.getSourceTableName(), useCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Table getTable(String catalogName, String schemaName, String tableName, boolean useCache) {
        DatabaseModel model;
        Table retTable;
        if (System.currentTimeMillis() - this.lastTimeCachedModelClearedInMs > this.parameterService.getLong("cache.table.time.ms")) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                this.cachedModel = new DatabaseModel();
                this.lastTimeCachedModelClearedInMs = System.currentTimeMillis();
            }
        }
        Table table = retTable = (model = this.cachedModel) != null ? model.findTable(catalogName, schemaName, tableName) : null;
        if (retTable == null || !useCache) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                try {
                    Table table2 = this.getTable(catalogName, schemaName, tableName);
                    if (retTable != null) {
                        this.cachedModel.removeTable(retTable);
                    }
                    if (table2 != null) {
                        this.cachedModel.addTable(table2);
                    }
                    retTable = table2;
                }
                catch (RuntimeException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        return retTable;
    }

    @Override
    public Set<String> getSqlKeywords() {
        if (this.sqlKeywords == null) {
            this.jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<Object>(){

                public Object doInConnection(Connection con) throws SQLException, DataAccessException {
                    DatabaseMetaData metaData = con.getMetaData();
                    AbstractDbDialect.this.sqlKeywords = new HashSet<String>(Arrays.asList(metaData.getSQLKeywords().split(",")));
                    return null;
                }
            });
        }
        return this.sqlKeywords;
    }

    protected Table getTable(String catalogName, String schemaName, String tblName) {
        Table table;
        block3: {
            table = this.getTableCaseSensitive(catalogName, schemaName, tblName, true);
            try {
                if (table == null && this.parameterService.is("db.metadata.ignore.case") && (table = this.getTableCaseSensitive(StringUtils.upperCase((String)catalogName), StringUtils.upperCase((String)schemaName), StringUtils.upperCase((String)tblName), true)) == null && (table = this.getTableCaseSensitive(StringUtils.lowerCase((String)catalogName), StringUtils.lowerCase((String)schemaName), StringUtils.lowerCase((String)tblName), true)) == null && (table = this.getTableCaseSensitive(catalogName, schemaName, StringUtils.upperCase((String)tblName), true)) == null && (table = this.getTableCaseSensitive(catalogName, schemaName, StringUtils.lowerCase((String)tblName), true)) == null) {
                    table = this.getTableCaseSensitive(catalogName, schemaName, tblName, true);
                }
            }
            catch (UncategorizedSQLException e) {
                if (this instanceof SybaseDbDialect && e.getCause() instanceof SQLException && ((SQLException)e.getCause()).getErrorCode() == 911) break block3;
                throw e;
            }
        }
        return table;
    }

    protected Table getTableCaseSensitive(String catalogName, String schemaName, final String tablename, final boolean massageTableForChangeDataCapture) {
        Table table = null;
        try {
            final String schema = StringUtils.isBlank((String)schemaName) ? this.getDefaultSchema() : schemaName;
            final String catalog = StringUtils.isBlank((String)catalogName) ? this.getDefaultCatalog() : catalogName;
            table = (Table)this.jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<Table>(){

                public Table doInConnection(Connection c) throws SQLException, DataAccessException {
                    Table table = AbstractDbDialect.this.platform.readTableFromDatabase(c, catalog, schema, tablename);
                    if (table != null && massageTableForChangeDataCapture) {
                        Column[] columns;
                        boolean treatDateTimeFieldsAsVarchar = AbstractDbDialect.this.parameterService.is("db.treat.date.time.as.varchar.enabled", false);
                        for (Column column : columns = table.getColumns()) {
                            int typeCode = column.getTypeCode();
                            if (treatDateTimeFieldsAsVarchar && (typeCode == 91 || typeCode == 92 || typeCode == 93)) {
                                typeCode = 12;
                            }
                            column.setTypeCode(typeCode);
                        }
                    }
                    return table;
                }
            });
        }
        catch (DataAccessResourceFailureException ex) {
            this.log.debug("Message", ex.getMessage());
        }
        catch (TransientDataAccessResourceException ex) {
            this.log.debug("Message", ex.getMessage());
        }
        return table;
    }

    @Override
    public void removeTrigger(StringBuilder sqlBuffer, String catalogName, String schemaName, String triggerName, String tableName, TriggerHistory oldHistory) {
        schemaName = schemaName == null ? "" : schemaName + ".";
        String sql = "drop trigger " + schemaName + triggerName;
        this.logSql(sql, sqlBuffer);
        if (this.parameterService.is("auto.sync.triggers")) {
            try {
                this.jdbcTemplate.update(sql);
            }
            catch (Exception e) {
                this.log.warn("TriggerDoesNotExist");
            }
        }
    }

    protected final void logSql(String sql, StringBuilder sqlBuffer) {
        if (sqlBuffer != null) {
            sqlBuffer.append(sql);
            sqlBuffer.append(System.getProperty("line.separator"));
            sqlBuffer.append(System.getProperty("line.separator"));
        }
    }

    @Override
    public void createTrigger(final StringBuilder sqlBuffer, final DataEventType dml, final Trigger trigger, final TriggerHistory hist, final Channel channel, final String tablePrefix, final Table table) {
        this.jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public Object doInConnection(Connection con) throws SQLException, DataAccessException {
                AbstractDbDialect.this.log.info("TriggerCreating", hist.getTriggerNameForDmlType(dml), trigger.getSourceTableName());
                String previousCatalog = null;
                String sourceCatalogName = trigger.getSourceCatalogName();
                String defaultCatalog = AbstractDbDialect.this.getDefaultCatalog();
                String defaultSchema = AbstractDbDialect.this.getDefaultSchema();
                try {
                    previousCatalog = AbstractDbDialect.this.switchCatalogForTriggerInstall(sourceCatalogName, con);
                    String triggerSql = AbstractDbDialect.this.sqlTemplate.createTriggerDDL(AbstractDbDialect.this, dml, trigger, hist, channel, tablePrefix, table, defaultCatalog, defaultSchema);
                    if (AbstractDbDialect.this.parameterService.is("auto.sync.triggers")) {
                        Statement stmt = con.createStatement();
                        stmt.setQueryTimeout(AbstractDbDialect.this.jdbcTemplate.getQueryTimeout());
                        try {
                            AbstractDbDialect.this.log.debug("Sql", triggerSql);
                            stmt.executeUpdate(triggerSql);
                        }
                        catch (SQLException ex) {
                            AbstractDbDialect.this.log.error("TriggerCreateFailed", triggerSql);
                            throw ex;
                        }
                        String postTriggerDml = AbstractDbDialect.this.createPostTriggerDDL(dml, trigger, hist, channel, tablePrefix, table);
                        if (postTriggerDml != null) {
                            try {
                                stmt.executeUpdate(postTriggerDml);
                            }
                            catch (SQLException ex) {
                                AbstractDbDialect.this.log.error("PostTriggerCreateFailed", postTriggerDml);
                                throw ex;
                            }
                        }
                        stmt.close();
                    }
                    AbstractDbDialect.this.logSql(triggerSql, sqlBuffer);
                    Object var11_11 = null;
                    if (sourceCatalogName == null) return null;
                    if (sourceCatalogName.equalsIgnoreCase(previousCatalog)) return null;
                }
                catch (Throwable throwable) {
                    Object var11_12 = null;
                    if (sourceCatalogName == null || sourceCatalogName.equalsIgnoreCase(previousCatalog)) throw throwable;
                    AbstractDbDialect.this.switchCatalogForTriggerInstall(previousCatalog, con);
                    throw throwable;
                }
                AbstractDbDialect.this.switchCatalogForTriggerInstall(previousCatalog, con);
                return null;
            }
        });
    }

    protected String switchCatalogForTriggerInstall(String catalog, Connection c) throws SQLException {
        return null;
    }

    protected String createPostTriggerDDL(DataEventType dml, Trigger trigger, TriggerHistory hist, Channel channel, String tablePrefix, Table table) {
        return this.sqlTemplate.createPostTriggerDDL(this, dml, trigger, hist, channel, tablePrefix, table, this.getDefaultCatalog(), this.getDefaultSchema());
    }

    @Override
    public String getCreateSymmetricDDL() {
        Database db = this.readSymmetricSchemaFromXml();
        this.prefixConfigDatabase(db);
        return this.platform.getCreateTablesSql(db, true, true);
    }

    @Override
    public String getCreateTableSQL(TriggerRouter trig) {
        Table table = this.getTable(null, trig.getTrigger().getSourceSchemaName(), trig.getTrigger().getSourceTableName(), true);
        String sql = null;
        try {
            StringWriter buffer = new StringWriter();
            this.platform.getSqlBuilder().setWriter((Writer)buffer);
            this.platform.getSqlBuilder().createTable((Database)this.cachedModel, table);
            sql = buffer.toString();
        }
        catch (IOException e) {
            // empty catch block
        }
        return sql;
    }

    private void setDatabaseName(TriggerRouter triggerRouter, Database db) {
        db.setName(triggerRouter.getTargetSchema(this.getDefaultSchema()));
        if (db.getName() == null) {
            db.setName(this.getDefaultCatalog());
        }
        if (db.getName() == null) {
            db.setName("DDL");
        }
    }

    @Override
    public String getCreateTableXML(TriggerRouter triggerRouter) {
        Table table = this.getTable(null, triggerRouter.getTrigger().getSourceSchemaName(), triggerRouter.getTrigger().getSourceTableName());
        table.setName(triggerRouter.getTargetTable());
        Database db = new Database();
        this.setDatabaseName(triggerRouter, db);
        db.addTable(table);
        StringWriter buffer = new StringWriter();
        DatabaseIO xmlWriter = new DatabaseIO();
        xmlWriter.write(db, (Writer)buffer);
        String xml = buffer.toString().replaceAll("&apos;", "");
        xml = xml.replaceAll("default=\"empty_blob\\(\\) *\"", "");
        xml = xml.replaceAll("unique name=\"PRIMARY\"", "unique name=\"PRIMARYINDEX\"");
        xml = xml.replaceAll("type=\"VARCHAR\" size=\"2147483647\"", "type=\"LONGVARCHAR\"");
        xml = xml.replaceAll("type=\"BINARY\" size=\"2147483647\"", "type=\"LONGVARBINARY\"");
        return xml;
    }

    @Override
    public void createTables(String xml) {
        StringReader reader = new StringReader(xml);
        Database db = new DatabaseIO().read((Reader)reader);
        this.platform.createTables(db, true, true);
    }

    @Override
    public boolean doesDatabaseNeedConfigured() {
        return this.prefixConfigDatabase(this.readSymmetricSchemaFromXml());
    }

    protected boolean prefixConfigDatabase(Database targetTables) {
        try {
            String tblPrefix = this.tablePrefix + "_";
            Table[] tables = targetTables.getTables();
            boolean createTables = false;
            for (Table table : tables) {
                table.setName(tblPrefix + table.getName());
                this.fixForeignKeys(table, tblPrefix);
                this.fixIndexes(table, tblPrefix);
                if (this.getTable(this.getDefaultCatalog(), this.getDefaultSchema(), table.getName(), false) != null) continue;
                createTables = true;
            }
            return createTables;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Database readPlatformDatabase(boolean includeSymmetricTables) {
        String schema = this.getDefaultSchema();
        String catalog = this.getDefaultCatalog();
        Database database = this.platform.readModelFromDatabase(!StringUtils.isBlank((String)schema) ? schema : (!StringUtils.isBlank((String)catalog) ? catalog : "database"), catalog, schema, null);
        if (!includeSymmetricTables) {
            Table[] allTables;
            Table[] tables;
            Database symmetricTables = this.readSymmetricSchemaFromXml();
            for (Table symTable : tables = symmetricTables.getTables()) {
                for (Table table : database.getTables()) {
                    if (!table.getName().equalsIgnoreCase(symTable.getName())) continue;
                    database.removeTable(table);
                }
            }
            for (Table table : allTables = database.getTables()) {
                if (!table.getName().startsWith(this.tablePrefix.toUpperCase() + "_ON_") && !table.getName().equalsIgnoreCase(this.tablePrefix + "_" + "context")) continue;
                database.removeTable(table);
            }
        }
        return database;
    }

    protected boolean createTablesIfNecessary() {
        Database modelFromXml = this.readSymmetricSchemaFromXml();
        String extraTablesXml = this.parameterService.getString("auto.config.extra.tables.ddlutil.xml");
        if (StringUtils.isNotBlank((String)extraTablesXml)) {
            try {
                modelFromXml = this.merge(modelFromXml, this.readDatabaseFromXml(extraTablesXml));
            }
            catch (Exception ex) {
                this.log.error(ex);
            }
        }
        try {
            Table[] tablesFromXml;
            this.log.info("TablesAutoUpdatingStart");
            Database modelFromDatabase = new Database();
            for (Table tableFromXml : tablesFromXml = modelFromXml.getTables()) {
                Table tableFromDatabase = this.getTableCaseSensitive(this.getDefaultCatalog(), this.getDefaultSchema(), tableFromXml.getName(), false);
                if (tableFromDatabase == null) continue;
                modelFromDatabase.addTable(tableFromDatabase);
            }
            SqlBuilder builder = this.platform.getSqlBuilder();
            if (builder.isAlterDatabase(modelFromDatabase, modelFromXml, null)) {
                this.log.info("TablesAutoUpdatingFoundTablesToAlter");
                DataSource ds = this.jdbcTemplate.getDataSource();
                String delimiter = this.platform.getPlatformInfo().getSqlCommandDelimiter();
                for (IDatabaseUpgradeListener listener : this.databaseUpgradeListeners) {
                    String sql = listener.beforeUpgrade(this, this.tablePrefix, modelFromDatabase, modelFromXml);
                    new SqlScript(sql, ds, true, delimiter, null).execute();
                }
                StringWriter writer = new StringWriter();
                builder.setWriter((Writer)writer);
                builder.alterDatabase(modelFromDatabase, modelFromXml, null);
                String alterSql = writer.toString();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("TablesAutoUpdatingAlterSql", alterSql);
                }
                new SqlScript(alterSql, ds, true, delimiter, null).execute();
                for (IDatabaseUpgradeListener listener : this.databaseUpgradeListeners) {
                    String sql = listener.afterUpgrade(this, this.tablePrefix, modelFromXml);
                    new SqlScript(sql, ds, true, delimiter, null).execute();
                }
                this.log.info("TablesAutoUpdatingDone");
                return true;
            }
            return false;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected String getAlterSql(Database databaseTables) throws IOException {
        Database currentModel = new Database();
        Table[] tables = databaseTables.getTables();
        Database existingModel = this.readPlatformDatabase(true);
        for (Table table : tables) {
            Table currentVersion = existingModel.findTable(table.getName());
            if (currentVersion == null) continue;
            currentModel.addTable(currentVersion);
        }
        SqlBuilder builder = this.platform.getSqlBuilder();
        StringWriter writer = new StringWriter();
        builder.setWriter((Writer)writer);
        builder.alterDatabase(currentModel, databaseTables, null);
        return writer.toString();
    }

    protected Database readSymmetricSchemaFromXml() {
        try {
            Database database = this.merge(this.readDatabaseFromXml("/symmetric-schema.xml"), this.readDatabaseFromXml("/console-schema.xml"));
            if (this.prefixConfigDatabase(database)) {
                this.log.info("TablesMissing");
            }
            return database;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected Database readDatabaseFromXml(String resourceName) throws IOException {
        URL url = AbstractDbDialect.class.getResource(resourceName);
        if (url != null) {
            DatabaseIO io = new DatabaseIO();
            io.setValidateXml(false);
            return io.read((Reader)new InputStreamReader(url.openStream()));
        }
        return new Database();
    }

    protected Database merge(Database ... databases) {
        Database database = new Database();
        if (databases != null) {
            for (Database db : databases) {
                Table[] tables;
                for (Table table : tables = db.getTables()) {
                    database.addTable(table);
                }
            }
        }
        return database;
    }

    protected void fixForeignKeys(Table table, String tablePrefix) throws CloneNotSupportedException {
        ForeignKey[] keys;
        for (ForeignKey key : keys = table.getForeignKeys()) {
            String prefixedName = tablePrefix + key.getForeignTableName();
            key.setForeignTableName(prefixedName);
            key.setName(tablePrefix + key.getName());
        }
    }

    protected void fixIndexes(Table table, String tablePrefix) throws CloneNotSupportedException {
        Index[] indexes = table.getIndices();
        if (indexes != null) {
            for (Index index : indexes) {
                String prefixedName = tablePrefix + index.getName();
                index.setName(prefixedName);
            }
        }
    }

    @Override
    public Platform getPlatform() {
        return this.platform;
    }

    @Override
    public String getName() {
        return this.databaseName;
    }

    @Override
    public String getVersion() {
        return this.databaseMajorVersion + "." + this.databaseMinorVersion;
    }

    @Override
    public int getMajorVersion() {
        return this.databaseMajorVersion;
    }

    @Override
    public int getMinorVersion() {
        return this.databaseMinorVersion;
    }

    @Override
    public String getProductVersion() {
        return this.databaseProductVersion;
    }

    @Override
    public boolean supportsGetGeneratedKeys() {
        if (this.supportsGetGeneratedKeys == null) {
            this.supportsGetGeneratedKeys = (Boolean)this.jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<Boolean>(){

                public Boolean doInConnection(Connection conn) throws SQLException, DataAccessException {
                    return conn.getMetaData().supportsGetGeneratedKeys();
                }
            });
        }
        return this.supportsGetGeneratedKeys;
    }

    @Override
    public boolean supportsTransactionViews() {
        return this.supportsTransactionViews;
    }

    @Override
    public boolean supportsReturningKeys() {
        return false;
    }

    @Override
    public String getSelectLastInsertIdSql(String sequenceName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long insertWithGeneratedKey(String sql, SequenceIdentifier sequenceId) {
        return this.insertWithGeneratedKey(this.jdbcTemplate, sql, sequenceId, null);
    }

    protected String getSequenceName(SequenceIdentifier identifier) {
        switch (identifier) {
            case OUTGOING_BATCH: {
                return "sym_outgoing_batch_batch_id";
            }
            case DATA: {
                return "sym_data_data_id";
            }
            case TRIGGER_HIST: {
                return "sym_trigger_his_ger_hist_id";
            }
        }
        return null;
    }

    protected String getSequenceKeyName(SequenceIdentifier identifier) {
        switch (identifier) {
            case OUTGOING_BATCH: {
                return "batch_id";
            }
            case DATA: {
                return "data_id";
            }
            case TRIGGER_HIST: {
                return "trigger_hist_id";
            }
        }
        return null;
    }

    @Override
    public Column[] orderColumns(String[] columnNames, Table table) {
        Column[] unorderedColumns = table.getColumns();
        Column[] orderedColumns = new Column[columnNames.length];
        block0: for (int i = 0; i < columnNames.length; ++i) {
            String name = columnNames[i];
            for (Column column : unorderedColumns) {
                if (!column.getName().equalsIgnoreCase(name)) continue;
                orderedColumns[i] = column;
                continue block0;
            }
        }
        return orderedColumns;
    }

    @Override
    public Object[] getObjectValues(BinaryEncoding encoding, Table table, String[] columnNames, String[] values) {
        Column[] metaData = this.orderColumns(columnNames, table);
        return this.getObjectValues(encoding, values, metaData);
    }

    @Override
    public Object[] getObjectValues(BinaryEncoding encoding, String[] values, Column[] orderedMetaData) {
        ArrayList<String> list = new ArrayList<String>(values.length);
        for (int i = 0; i < values.length; ++i) {
            String value = values[i];
            Object objectValue = value;
            Column column = orderedMetaData[i];
            try {
                if (column == null) continue;
                int type = column.getTypeCode();
                if ((value == null || this.isEmptyStringNulled() && value.equals("")) && column.isRequired() && column.isOfTextType()) {
                    objectValue = REQUIRED_FIELD_NULL_SUBSTITUTE;
                }
                if (value != null) {
                    if (type == 91 && !this.isDateOverrideToTimestamp()) {
                        objectValue = this.getDate(value, TIMESTAMP_PATTERNS);
                    } else if (type == 93 || type == 91 && this.isDateOverrideToTimestamp()) {
                        objectValue = new Timestamp(this.getTime(value, TIMESTAMP_PATTERNS));
                    } else if (type == 1) {
                        String charValue = value.toString();
                        if (StringUtils.isBlank((String)charValue) && this.isBlankCharColumnSpacePadded() || StringUtils.isNotBlank((String)charValue) && this.isNonBlankCharColumnSpacePadded()) {
                            objectValue = StringUtils.rightPad((String)value.toString(), (int)column.getSizeAsInt(), (char)' ');
                        }
                    } else if (type == 4 || type == 5 || type == -7) {
                        objectValue = Integer.valueOf(value);
                    } else if (type == 2 || type == 3 || type == 6 || type == 8) {
                        objectValue = new BigDecimal(value.replace(',', '.'));
                    } else if (type == 16) {
                        objectValue = value.equals("1") ? Boolean.TRUE : Boolean.FALSE;
                    } else if (type == 2004 || type == -4 || type == -2 || type == -3 || type == -10) {
                        if (encoding == BinaryEncoding.NONE) {
                            objectValue = value.getBytes();
                        } else if (encoding == BinaryEncoding.BASE64) {
                            objectValue = Base64.decodeBase64((byte[])value.getBytes());
                        } else if (encoding == BinaryEncoding.HEX) {
                            objectValue = Hex.decodeHex((char[])value.toCharArray());
                        }
                    } else if (type == 92) {
                        objectValue = new Time(this.getTime(value, TIME_PATTERNS));
                    } else if (type == 2003) {
                        objectValue = this.createArray(column, value);
                    }
                }
                if (objectValue instanceof String) {
                    objectValue = this.cleanTextForTextBasedColumns((String)objectValue);
                }
                list.add((String)objectValue);
                continue;
            }
            catch (Exception ex) {
                this.log.error("DbDialectTroubleConvertingColumnValue", value, column.getName(), column.getType());
                throw new RuntimeException(ex);
            }
        }
        return list.toArray();
    }

    protected String cleanTextForTextBasedColumns(String text) {
        return text;
    }

    protected Array createArray(Column column, String value) {
        return null;
    }

    @Override
    public boolean isBlankCharColumnSpacePadded() {
        return this.isNonBlankCharColumnSpacePadded();
    }

    private final Date getDate(String value, String[] pattern) {
        try {
            return DateUtils.parseDate((String)value, (String[])pattern);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    private final long getTime(String value, String[] pattern) {
        return this.getDate(value, pattern).getTime();
    }

    @Override
    public long insertWithGeneratedKey(String sql, SequenceIdentifier sequenceId, PreparedStatementCallback<Object> callback) {
        return this.insertWithGeneratedKey(this.jdbcTemplate, sql, sequenceId, callback);
    }

    @Override
    public long insertWithGeneratedKey(final JdbcTemplate jdbcTemplate, final String sql, final SequenceIdentifier sequenceId, final PreparedStatementCallback<Object> callback) {
        return (Long)jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<Long>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Long doInConnection(Connection conn) throws SQLException, DataAccessException {
                long key = 0L;
                PreparedStatement ps = null;
                try {
                    block16: {
                        boolean supportsGetGeneratedKeys = AbstractDbDialect.this.supportsGetGeneratedKeys();
                        boolean supportsReturningKeys = AbstractDbDialect.this.supportsReturningKeys();
                        if (AbstractDbDialect.this.allowsNullForIdentityColumn()) {
                            ps = supportsGetGeneratedKeys ? conn.prepareStatement(sql, new int[]{1}) : (supportsReturningKeys ? conn.prepareStatement(sql + " returning " + AbstractDbDialect.this.getSequenceKeyName(sequenceId)) : conn.prepareStatement(sql));
                        } else {
                            String replaceSql = sql.replaceFirst("\\(\\w*,", "(").replaceFirst("\\(null,", "(");
                            ps = supportsGetGeneratedKeys ? conn.prepareStatement(replaceSql, 1) : conn.prepareStatement(replaceSql);
                        }
                        ps.setQueryTimeout(jdbcTemplate.getQueryTimeout());
                        if (callback != null) {
                            callback.doInPreparedStatement(ps);
                        }
                        ResultSet rs = null;
                        if (supportsGetGeneratedKeys) {
                            ps.executeUpdate();
                            try {
                                rs = ps.getGeneratedKeys();
                                if (rs.next()) {
                                    key = rs.getLong(1);
                                }
                                Object var9_7 = null;
                            }
                            catch (Throwable throwable) {
                                Object var9_8 = null;
                                JdbcUtils.closeResultSet((ResultSet)rs);
                                throw throwable;
                            }
                            JdbcUtils.closeResultSet((ResultSet)rs);
                            {
                                break block16;
                            }
                        }
                        if (supportsReturningKeys) {
                            try {
                                rs = ps.executeQuery();
                                if (rs.next()) {
                                    key = rs.getLong(1);
                                }
                                Object var11_11 = null;
                            }
                            catch (Throwable throwable) {
                                Object var11_12 = null;
                                JdbcUtils.closeResultSet((ResultSet)rs);
                                throw throwable;
                            }
                            JdbcUtils.closeResultSet((ResultSet)rs);
                            {
                                break block16;
                            }
                        }
                        Statement st = null;
                        ps.executeUpdate();
                        try {
                            st = conn.createStatement();
                            rs = st.executeQuery(AbstractDbDialect.this.getSelectLastInsertIdSql(AbstractDbDialect.this.getSequenceName(sequenceId)));
                            if (rs.next()) {
                                key = rs.getLong(1);
                            }
                            Object var13_14 = null;
                        }
                        catch (Throwable throwable) {
                            Object var13_15 = null;
                            JdbcUtils.closeResultSet((ResultSet)rs);
                            JdbcUtils.closeStatement((Statement)st);
                            throw throwable;
                        }
                        JdbcUtils.closeResultSet((ResultSet)rs);
                        JdbcUtils.closeStatement((Statement)st);
                        {
                        }
                    }
                    Object var15_17 = null;
                }
                catch (Throwable throwable) {
                    Object var15_18 = null;
                    JdbcUtils.closeStatement(ps);
                    throw throwable;
                }
                JdbcUtils.closeStatement((Statement)ps);
                return key;
            }
        });
    }

    @Override
    public Object createSavepoint(JdbcTemplate jdbcTemplate) {
        return jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<Object>(){

            public Object doInConnection(Connection con) throws SQLException, DataAccessException {
                return con.setSavepoint();
            }
        });
    }

    @Override
    public Object createSavepointForFallback(JdbcTemplate jdbcTemplate) {
        if (this.requiresSavepointForFallback()) {
            return this.createSavepoint(jdbcTemplate);
        }
        return null;
    }

    @Override
    public void rollbackToSavepoint(JdbcTemplate jdbcTemplate, final Object savepoint) {
        if (savepoint != null && savepoint instanceof Savepoint) {
            jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<Object>(){

                public Object doInConnection(Connection con) throws SQLException, DataAccessException {
                    con.rollback((Savepoint)savepoint);
                    return null;
                }
            });
        }
    }

    @Override
    public void releaseSavepoint(JdbcTemplate jdbcTemplate, final Object savepoint) {
        if (savepoint != null && savepoint instanceof Savepoint) {
            jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<Object>(){

                public Object doInConnection(Connection con) throws SQLException, DataAccessException {
                    con.releaseSavepoint((Savepoint)savepoint);
                    return null;
                }
            });
        }
    }

    @Override
    public boolean requiresSavepointForFallback() {
        return false;
    }

    @Override
    public void disableSyncTriggers(JdbcTemplate jdbcTemplate) {
        this.disableSyncTriggers(jdbcTemplate, null);
    }

    @Override
    public boolean supportsTransactionId() {
        return false;
    }

    @Override
    public boolean isBlobSyncSupported() {
        return true;
    }

    @Override
    public boolean isClobSyncSupported() {
        return true;
    }

    @Override
    public boolean isTransactionIdOverrideSupported() {
        return true;
    }

    public void setSqlTemplate(SqlTemplate sqlTemplate) {
        this.sqlTemplate = sqlTemplate;
    }

    public void setTablePrefix(String tablePrefix) {
        this.tablePrefix = tablePrefix;
    }

    @Override
    public int getStreamingResultsFetchSize() {
        return this.streamingResultsFetchSize;
    }

    public void setStreamingResultsFetchSize(int streamingResultsFetchSize) {
        this.streamingResultsFetchSize = streamingResultsFetchSize;
    }

    @Override
    public String getEngineName() {
        return this.parameterService.getString("engine.name");
    }

    @Override
    public String getTablePrefix() {
        return this.tablePrefix;
    }

    public void setParameterService(IParameterService parameterService) {
        this.parameterService = parameterService;
        this.log = LogFactory.getLog(parameterService);
    }

    @Override
    public String getIdentifierQuoteString() {
        return this.identifierQuoteString;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() {
        return true;
    }

    @Override
    public String getInitialLoadTableAlias() {
        return "t";
    }

    @Override
    public String preProcessTriggerSqlClause(String sqlClause) {
        return sqlClause;
    }

    @Override
    public int getRouterDataPeekAheadCount() {
        return this.parameterService.getInt("routing.peek.ahead.window.after.max.size");
    }

    @Override
    public String getDefaultSchema() {
        return StringUtils.isBlank((String)this.defaultSchema) ? null : this.defaultSchema;
    }

    public void setDefaultSchema(String currentSchema) {
        this.defaultSchema = currentSchema;
    }

    @Override
    public void truncateTable(String tableName) {
        String quote = this.platform.isDelimitedIdentifierModeOn() ? this.platform.getPlatformInfo().getDelimiterToken() : "";
        boolean success = false;
        int tryCount = 5;
        while (!success && tryCount > 0) {
            try {
                this.jdbcTemplate.update("truncate table " + quote + tableName + quote);
                success = true;
            }
            catch (DataAccessException ex) {
                this.log.warn(ex);
                AppUtils.sleep(5000L);
                --tryCount;
            }
        }
    }

    @Override
    public LobHandler getLobHandler() {
        return this.lobHandler;
    }

    public void setLobHandler(LobHandler lobHandler) {
        this.lobHandler = lobHandler;
    }

    @Override
    public boolean areDatabaseTransactionsPendingSince(long time) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getDatabaseTime() {
        try {
            String sql = "select current_timestamp from " + this.tablePrefix + "_node_identity";
            sql = AppUtils.replaceTokens(sql, this.getSqlScriptReplacementTokens(), false);
            return ((Date)this.jdbcTemplate.queryForObject(sql, Date.class)).getTime();
        }
        catch (Exception ex) {
            this.log.error(ex);
            return System.currentTimeMillis();
        }
    }

    @Override
    public String getSourceNodeExpression() {
        return null;
    }

    @Override
    public final String getDataHasChangedCondition(Trigger trigger) {
        if (this.parameterService.is("trigger.update.capture.changed.data.only.enabled")) {
            return this.getDbSpecificDataHasChangedCondition(trigger);
        }
        return "1=1";
    }

    protected String getDbSpecificDataHasChangedCondition(Trigger trigger) {
        return "1=1";
    }

    @Override
    public Map<String, String> getSqlScriptReplacementTokens() {
        return null;
    }

    @Override
    public boolean needsToSelectLobData() {
        return false;
    }

    @Override
    public boolean isClob(int type) {
        return type == 2005 || type == -1;
    }

    @Override
    public boolean isBlob(int type) {
        return type == 2004 || type == -2 || type == -3 || type == -4 || type == -10;
    }

    @Override
    public boolean isLob(int type) {
        return type == 2005 || type == 2004 || type == -2 || type == -3 || type == -4 || type == -16 || type == -10;
    }

    @Override
    public boolean canGapsOccurInCapturedDataIds() {
        return true;
    }

    @Override
    public String massageDataExtractionSql(String sql, Channel channel) {
        return sql;
    }

    @Override
    public String getDriverName() {
        return this.driverName;
    }

    @Override
    public String getDriverVersion() {
        return this.driverVersion;
    }

    @Override
    public String scrubSql(String sql) {
        Map<String, String> replacementTokens = this.getSqlScriptReplacementTokens();
        if (replacementTokens != null) {
            return AppUtils.replaceTokens(sql, replacementTokens, false).trim();
        }
        return sql;
    }

    @Override
    public StringBuilder scrubSql(StringBuilder sql) {
        Map<String, String> replacementTokens = this.getSqlScriptReplacementTokens();
        if (replacementTokens != null) {
            return new StringBuilder(this.scrubSql(sql.toString()));
        }
        return sql;
    }

    @Override
    public String massageForLob(String sql, Channel channel) {
        return sql;
    }

    @Override
    public boolean escapesTemplatesForDatabaseInserts() {
        return false;
    }

    @Override
    public String getMasterCollation() {
        return this.parameterService.getString("db.master.collation", "");
    }

    @Override
    public boolean supportsBatchUpdates() {
        return true;
    }

    @Override
    public void cleanupTriggers() {
    }

    @Override
    public void addDatabaseUpgradeListener(IDatabaseUpgradeListener listener) {
        this.databaseUpgradeListeners.add(listener);
    }

    protected void initLobHandler() {
    }

    @Override
    public StatementBuilder createStatementBuilder(StatementBuilder.DmlType type, String tableName, Column[] keys, Column[] columns, Column[] preFilteredColumns) {
        return new StatementBuilder(type, tableName, keys, columns, preFilteredColumns, this.isDateOverrideToTimestamp(), this.getIdentifierQuoteString());
    }

    public void setPrimaryKeyViolationCodes(int[] primaryKeyViolationCodes) {
        this.primaryKeyViolationCodes = primaryKeyViolationCodes;
    }

    public void setPrimaryKeyViolationSqlStates(String[] primaryKeyViolationSqlStates) {
        this.primaryKeyViolationSqlStates = primaryKeyViolationSqlStates;
    }

    @Override
    public boolean isPrimaryKeyViolation(Exception ex) {
        SQLException sqlEx;
        boolean primaryKeyViolation = false;
        if ((this.primaryKeyViolationCodes != null || this.primaryKeyViolationSqlStates != null) && (sqlEx = this.findSQLException(ex)) != null) {
            String sqlState;
            if (this.primaryKeyViolationCodes != null) {
                int errorCode = sqlEx.getErrorCode();
                for (int primaryKeyViolationCode : this.primaryKeyViolationCodes) {
                    if (primaryKeyViolationCode != errorCode) continue;
                    primaryKeyViolation = true;
                    break;
                }
            }
            if (this.primaryKeyViolationSqlStates != null && (sqlState = sqlEx.getSQLState()) != null) {
                for (String primaryKeyViolationSqlState : this.primaryKeyViolationSqlStates) {
                    if (primaryKeyViolationSqlState == null || !primaryKeyViolationSqlState.equals(sqlState)) continue;
                    primaryKeyViolation = true;
                    break;
                }
            }
        }
        return primaryKeyViolation;
    }

    protected SQLException findSQLException(Throwable ex) {
        if (ex instanceof SQLException) {
            return (SQLException)ex;
        }
        Throwable cause = ex.getCause();
        if (cause != null && !cause.equals(ex)) {
            return this.findSQLException(cause);
        }
        return null;
    }

    @Override
    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }
}

