/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.config;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymmetricPropertiesFiles
extends ArrayList<String> {
    private static final long serialVersionUID = 1L;
    private static ILog log = LogFactory.getLog(SymmetricPropertiesFiles.class);

    public SymmetricPropertiesFiles() {
        this((List<String>)new ArrayList<String>(0));
    }

    public SymmetricPropertiesFiles(List<String> resources) {
        this.addAll(resources);
        File file = new File(System.getProperty("user.dir"), "symmetric.properties");
        if (file.exists() && file.isFile()) {
            try {
                this.add(file.toURI().toURL().toExternalForm());
            }
            catch (MalformedURLException e) {
                log.error(e);
            }
        }
        Properties systemProperties = System.getProperties();
        for (Object key : systemProperties.keySet()) {
            if (!key.toString().startsWith("symmetric.override.properties.file.")) continue;
            this.add(System.getProperty(key.toString()));
        }
    }

    public Resource findWriteableOverrideResource(boolean exists) {
        DefaultResourceLoader resourceLoader = new DefaultResourceLoader();
        for (int i = this.size() - 1; i >= 0; --i) {
            String resourcePath = StringUtils.replace((String)((String)this.get(i)), (String)"${user.home}", (String)System.getProperty("user.home"));
            if (!resourcePath.startsWith("file:")) continue;
            Resource resource = resourceLoader.getResource(resourcePath);
            try {
                File file = resource.getFile();
                if (exists && (!exists || !file.exists())) continue;
                return resource;
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        return null;
    }

    public Resource findPreferredWritableResource() {
        Resource resource = this.findWriteableOverrideResource(true);
        if (resource == null) {
            resource = this.findWriteableOverrideResource(false);
        }
        return resource;
    }
}

