/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.common;

public class DeploymentType {
    public static final String CUSTOM = "custom";
    public static final String ENGINE = "engine";
    public static final String WAR = "war";
    public static final String STANDALONE = "standalone";
    public static final String MOBILE = "mobile";
    public static final String PROFESSIONAL = "professional";
    private boolean engineRegistered;
    private boolean servletRegistered;
    private boolean professionalRegistered;
    private boolean mobileRegistered;
    private boolean webServerRegistered = System.getProperty("symmetric.standalone.web", "false").equals("true");

    public DeploymentType() {
        System.getProperties().remove("symmetric.standalone.web");
    }

    public void setEngineRegistered(boolean engineRegistered) {
        this.engineRegistered = engineRegistered;
    }

    public void setMobileRegistered(boolean mobileRegistered) {
        this.mobileRegistered = mobileRegistered;
    }

    public void setProfessionalRegistered(boolean professionalRegistered) {
        this.professionalRegistered = professionalRegistered;
    }

    public void setServletRegistered(boolean servletRegistered) {
        this.servletRegistered = servletRegistered;
    }

    public void setWebServerRegistered(boolean webserverRegistered) {
        this.webServerRegistered = webserverRegistered;
    }

    public String getDeploymentType() {
        if (this.professionalRegistered) {
            return PROFESSIONAL;
        }
        if (this.mobileRegistered) {
            return MOBILE;
        }
        if (this.servletRegistered && this.webServerRegistered) {
            return STANDALONE;
        }
        if (this.servletRegistered && !this.webServerRegistered) {
            return WAR;
        }
        if (this.engineRegistered && !this.servletRegistered) {
            return ENGINE;
        }
        return CUSTOM;
    }
}

