/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.StandaloneSymmetricEngine;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;
import org.jumpmind.symmetric.service.IRegistrationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymmetricEngineHolder {
    final ILog log = LogFactory.getLog(this.getClass());
    private Map<String, ISymmetricEngine> engines = new HashMap<String, ISymmetricEngine>();
    private Set<EngineStarter> enginesStarting = new HashSet<EngineStarter>();
    private boolean multiServerMode = false;

    public Map<String, ISymmetricEngine> getEngines() {
        return this.engines;
    }

    public void setMultiServerMode(boolean multiServerMode) {
        this.multiServerMode = multiServerMode;
    }

    public boolean isMultiServerMode() {
        return this.multiServerMode;
    }

    public boolean areEnginesConfigured() {
        return this.enginesStarting.size() > 0 || this.engines.size() > 0;
    }

    public String getEnginesDir() {
        String enginesDir = System.getProperty("symmetric.engines.dir", "../engines");
        new File(enginesDir).mkdirs();
        return enginesDir;
    }

    public synchronized void stop() {
        Set<String> engineNames = this.engines.keySet();
        for (String engineName : engineNames) {
            this.engines.get(engineName).destroy();
        }
        this.engines.clear();
    }

    public void start() {
        if (this.isMultiServerMode()) {
            File enginesDir = new File(this.getEnginesDir());
            File[] files = enginesDir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (!file.getName().endsWith(".properties")) continue;
                this.enginesStarting.add(new EngineStarter(file.getAbsolutePath()));
            }
            for (EngineStarter starter : this.enginesStarting) {
                starter.start();
            }
        } else {
            ISymmetricEngine engine = this.create(null);
            engine.start();
        }
    }

    protected ISymmetricEngine create(String propertiesFile) {
        StandaloneSymmetricEngine engine = null;
        try {
            String filePrefix = "file:///";
            if (StringUtils.isNotBlank((String)propertiesFile) && !propertiesFile.startsWith("file:///")) {
                propertiesFile = "file:///" + propertiesFile;
            }
            if ((engine = new StandaloneSymmetricEngine(null, propertiesFile)) != null) {
                if (!this.engines.containsKey(engine.getEngineName())) {
                    this.engines.put(engine.getEngineName(), engine);
                } else {
                    this.log.error("SymmetricEngineDuplicateName", engine.getEngineName());
                }
            }
            return engine;
        }
        catch (Exception e) {
            this.log.error(e);
            return null;
        }
    }

    public ISymmetricEngine install(Properties properties) throws Exception {
        String engineName = this.validateRequiredProperties(properties);
        if (this.engines.get(engineName) != null) {
            try {
                this.engines.get(engineName).stop();
            }
            catch (Exception e) {
                this.log.error(e);
            }
            this.engines.remove(engineName);
        }
        File enginesDir = new File(this.getEnginesDir());
        File symmetricProperties = new File(enginesDir, engineName + ".properties");
        FileOutputStream fileOs = null;
        try {
            try {
                fileOs = new FileOutputStream(symmetricProperties);
                properties.store(fileOs, "Updated by SymmetricDS Pro");
            }
            catch (IOException ex) {
                throw new RuntimeException("Failed to write symmetric.properties to engine directory", ex);
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            IOUtils.closeQuietly((OutputStream)fileOs);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)fileOs);
        String registrationUrl = properties.getProperty("registration.url");
        if (StringUtils.isNotBlank((String)registrationUrl)) {
            Collection<ISymmetricEngine> servers = this.getEngines().values();
            for (ISymmetricEngine symmetricWebServer : servers) {
                if (!symmetricWebServer.getParameterService().getSyncUrl().equals(registrationUrl)) continue;
                String nodeGroupId = properties.getProperty("group.id");
                String externalId = properties.getProperty("external.id");
                IRegistrationService registrationService = symmetricWebServer.getRegistrationService();
                if (registrationService.isAutoRegistration() || registrationService.isRegistrationOpen(nodeGroupId, externalId)) continue;
                registrationService.openRegistration(nodeGroupId, externalId);
            }
        }
        ISymmetricEngine engine = this.create(symmetricProperties.getAbsolutePath());
        engine.start();
        return engine;
    }

    public boolean areEnginesStarting() {
        return this.enginesStarting.size() > 0;
    }

    public String getEngineName(Properties properties) {
        String engineName = properties.getProperty("engine.name");
        if (StringUtils.isBlank((String)engineName)) {
            String groupId;
            String externalId = properties.getProperty("external.id", "");
            engineName = externalId.equals(groupId = properties.getProperty("group.id", "")) ? groupId : groupId + "-" + externalId;
            engineName = properties.getProperty("engine.name", engineName);
            String engineExt = "";
            int engineNumber = 0;
            while (new File(this.getEnginesDir(), engineName + engineExt + ".properties").exists()) {
                engineExt = "-" + ++engineNumber;
            }
            engineName = engineName + engineExt;
        }
        return engineName;
    }

    public String validateRequiredProperties(Properties properties) {
        String externalId = properties.getProperty("external.id");
        if (StringUtils.isBlank((String)externalId)) {
            throw new IllegalStateException("Missing property external.id");
        }
        String groupId = properties.getProperty("group.id");
        if (StringUtils.isBlank((String)groupId)) {
            throw new IllegalStateException("Missing property group.id");
        }
        String engineName = this.getEngineName(properties);
        properties.setProperty("engine.name", engineName);
        if (StringUtils.isBlank((String)properties.getProperty("sync.url"))) {
            throw new IllegalStateException("Missing property sync.url");
        }
        if (StringUtils.isBlank((String)properties.getProperty("db.driver"))) {
            throw new IllegalStateException("Missing property db.driver");
        }
        if (StringUtils.isBlank((String)properties.getProperty("db.url"))) {
            throw new IllegalStateException("Missing property db.url");
        }
        if (!properties.containsKey("db.user")) {
            throw new IllegalStateException("Missing property db.user");
        }
        if (!properties.containsKey("db.password")) {
            throw new IllegalStateException("Missing property db.password");
        }
        if (!properties.containsKey("registration.url")) {
            properties.setProperty("registration.url", "");
        }
        return engineName;
    }

    class EngineStarter
    extends Thread {
        String propertiesFile;

        public EngineStarter(String propertiesFile) {
            super("symmetric-startup (" + propertiesFile + ")");
            this.propertiesFile = propertiesFile;
        }

        public void run() {
            ISymmetricEngine engine;
            if (this.propertiesFile != null && (engine = SymmetricEngineHolder.this.create(this.propertiesFile)) != null) {
                engine.start();
            }
            SymmetricEngineHolder.this.enginesStarting.remove(this);
        }
    }
}

