/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.ddl.platform.postgresql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.jumpmind.symmetric.ddl.Platform;
import org.jumpmind.symmetric.ddl.model.Column;
import org.jumpmind.symmetric.ddl.model.ForeignKey;
import org.jumpmind.symmetric.ddl.model.Index;
import org.jumpmind.symmetric.ddl.model.Table;
import org.jumpmind.symmetric.ddl.model.TypeMap;
import org.jumpmind.symmetric.ddl.platform.DatabaseMetaDataWrapper;
import org.jumpmind.symmetric.ddl.platform.JdbcModelReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostgreSqlModelReader
extends JdbcModelReader {
    public PostgreSqlModelReader(Platform platform) {
        super(platform);
        this.setDefaultCatalogPattern(null);
        this.setDefaultSchemaPattern(null);
        this.setDefaultTablePattern(null);
    }

    @Override
    protected Table readTable(Connection connection, DatabaseMetaDataWrapper metaData, Map<String, Object> values) throws SQLException {
        Table table = super.readTable(connection, metaData, values);
        if (table != null) {
            HashMap<String, Index> uniquesByName = new HashMap<String, Index>();
            for (int indexIdx = 0; indexIdx < table.getIndexCount(); ++indexIdx) {
                Index index = table.getIndex(indexIdx);
                if (!index.isUnique() || index.getName() == null) continue;
                uniquesByName.put(index.getName(), index);
            }
            for (int columnIdx = 0; columnIdx < table.getColumnCount(); ++columnIdx) {
                String indexName;
                Column column = table.getColumn(columnIdx);
                if (!column.isAutoIncrement() || column.isPrimaryKey() || !uniquesByName.containsKey(indexName = table.getName() + "_" + column.getName() + "_key")) continue;
                table.removeIndex((Index)uniquesByName.get(indexName));
                uniquesByName.remove(indexName);
            }
        }
        return table;
    }

    @Override
    protected Integer overrideJdbcTypeForColumn(Map<String, Object> values) {
        String typeName = (String)values.get("TYPE_NAME");
        if (typeName != null && typeName.equalsIgnoreCase("ABSTIME")) {
            return 93;
        }
        if (typeName != null && typeName.equalsIgnoreCase("OID")) {
            return 2004;
        }
        return super.overrideJdbcTypeForColumn(values);
    }

    protected Column readColumn(DatabaseMetaDataWrapper metaData, Map values) throws SQLException {
        String defaultValue;
        Column column = super.readColumn(metaData, values);
        if (column.getSize() != null) {
            if (column.getSizeAsInt() <= 0) {
                column.setSize(null);
                if (column.getTypeCode() == -2) {
                    column.setTypeCode(-4);
                } else if (column.getTypeCode() == 12) {
                    column.setTypeCode(-1);
                }
            } else if (column.getSizeAsInt() == Integer.MAX_VALUE) {
                column.setSize(null);
                if (column.getTypeCode() == 12) {
                    column.setTypeCode(-1);
                } else if (column.getTypeCode() == -2) {
                    column.setTypeCode(-4);
                }
            }
        }
        if ((defaultValue = column.getDefaultValue()) != null && defaultValue.length() > 0) {
            if (defaultValue.startsWith("nextval(")) {
                column.setAutoIncrement(true);
                defaultValue = null;
            } else {
                switch (column.getTypeCode()) {
                    case -5: 
                    case 2: 
                    case 3: 
                    case 4: {
                        defaultValue = this.extractUndelimitedDefaultValue(defaultValue);
                        break;
                    }
                    case -1: 
                    case 1: 
                    case 12: 
                    case 91: 
                    case 92: 
                    case 93: {
                        defaultValue = this.extractDelimitedDefaultValue(defaultValue);
                    }
                }
                if (TypeMap.isTextType(column.getTypeCode())) {
                    defaultValue = this.unescape(defaultValue, "'", "''");
                }
            }
            column.setDefaultValue(defaultValue);
        }
        return column;
    }

    private String extractDelimitedDefaultValue(String defaultValue) {
        int valueEnd;
        if (defaultValue.startsWith("'") && (valueEnd = defaultValue.indexOf("'::")) > 0) {
            return defaultValue.substring("'".length(), valueEnd);
        }
        return defaultValue;
    }

    private String extractUndelimitedDefaultValue(String defaultValue) {
        int valueEnd = defaultValue.indexOf("::");
        if (valueEnd > 0) {
            defaultValue = defaultValue.substring(0, valueEnd);
        } else if (defaultValue.startsWith("(") && defaultValue.endsWith(")")) {
            defaultValue = defaultValue.substring(1, defaultValue.length() - 1);
        }
        return defaultValue;
    }

    @Override
    protected boolean isInternalForeignKeyIndex(Connection connection, DatabaseMetaDataWrapper metaData, Table table, ForeignKey fk, Index index) {
        return false;
    }

    @Override
    protected boolean isInternalPrimaryKeyIndex(Connection connection, DatabaseMetaDataWrapper metaData, Table table, Index index) {
        return table.doesIndexContainOnlyPrimaryKeyColumns(index);
    }
}

