/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.ddl.platform.oracle;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.jumpmind.symmetric.ddl.DdlUtilsException;
import org.jumpmind.symmetric.ddl.Platform;
import org.jumpmind.symmetric.ddl.model.Column;
import org.jumpmind.symmetric.ddl.model.Index;
import org.jumpmind.symmetric.ddl.model.Table;
import org.jumpmind.symmetric.ddl.model.TypeMap;
import org.jumpmind.symmetric.ddl.platform.DatabaseMetaDataWrapper;
import org.jumpmind.symmetric.ddl.platform.JdbcModelReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleModelReader
extends JdbcModelReader {
    private final Log _log = LogFactory.getLog(OracleModelReader.class);
    private Pattern _oracleIsoDatePattern;
    private Pattern _oracleIsoTimePattern;
    private Pattern _oracleIsoTimestampPattern;

    public OracleModelReader(Platform platform) {
        super(platform);
        this.setDefaultCatalogPattern(null);
        this.setDefaultSchemaPattern(null);
        this.setDefaultTablePattern("%");
        Perl5Compiler compiler = new Perl5Compiler();
        try {
            this._oracleIsoDatePattern = compiler.compile("TO_DATE\\('([^']*)'\\, 'YYYY\\-MM\\-DD'\\)");
            this._oracleIsoTimePattern = compiler.compile("TO_DATE\\('([^']*)'\\, 'HH24:MI:SS'\\)");
            this._oracleIsoTimestampPattern = compiler.compile("TO_DATE\\('([^']*)'\\, 'YYYY\\-MM\\-DD HH24:MI:SS'\\)");
        }
        catch (MalformedPatternException ex) {
            throw new DdlUtilsException(ex);
        }
    }

    protected Table readTable(Connection connection, DatabaseMetaDataWrapper metaData, Map values) throws SQLException {
        boolean tableHasBeenDeleted = this.isTableInRecycleBin(connection, values);
        if (!tableHasBeenDeleted) {
            String tableName = (String)values.get("TABLE_NAME");
            if (tableName.indexOf(36) > 0) {
                return null;
            }
            Table table = super.readTable(connection, metaData, values);
            if (table != null) {
                this.determineAutoIncrementColumns(connection, table);
            }
            return table;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isTableInRecycleBin(Connection connection, Map values) throws SQLException {
        boolean bl;
        ResultSet rs = null;
        PreparedStatement stmt = null;
        try {
            stmt = connection.prepareStatement("SELECT * FROM RECYCLEBIN WHERE OBJECT_NAME=?");
            stmt.setString(1, (String)values.get("TABLE_NAME"));
            rs = stmt.executeQuery();
            bl = rs.next();
        }
        catch (Throwable throwable) {
            this.close(rs);
            this.close(stmt);
            throw throwable;
        }
        this.close(rs);
        this.close(stmt);
        return bl;
    }

    @Override
    protected Integer overrideJdbcTypeForColumn(Map<String, Object> values) {
        String typeName = (String)values.get("TYPE_NAME");
        if (typeName != null && typeName.startsWith("DATE")) {
            return 91;
        }
        if (typeName != null && typeName.startsWith("TIMESTAMP")) {
            return 93;
        }
        if (typeName != null && typeName.startsWith("NVARCHAR")) {
            return 12;
        }
        if (typeName != null && typeName.startsWith("LONGNVARCHAR")) {
            return -1;
        }
        if (typeName != null && typeName.startsWith("NCHAR")) {
            return 1;
        }
        if (typeName != null && typeName.startsWith("NCLOB")) {
            return 2005;
        }
        if (typeName != null && typeName.startsWith("BINARY_FLOAT")) {
            return 6;
        }
        if (typeName != null && typeName.startsWith("BINARY_DOUBLE")) {
            return 8;
        }
        return super.overrideJdbcTypeForColumn(values);
    }

    protected Column readColumn(DatabaseMetaDataWrapper metaData, Map values) throws SQLException {
        Column column = super.readColumn(metaData, values);
        if (column.getTypeCode() == 3) {
            switch (column.getSizeAsInt()) {
                case 1: {
                    if (column.getScale() != 0) break;
                    column.setTypeCode(-7);
                    break;
                }
                case 3: {
                    if (column.getScale() != 0) break;
                    column.setTypeCode(-6);
                    break;
                }
                case 5: {
                    if (column.getScale() != 0) break;
                    column.setTypeCode(5);
                    break;
                }
                case 18: {
                    column.setTypeCode(7);
                    break;
                }
                case 22: {
                    if (column.getScale() != 0) break;
                    column.setTypeCode(4);
                    break;
                }
                case 38: {
                    if (column.getScale() == 0) {
                        column.setTypeCode(-5);
                        break;
                    }
                    column.setTypeCode(8);
                }
            }
        } else if (column.getTypeCode() == 6) {
            switch (column.getSizeAsInt()) {
                case 63: {
                    column.setTypeCode(7);
                    break;
                }
                case 126: {
                    column.setTypeCode(8);
                }
            }
        } else if (column.getTypeCode() == 91 || column.getTypeCode() == 93) {
            if (column.getDefaultValue() != null) {
                Perl5Matcher matcher = new Perl5Matcher();
                Timestamp timestamp = null;
                if (matcher.matches(column.getDefaultValue(), this._oracleIsoTimestampPattern)) {
                    String timestampVal = matcher.getMatch().group(1);
                    timestamp = Timestamp.valueOf(timestampVal);
                } else if (matcher.matches(column.getDefaultValue(), this._oracleIsoDatePattern)) {
                    String dateVal = matcher.getMatch().group(1);
                    timestamp = new Timestamp(Date.valueOf(dateVal).getTime());
                } else if (matcher.matches(column.getDefaultValue(), this._oracleIsoTimePattern)) {
                    String timeVal = matcher.getMatch().group(1);
                    timestamp = new Timestamp(Time.valueOf(timeVal).getTime());
                }
                if (timestamp != null) {
                    column.setDefaultValue(timestamp.toString());
                }
            }
        } else if (TypeMap.isTextType(column.getTypeCode())) {
            column.setDefaultValue(this.unescape(column.getDefaultValue(), "'", "''"));
        }
        return column;
    }

    protected void determineAutoIncrementColumns(Connection connection, Table table) throws SQLException {
        Column[] columns = table.getColumns();
        for (int idx = 0; idx < columns.length; ++idx) {
            columns[idx].setAutoIncrement(this.isAutoIncrement(connection, table, columns[idx]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isAutoIncrement(Connection connection, Table table, Column column) throws SQLException {
        PreparedStatement prepStmt = null;
        String triggerName = this.getPlatform().getSqlBuilder().getConstraintName("trg", table, column.getName(), null);
        String seqName = this.getPlatform().getSqlBuilder().getConstraintName("seq", table, column.getName(), null);
        if (!this.getPlatform().isDelimitedIdentifierModeOn()) {
            triggerName = triggerName.toUpperCase();
            seqName = seqName.toUpperCase();
        }
        try {
            prepStmt = connection.prepareStatement("SELECT * FROM user_triggers WHERE trigger_name = ?");
            prepStmt.setString(1, triggerName);
            ResultSet resultSet = prepStmt.executeQuery();
            if (!resultSet.next()) {
                boolean bl = false;
                return bl;
            }
            prepStmt.close();
            prepStmt = connection.prepareStatement("SELECT * FROM user_sequences WHERE sequence_name = ?");
            prepStmt.setString(1, seqName);
            resultSet = prepStmt.executeQuery();
            boolean bl = resultSet.next();
            return bl;
        }
        finally {
            if (prepStmt != null) {
                prepStmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection readIndices(Connection connection, DatabaseMetaDataWrapper metaData, String tableName) throws SQLException {
        StringBuffer query = new StringBuffer();
        query.append("SELECT a.INDEX_NAME, a.INDEX_TYPE, a.UNIQUENESS, b.COLUMN_NAME, b.COLUMN_POSITION FROM USER_INDEXES a, USER_IND_COLUMNS b WHERE ");
        query.append("a.TABLE_NAME=? AND a.GENERATED=? AND a.TABLE_TYPE=? AND a.TABLE_NAME=b.TABLE_NAME AND a.INDEX_NAME=b.INDEX_NAME AND ");
        query.append("a.INDEX_NAME NOT IN (SELECT DISTINCT c.CONSTRAINT_NAME FROM USER_CONSTRAINTS c WHERE c.CONSTRAINT_TYPE=? AND c.TABLE_NAME=a.TABLE_NAME");
        if (metaData.getSchemaPattern() != null) {
            query.append(" AND c.OWNER LIKE ?) AND a.TABLE_OWNER LIKE ?");
        } else {
            query.append(")");
        }
        ListOrderedMap indices = new ListOrderedMap();
        PreparedStatement stmt = null;
        try {
            stmt = connection.prepareStatement(query.toString());
            stmt.setString(1, this.getPlatform().isDelimitedIdentifierModeOn() ? tableName : tableName.toUpperCase());
            stmt.setString(2, "N");
            stmt.setString(3, "TABLE");
            stmt.setString(4, "P");
            if (metaData.getSchemaPattern() != null) {
                stmt.setString(5, metaData.getSchemaPattern().toUpperCase());
                stmt.setString(6, metaData.getSchemaPattern().toUpperCase());
            }
            ResultSet rs = stmt.executeQuery();
            HashMap<String, Object> values = new HashMap<String, Object>();
            while (rs.next()) {
                String name = rs.getString(1);
                String type = rs.getString(2);
                if (type.startsWith("NORMAL")) {
                    values.put("INDEX_TYPE", new Short(3));
                    values.put("INDEX_NAME", name);
                    values.put("NON_UNIQUE", "UNIQUE".equalsIgnoreCase(rs.getString(3)) ? Boolean.FALSE : Boolean.TRUE);
                    values.put("COLUMN_NAME", rs.getString(4));
                    values.put("ORDINAL_POSITION", new Short(rs.getShort(5)));
                    this.readIndex(metaData, values, (Map<String, Index>)indices);
                    continue;
                }
                this._log.warn((Object)("Skipping index " + name + " of type " + type));
            }
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
        return indices.values();
    }
}

