/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.ddl.platform.h2;

import org.jumpmind.symmetric.ddl.Platform;
import org.jumpmind.symmetric.ddl.PlatformInfo;
import org.jumpmind.symmetric.ddl.platform.PlatformImplBase;
import org.jumpmind.symmetric.ddl.platform.h2.H2Builder;
import org.jumpmind.symmetric.ddl.platform.h2.H2ModelReader;

public class H2Platform
extends PlatformImplBase
implements Platform {
    public static final String[] DATABASENAMES = new String[]{"H2", "H21"};
    public static final String JDBC_DRIVER = "org.h2.Driver";
    public static final String JDBC_SUBPROTOCOL = "h2";

    public H2Platform() {
        PlatformInfo info = this.getPlatformInfo();
        info.setNonPKIdentityColumnsSupported(false);
        info.setIdentityOverrideAllowed(false);
        info.setSystemForeignKeyIndicesAlwaysNonUnique(true);
        info.setNullAsDefaultValueRequired(false);
        info.addNativeTypeMapping(2003, "BINARY", -2);
        info.addNativeTypeMapping(2001, "BINARY", -2);
        info.addNativeTypeMapping(0, "BINARY", -2);
        info.addNativeTypeMapping(2006, "BINARY", -2);
        info.addNativeTypeMapping(2002, "BINARY", -2);
        info.addNativeTypeMapping(70, "BINARY", -2);
        info.addNativeTypeMapping(-7, "BOOLEAN", -7);
        info.addNativeTypeMapping(2, "DECIMAL", 3);
        info.addNativeTypeMapping(-2, "BINARY", -2);
        info.addNativeTypeMapping(2004, "BLOB", 2004);
        info.addNativeTypeMapping(2005, "CLOB", 2005);
        info.addNativeTypeMapping(-1, "VARCHAR", 12);
        info.addNativeTypeMapping(6, "DOUBLE", 8);
        info.addNativeTypeMapping(2000, "OTHER");
        info.setDefaultSize(1, Integer.MAX_VALUE);
        info.setDefaultSize(12, Integer.MAX_VALUE);
        info.setDefaultSize(-2, Integer.MAX_VALUE);
        info.setDefaultSize(-3, Integer.MAX_VALUE);
        info.setStoresUpperCaseInCatalog(true);
        this.setSqlBuilder(new H2Builder(this));
        this.setModelReader(new H2ModelReader(this));
    }

    public String getName() {
        return DATABASENAMES[0];
    }
}

