/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.ddl.platform.h2;

import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.jumpmind.symmetric.ddl.Platform;
import org.jumpmind.symmetric.ddl.alteration.AddColumnChange;
import org.jumpmind.symmetric.ddl.alteration.RemoveColumnChange;
import org.jumpmind.symmetric.ddl.model.Column;
import org.jumpmind.symmetric.ddl.model.Database;
import org.jumpmind.symmetric.ddl.model.Index;
import org.jumpmind.symmetric.ddl.model.ModelException;
import org.jumpmind.symmetric.ddl.model.Table;
import org.jumpmind.symmetric.ddl.model.TypeMap;
import org.jumpmind.symmetric.ddl.platform.SqlBuilder;

public class H2Builder
extends SqlBuilder {
    public H2Builder(Platform platform) {
        super(platform);
        this.addEscapedCharSequence("'", "''");
    }

    protected void processChange(Database currentModel, Database desiredModel, AddColumnChange change) throws IOException {
        this.print("ALTER TABLE ");
        this.printlnIdentifier(this.getTableName(change.getChangedTable()));
        this.printIndent();
        this.print("ADD COLUMN ");
        this.writeColumn(change.getChangedTable(), change.getNewColumn());
        if (change.getNextColumn() != null) {
            this.print(" BEFORE ");
            this.printIdentifier(this.getColumnName(change.getNextColumn()));
        }
        this.printEndOfStatement();
        change.apply(currentModel, this.getPlatform().isDelimitedIdentifierModeOn());
    }

    protected void processChange(Database currentModel, Database desiredModel, RemoveColumnChange change) throws IOException {
        this.print("ALTER TABLE ");
        this.printlnIdentifier(this.getTableName(change.getChangedTable()));
        this.printIndent();
        this.print("DROP COLUMN ");
        this.printIdentifier(this.getColumnName(change.getColumn()));
        this.printEndOfStatement();
        change.apply(currentModel, this.getPlatform().isDelimitedIdentifierModeOn());
    }

    protected void writeColumnDefaultValueStmt(Table table, Column column) throws IOException {
        Object parsedDefault = column.getParsedDefaultValue();
        if (parsedDefault != null) {
            if (!(this.getPlatformInfo().isDefaultValuesForLongTypesSupported() || column.getTypeCode() != -4 && column.getTypeCode() != -1)) {
                throw new ModelException("The platform does not support default values for LONGVARCHAR or LONGVARBINARY columns");
            }
            if (this.isValidDefaultValue(column.getDefaultValue(), column.getTypeCode())) {
                this.print(" DEFAULT ");
                this.writeColumnDefaultValue(table, column);
            }
        } else if (this.getPlatformInfo().isDefaultValueUsedForIdentitySpec() && column.isAutoIncrement()) {
            this.print(" DEFAULT ");
            this.writeColumnDefaultValue(table, column);
        } else if (!StringUtils.isBlank((String)column.getDefaultValue())) {
            this.print(" DEFAULT ");
            this.writeColumnDefaultValue(table, column);
        }
    }

    protected void printDefaultValue(Object defaultValue, int typeCode) throws IOException {
        if (defaultValue != null) {
            boolean shouldUseQuotes;
            String defaultValueStr = defaultValue.toString();
            boolean bl = shouldUseQuotes = !TypeMap.isNumericType(typeCode) && !defaultValueStr.startsWith("TO_DATE(") && !defaultValue.equals("CURRENT_TIMESTAMP") && !defaultValue.equals("CURRENT_TIME") && !defaultValue.equals("CURRENT_DATE");
            if (shouldUseQuotes) {
                this.print(this.getPlatformInfo().getValueQuoteToken());
                this.print(this.escapeStringValue(defaultValueStr));
                this.print(this.getPlatformInfo().getValueQuoteToken());
            } else {
                this.print(defaultValueStr);
            }
        }
    }

    public void writeExternalIndexDropStmt(Table table, Index index) throws IOException {
        this.print("DROP INDEX IF EXISTS ");
        this.printIdentifier(this.getIndexName(index));
        this.printEndOfStatement();
    }
}

