/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.ddl.platform;

import java.io.IOException;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jumpmind.symmetric.ddl.DatabaseOperationException;
import org.jumpmind.symmetric.ddl.DdlUtilsException;
import org.jumpmind.symmetric.ddl.Platform;
import org.jumpmind.symmetric.ddl.PlatformInfo;
import org.jumpmind.symmetric.ddl.model.Column;
import org.jumpmind.symmetric.ddl.model.Database;
import org.jumpmind.symmetric.ddl.model.Table;
import org.jumpmind.symmetric.ddl.model.TypeMap;
import org.jumpmind.symmetric.ddl.platform.CreationParameters;
import org.jumpmind.symmetric.ddl.platform.JdbcModelReader;
import org.jumpmind.symmetric.ddl.platform.SqlBuilder;
import org.jumpmind.symmetric.ddl.util.Jdbc3Utils;
import org.jumpmind.symmetric.ddl.util.JdbcSupport;
import org.jumpmind.symmetric.ddl.util.SqlTokenizer;

public abstract class PlatformImplBase
extends JdbcSupport
implements Platform {
    protected static final String MODEL_DEFAULT_NAME = "default";
    private final Log _log = LogFactory.getLog(this.getClass());
    private PlatformInfo _info = new PlatformInfo();
    private SqlBuilder _builder;
    private JdbcModelReader _modelReader;
    private boolean _scriptModeOn;
    private boolean _sqlCommentsOn = false;
    private boolean _delimitedIdentifierModeOn;
    private boolean _identityOverrideOn;
    private boolean _foreignKeysSorted;

    public SqlBuilder getSqlBuilder() {
        return this._builder;
    }

    protected void setSqlBuilder(SqlBuilder builder) {
        this._builder = builder;
    }

    public JdbcModelReader getModelReader() {
        if (this._modelReader == null) {
            this._modelReader = new JdbcModelReader(this);
        }
        return this._modelReader;
    }

    protected void setModelReader(JdbcModelReader modelReader) {
        this._modelReader = modelReader;
    }

    public PlatformInfo getPlatformInfo() {
        return this._info;
    }

    public boolean isScriptModeOn() {
        return this._scriptModeOn;
    }

    public void setScriptModeOn(boolean scriptModeOn) {
        this._scriptModeOn = scriptModeOn;
    }

    public boolean isSqlCommentsOn() {
        return this._sqlCommentsOn;
    }

    public void setSqlCommentsOn(boolean sqlCommentsOn) {
        if (!this.getPlatformInfo().isSqlCommentsSupported() && sqlCommentsOn) {
            throw new DdlUtilsException("Platform " + this.getName() + " does not support SQL comments");
        }
        this._sqlCommentsOn = sqlCommentsOn;
    }

    public boolean isDelimitedIdentifierModeOn() {
        return this._delimitedIdentifierModeOn;
    }

    public void setDelimitedIdentifierModeOn(boolean delimitedIdentifierModeOn) {
        if (!this.getPlatformInfo().isDelimitedIdentifiersSupported() && delimitedIdentifierModeOn) {
            throw new DdlUtilsException("Platform " + this.getName() + " does not support delimited identifier");
        }
        this._delimitedIdentifierModeOn = delimitedIdentifierModeOn;
    }

    public boolean isIdentityOverrideOn() {
        return this._identityOverrideOn;
    }

    public void setIdentityOverrideOn(boolean identityOverrideOn) {
        this._identityOverrideOn = identityOverrideOn;
    }

    public boolean isForeignKeysSorted() {
        return this._foreignKeysSorted;
    }

    public void setForeignKeysSorted(boolean foreignKeysSorted) {
        this._foreignKeysSorted = foreignKeysSorted;
    }

    protected Log getLog() {
        return this._log;
    }

    protected void logWarnings(Connection connection) throws SQLException {
        for (SQLWarning warning = connection.getWarnings(); warning != null; warning = warning.getNextWarning()) {
            this.getLog().warn((Object)warning.getLocalizedMessage(), warning.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int evaluateBatch(String sql, boolean continueOnError) throws DatabaseOperationException {
        Connection connection = this.borrowConnection();
        try {
            int n = this.evaluateBatch(connection, sql, continueOnError);
            return n;
        }
        finally {
            this.returnConnection(connection);
        }
    }

    public int evaluateBatch(Connection connection, String sql, boolean continueOnError) throws DatabaseOperationException {
        Statement statement = null;
        int errors = 0;
        int commandCount = 0;
        try {
            statement = connection.createStatement();
            SqlTokenizer tokenizer = new SqlTokenizer(sql);
            while (tokenizer.hasMoreStatements()) {
                String command = tokenizer.getNextStatement();
                if ((command = command.trim()).length() == 0) continue;
                ++commandCount;
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)("Executing SQL: " + command));
                }
                try {
                    int results = statement.executeUpdate(command);
                    if (this._log.isDebugEnabled()) {
                        this._log.debug((Object)("After execution, " + results + " row(s) have been changed"));
                    }
                }
                catch (SQLException ex) {
                    if (continueOnError) {
                        this._log.warn((Object)("SQL Command " + command + " failed with: " + ex.getMessage()));
                        if (this._log.isDebugEnabled()) {
                            this._log.debug((Object)ex);
                        }
                        ++errors;
                    }
                    throw new DatabaseOperationException("Error while executing SQL " + command, ex);
                }
                for (SQLWarning warning = connection.getWarnings(); warning != null; warning = warning.getNextWarning()) {
                    this._log.warn((Object)warning.toString());
                }
                connection.clearWarnings();
            }
            this._log.info((Object)("Executed " + commandCount + " SQL command(s) with " + errors + " error(s)"));
        }
        catch (SQLException ex) {
            throw new DatabaseOperationException("Error while executing SQL", ex);
        }
        finally {
            this.closeStatement(statement);
        }
        return errors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownDatabase() throws DatabaseOperationException {
        Connection connection = this.borrowConnection();
        try {
            this.shutdownDatabase(connection);
        }
        finally {
            this.returnConnection(connection);
        }
    }

    public void shutdownDatabase(Connection connection) throws DatabaseOperationException {
    }

    public void createDatabase(String jdbcDriverClassName, String connectionUrl, String username, String password, Map parameters) throws DatabaseOperationException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Database creation is not supported for the database platform " + this.getName());
    }

    public void dropDatabase(String jdbcDriverClassName, String connectionUrl, String username, String password) throws DatabaseOperationException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Database deletion is not supported for the database platform " + this.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTables(Database model, boolean dropTablesFirst, boolean continueOnError) throws DatabaseOperationException {
        Connection connection = this.borrowConnection();
        try {
            this.createTables(connection, model, dropTablesFirst, continueOnError);
        }
        finally {
            this.returnConnection(connection);
        }
    }

    public void createTables(Connection connection, Database model, boolean dropTablesFirst, boolean continueOnError) throws DatabaseOperationException {
        String sql = this.getCreateTablesSql(model, dropTablesFirst, continueOnError);
        this.evaluateBatch(connection, sql, continueOnError);
    }

    public String getCreateTablesSql(Database model, boolean dropTablesFirst, boolean continueOnError) {
        String sql = null;
        try {
            StringWriter buffer = new StringWriter();
            this.getSqlBuilder().setWriter(buffer);
            this.getSqlBuilder().createTables(model, dropTablesFirst);
            sql = buffer.toString();
        }
        catch (IOException e) {
            // empty catch block
        }
        return sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTables(Database model, CreationParameters params, boolean dropTablesFirst, boolean continueOnError) throws DatabaseOperationException {
        Connection connection = this.borrowConnection();
        try {
            this.createTables(connection, model, params, dropTablesFirst, continueOnError);
        }
        finally {
            this.returnConnection(connection);
        }
    }

    public void createTables(Connection connection, Database model, CreationParameters params, boolean dropTablesFirst, boolean continueOnError) throws DatabaseOperationException {
        String sql = this.getCreateTablesSql(model, params, dropTablesFirst, continueOnError);
        this.evaluateBatch(connection, sql, continueOnError);
    }

    public String getCreateTablesSql(Database model, CreationParameters params, boolean dropTablesFirst, boolean continueOnError) {
        String sql = null;
        try {
            StringWriter buffer = new StringWriter();
            this.getSqlBuilder().setWriter(buffer);
            this.getSqlBuilder().createTables(model, params, dropTablesFirst);
            sql = buffer.toString();
        }
        catch (IOException e) {
            // empty catch block
        }
        return sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alterTables(Database desiredDb, boolean continueOnError) throws DatabaseOperationException {
        Connection connection = this.borrowConnection();
        try {
            this.alterTables(connection, desiredDb, continueOnError);
        }
        finally {
            this.returnConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAlterTablesSql(Database desiredDb) throws DatabaseOperationException {
        Connection connection = this.borrowConnection();
        try {
            String string = this.getAlterTablesSql(connection, desiredDb);
            return string;
        }
        finally {
            this.returnConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alterTables(Database desiredDb, CreationParameters params, boolean continueOnError) throws DatabaseOperationException {
        Connection connection = this.borrowConnection();
        try {
            this.alterTables(connection, desiredDb, params, continueOnError);
        }
        finally {
            this.returnConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAlterTablesSql(Database desiredDb, CreationParameters params) throws DatabaseOperationException {
        Connection connection = this.borrowConnection();
        try {
            String string = this.getAlterTablesSql(connection, desiredDb, params);
            return string;
        }
        finally {
            this.returnConnection(connection);
        }
    }

    public void alterTables(Connection connection, Database desiredModel, boolean continueOnError) throws DatabaseOperationException {
        String sql = this.getAlterTablesSql(connection, desiredModel);
        this.evaluateBatch(connection, sql, continueOnError);
    }

    public String getAlterTablesSql(Connection connection, Database desiredModel) throws DatabaseOperationException {
        String sql = null;
        Database currentModel = this.readModelFromDatabase(connection, desiredModel.getName());
        try {
            StringWriter buffer = new StringWriter();
            this.getSqlBuilder().setWriter(buffer);
            this.getSqlBuilder().alterDatabase(currentModel, desiredModel, null);
            sql = buffer.toString();
        }
        catch (IOException ex) {
            // empty catch block
        }
        return sql;
    }

    public void alterTables(Connection connection, Database desiredModel, CreationParameters params, boolean continueOnError) throws DatabaseOperationException {
        String sql = this.getAlterTablesSql(connection, desiredModel, params);
        this.evaluateBatch(connection, sql, continueOnError);
    }

    public String getAlterTablesSql(Connection connection, Database desiredModel, CreationParameters params) throws DatabaseOperationException {
        String sql = null;
        Database currentModel = this.readModelFromDatabase(connection, desiredModel.getName());
        try {
            StringWriter buffer = new StringWriter();
            this.getSqlBuilder().setWriter(buffer);
            this.getSqlBuilder().alterDatabase(currentModel, desiredModel, params);
            sql = buffer.toString();
        }
        catch (IOException ex) {
            // empty catch block
        }
        return sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alterTables(String catalog, String schema, String[] tableTypes, Database desiredModel, boolean continueOnError) throws DatabaseOperationException {
        Connection connection = this.borrowConnection();
        try {
            this.alterTables(connection, catalog, schema, tableTypes, desiredModel, continueOnError);
        }
        finally {
            this.returnConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAlterTablesSql(String catalog, String schema, String[] tableTypes, Database desiredModel) throws DatabaseOperationException {
        Connection connection = this.borrowConnection();
        try {
            String string = this.getAlterTablesSql(connection, catalog, schema, tableTypes, desiredModel);
            return string;
        }
        finally {
            this.returnConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alterTables(String catalog, String schema, String[] tableTypes, Database desiredModel, CreationParameters params, boolean continueOnError) throws DatabaseOperationException {
        Connection connection = this.borrowConnection();
        try {
            this.alterTables(connection, catalog, schema, tableTypes, desiredModel, params, continueOnError);
        }
        finally {
            this.returnConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAlterTablesSql(String catalog, String schema, String[] tableTypes, Database desiredModel, CreationParameters params) throws DatabaseOperationException {
        Connection connection = this.borrowConnection();
        try {
            String string = this.getAlterTablesSql(connection, catalog, schema, tableTypes, desiredModel, params);
            return string;
        }
        finally {
            this.returnConnection(connection);
        }
    }

    public void alterTables(Connection connection, String catalog, String schema, String[] tableTypes, Database desiredModel, boolean continueOnError) throws DatabaseOperationException {
        String sql = this.getAlterTablesSql(connection, catalog, schema, tableTypes, desiredModel);
        this.evaluateBatch(connection, sql, continueOnError);
    }

    public String getAlterTablesSql(Connection connection, String catalog, String schema, String[] tableTypes, Database desiredModel) throws DatabaseOperationException {
        String sql = null;
        Database currentModel = this.readModelFromDatabase(connection, desiredModel.getName(), catalog, schema, tableTypes);
        try {
            StringWriter buffer = new StringWriter();
            this.getSqlBuilder().setWriter(buffer);
            this.getSqlBuilder().alterDatabase(currentModel, desiredModel, null);
            sql = buffer.toString();
        }
        catch (IOException ex) {
            // empty catch block
        }
        return sql;
    }

    public void alterTables(Connection connection, String catalog, String schema, String[] tableTypes, Database desiredModel, CreationParameters params, boolean continueOnError) throws DatabaseOperationException {
        String sql = this.getAlterTablesSql(connection, catalog, schema, tableTypes, desiredModel, params);
        this.evaluateBatch(connection, sql, continueOnError);
    }

    public String getAlterTablesSql(Connection connection, String catalog, String schema, String[] tableTypes, Database desiredModel, CreationParameters params) throws DatabaseOperationException {
        String sql = null;
        Database currentModel = this.readModelFromDatabase(connection, desiredModel.getName(), catalog, schema, tableTypes);
        try {
            StringWriter buffer = new StringWriter();
            this.getSqlBuilder().setWriter(buffer);
            this.getSqlBuilder().alterDatabase(currentModel, desiredModel, params);
            sql = buffer.toString();
        }
        catch (IOException ex) {
            // empty catch block
        }
        return sql;
    }

    public void dropTable(Connection connection, Database model, Table table, boolean continueOnError) throws DatabaseOperationException {
        String sql = this.getDropTableSql(model, table, continueOnError);
        this.evaluateBatch(connection, sql, continueOnError);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropTable(Database model, Table table, boolean continueOnError) throws DatabaseOperationException {
        Connection connection = this.borrowConnection();
        try {
            this.dropTable(connection, model, table, continueOnError);
        }
        finally {
            this.returnConnection(connection);
        }
    }

    public String getDropTableSql(Database model, Table table, boolean continueOnError) {
        String sql = null;
        try {
            StringWriter buffer = new StringWriter();
            this.getSqlBuilder().setWriter(buffer);
            this.getSqlBuilder().dropTable(model, table);
            sql = buffer.toString();
        }
        catch (IOException e) {
            // empty catch block
        }
        return sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropTables(Database model, boolean continueOnError) throws DatabaseOperationException {
        Connection connection = this.borrowConnection();
        try {
            this.dropTables(connection, model, continueOnError);
        }
        finally {
            this.returnConnection(connection);
        }
    }

    public void dropTables(Connection connection, Database model, boolean continueOnError) throws DatabaseOperationException {
        String sql = this.getDropTablesSql(model, continueOnError);
        this.evaluateBatch(connection, sql, continueOnError);
    }

    public String getDropTablesSql(Database model, boolean continueOnError) {
        String sql = null;
        try {
            StringWriter buffer = new StringWriter();
            this.getSqlBuilder().setWriter(buffer);
            this.getSqlBuilder().dropTables(model);
            sql = buffer.toString();
        }
        catch (IOException e) {
            // empty catch block
        }
        return sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Database readModelFromDatabase(String name) throws DatabaseOperationException {
        Connection connection = this.borrowConnection();
        try {
            Database database = this.readModelFromDatabase(connection, name);
            return database;
        }
        finally {
            this.returnConnection(connection);
        }
    }

    public Database readModelFromDatabase(Connection connection, String name) throws DatabaseOperationException {
        try {
            Database model = this.getModelReader().getDatabase(connection, name);
            this.postprocessModelFromDatabase(model);
            return model;
        }
        catch (SQLException ex) {
            throw new DatabaseOperationException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Database readModelFromDatabase(String name, String catalog, String schema, String[] tableTypes) throws DatabaseOperationException {
        Connection connection = this.borrowConnection();
        try {
            Database database = this.readModelFromDatabase(connection, name, catalog, schema, tableTypes);
            return database;
        }
        finally {
            this.returnConnection(connection);
        }
    }

    public Database readModelFromDatabase(Connection connection, String name, String catalog, String schema, String[] tableTypes) throws DatabaseOperationException {
        try {
            JdbcModelReader reader = this.getModelReader();
            Database model = reader.getDatabase(connection, name, catalog, schema, tableTypes);
            this.postprocessModelFromDatabase(model);
            if (model.getName() == null || model.getName().length() == 0) {
                model.setName(MODEL_DEFAULT_NAME);
            }
            return model;
        }
        catch (SQLException ex) {
            throw new DatabaseOperationException(ex);
        }
    }

    public Table readTableFromDatabase(Connection connection, String catalogName, String schemaName, String tablename) throws SQLException {
        return this.postprocessTableFromDatabase(this._modelReader.readTable(connection, catalogName, schemaName, tablename));
    }

    protected void postprocessModelFromDatabase(Database model) {
        for (int tableIdx = 0; tableIdx < model.getTableCount(); ++tableIdx) {
            this.postprocessTableFromDatabase(model.getTable(tableIdx));
        }
    }

    protected Table postprocessTableFromDatabase(Table table) {
        if (table != null) {
            for (int columnIdx = 0; columnIdx < table.getColumnCount(); ++columnIdx) {
                String defaultValue;
                Column column = table.getColumn(columnIdx);
                if (!TypeMap.isTextType(column.getTypeCode()) && !TypeMap.isDateTimeType(column.getTypeCode()) || (defaultValue = column.getDefaultValue()) == null || defaultValue.length() < 2 || !defaultValue.startsWith("'") || !defaultValue.endsWith("'")) continue;
                defaultValue = defaultValue.substring(1, defaultValue.length() - 1);
                column.setDefaultValue(defaultValue);
            }
        }
        return table;
    }

    protected void setStatementParameterValue(PreparedStatement statement, int sqlIndex, int typeCode, Object value) throws SQLException {
        if (value == null) {
            statement.setNull(sqlIndex, typeCode);
        } else if (value instanceof String) {
            statement.setString(sqlIndex, (String)value);
        } else if (value instanceof byte[]) {
            statement.setBytes(sqlIndex, (byte[])value);
        } else if (value instanceof Boolean) {
            statement.setBoolean(sqlIndex, (Boolean)value);
        } else if (value instanceof Byte) {
            statement.setByte(sqlIndex, (Byte)value);
        } else if (value instanceof Short) {
            statement.setShort(sqlIndex, (Short)value);
        } else if (value instanceof Integer) {
            statement.setInt(sqlIndex, (Integer)value);
        } else if (value instanceof Long) {
            statement.setLong(sqlIndex, (Long)value);
        } else if (value instanceof BigDecimal) {
            statement.setBigDecimal(sqlIndex, (BigDecimal)value);
        } else if (value instanceof Float) {
            statement.setFloat(sqlIndex, ((Float)value).floatValue());
        } else if (value instanceof Double) {
            statement.setDouble(sqlIndex, (Double)value);
        } else {
            statement.setObject(sqlIndex, value, typeCode);
        }
    }

    protected Object getObjectFromResultSet(ResultSet resultSet, String columnName, Table table) throws SQLException {
        Column column = table == null ? null : table.findColumn(columnName, this.isDelimitedIdentifierModeOn());
        Object value = null;
        if (column != null) {
            int originalJdbcType = column.getTypeCode();
            int targetJdbcType = this.getPlatformInfo().getTargetJdbcType(originalJdbcType);
            int jdbcType = originalJdbcType;
            if (originalJdbcType == 2004 && targetJdbcType != 2004) {
                jdbcType = targetJdbcType;
            }
            if (originalJdbcType == 2005 && targetJdbcType != 2005) {
                jdbcType = targetJdbcType;
            }
            value = this.extractColumnValue(resultSet, columnName, 0, jdbcType);
        } else {
            value = resultSet.getObject(columnName);
        }
        return resultSet.wasNull() ? null : value;
    }

    protected Object getObjectFromResultSet(ResultSet resultSet, Column column, int idx) throws SQLException {
        int originalJdbcType = column.getTypeCode();
        int targetJdbcType = this.getPlatformInfo().getTargetJdbcType(originalJdbcType);
        int jdbcType = originalJdbcType;
        Object value = null;
        if (originalJdbcType == 2004 && targetJdbcType != 2004) {
            jdbcType = targetJdbcType;
        }
        if (originalJdbcType == 2005 && targetJdbcType != 2005) {
            jdbcType = targetJdbcType;
        }
        value = this.extractColumnValue(resultSet, null, idx, jdbcType);
        return resultSet.wasNull() ? null : value;
    }

    protected Object extractColumnValue(ResultSet resultSet, String columnName, int columnIdx, int jdbcType) throws SQLException {
        Object value;
        boolean useIdx = columnName == null;
        switch (jdbcType) {
            case -1: 
            case 1: 
            case 12: {
                value = useIdx ? resultSet.getString(columnIdx) : resultSet.getString(columnName);
                break;
            }
            case 2: 
            case 3: {
                value = useIdx ? resultSet.getBigDecimal(columnIdx) : resultSet.getBigDecimal(columnName);
                break;
            }
            case -7: {
                value = new Boolean(useIdx ? resultSet.getBoolean(columnIdx) : resultSet.getBoolean(columnName));
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                value = new Integer(useIdx ? resultSet.getInt(columnIdx) : resultSet.getInt(columnName));
                break;
            }
            case -5: {
                value = new Long(useIdx ? resultSet.getLong(columnIdx) : resultSet.getLong(columnName));
                break;
            }
            case 7: {
                value = new Float(useIdx ? resultSet.getFloat(columnIdx) : resultSet.getFloat(columnName));
                break;
            }
            case 6: 
            case 8: {
                value = new Double(useIdx ? resultSet.getDouble(columnIdx) : resultSet.getDouble(columnName));
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                value = useIdx ? resultSet.getBytes(columnIdx) : resultSet.getBytes(columnName);
                break;
            }
            case 91: {
                value = useIdx ? resultSet.getDate(columnIdx) : resultSet.getDate(columnName);
                break;
            }
            case 92: {
                value = useIdx ? resultSet.getTime(columnIdx) : resultSet.getTime(columnName);
                break;
            }
            case 93: {
                value = useIdx ? resultSet.getTimestamp(columnIdx) : resultSet.getTimestamp(columnName);
                break;
            }
            case 2005: {
                Clob clob;
                Clob clob2 = clob = useIdx ? resultSet.getClob(columnIdx) : resultSet.getClob(columnName);
                if (clob == null) {
                    value = null;
                    break;
                }
                long length = clob.length();
                if (length > Integer.MAX_VALUE) {
                    value = clob;
                    break;
                }
                if (length == 0L) {
                    value = "";
                    break;
                }
                value = clob.getSubString(1L, (int)length);
                break;
            }
            case 2004: {
                Blob blob;
                Blob blob2 = blob = useIdx ? resultSet.getBlob(columnIdx) : resultSet.getBlob(columnName);
                if (blob == null) {
                    value = null;
                    break;
                }
                long length = blob.length();
                if (length > Integer.MAX_VALUE) {
                    value = blob;
                    break;
                }
                if (length == 0L) {
                    value = new byte[0];
                    break;
                }
                value = blob.getBytes(1L, (int)length);
                break;
            }
            case 2003: {
                value = useIdx ? resultSet.getArray(columnIdx) : resultSet.getArray(columnName);
                break;
            }
            case 2006: {
                value = useIdx ? resultSet.getRef(columnIdx) : resultSet.getRef(columnName);
                break;
            }
            default: {
                value = Jdbc3Utils.supportsJava14JdbcTypes() && jdbcType == Jdbc3Utils.determineBooleanTypeCode() ? new Boolean(useIdx ? resultSet.getBoolean(columnIdx) : resultSet.getBoolean(columnName)) : (useIdx ? resultSet.getObject(columnIdx) : resultSet.getObject(columnName));
            }
        }
        return resultSet.wasNull() ? null : value;
    }
}

