/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.ddl.platform;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jumpmind.symmetric.ddl.Platform;
import org.jumpmind.symmetric.ddl.PlatformInfo;
import org.jumpmind.symmetric.ddl.model.Column;
import org.jumpmind.symmetric.ddl.model.Database;
import org.jumpmind.symmetric.ddl.model.ForeignKey;
import org.jumpmind.symmetric.ddl.model.Index;
import org.jumpmind.symmetric.ddl.model.IndexColumn;
import org.jumpmind.symmetric.ddl.model.NonUniqueIndex;
import org.jumpmind.symmetric.ddl.model.Reference;
import org.jumpmind.symmetric.ddl.model.Table;
import org.jumpmind.symmetric.ddl.model.UniqueIndex;
import org.jumpmind.symmetric.ddl.platform.DatabaseMetaDataWrapper;
import org.jumpmind.symmetric.ddl.platform.MetaDataColumnDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcModelReader {
    private final Log _log = LogFactory.getLog(JdbcModelReader.class);
    private final List<MetaDataColumnDescriptor> _columnsForTable;
    private final List<MetaDataColumnDescriptor> _columnsForColumn;
    private final List<MetaDataColumnDescriptor> _columnsForPK;
    private final List<MetaDataColumnDescriptor> _columnsForFK;
    private final List<MetaDataColumnDescriptor> _columnsForIndex;
    private Platform _platform;
    private HashMap<Integer, String> _defaultSizes = new HashMap();
    private String _defaultCatalogPattern = "%";
    private String _defaultSchemaPattern = "%";
    private String _defaultTablePattern = "%";
    private String _defaultColumnPattern;
    private String[] _defaultTableTypes = new String[]{"TABLE"};

    public JdbcModelReader(Platform platform) {
        this._platform = platform;
        this._defaultSizes.put(new Integer(1), "254");
        this._defaultSizes.put(new Integer(12), "254");
        this._defaultSizes.put(new Integer(-1), "254");
        this._defaultSizes.put(new Integer(-2), "254");
        this._defaultSizes.put(new Integer(-3), "254");
        this._defaultSizes.put(new Integer(-4), "254");
        this._defaultSizes.put(new Integer(4), "32");
        this._defaultSizes.put(new Integer(-5), "64");
        this._defaultSizes.put(new Integer(7), "7,0");
        this._defaultSizes.put(new Integer(6), "15,0");
        this._defaultSizes.put(new Integer(8), "15,0");
        this._defaultSizes.put(new Integer(3), "15,15");
        this._defaultSizes.put(new Integer(2), "15,15");
        this._columnsForTable = this.initColumnsForTable();
        this._columnsForColumn = this.initColumnsForColumn();
        this._columnsForPK = this.initColumnsForPK();
        this._columnsForFK = this.initColumnsForFK();
        this._columnsForIndex = this.initColumnsForIndex();
    }

    public Platform getPlatform() {
        return this._platform;
    }

    public PlatformInfo getPlatformInfo() {
        return this._platform.getPlatformInfo();
    }

    protected List<MetaDataColumnDescriptor> initColumnsForTable() {
        ArrayList<MetaDataColumnDescriptor> result = new ArrayList<MetaDataColumnDescriptor>();
        result.add(new MetaDataColumnDescriptor("TABLE_NAME", 12));
        result.add(new MetaDataColumnDescriptor("TABLE_TYPE", 12, "UNKNOWN"));
        result.add(new MetaDataColumnDescriptor("TABLE_CAT", 12));
        result.add(new MetaDataColumnDescriptor("TABLE_SCHEM", 12));
        result.add(new MetaDataColumnDescriptor("REMARKS", 12));
        return result;
    }

    protected List<MetaDataColumnDescriptor> initColumnsForColumn() {
        ArrayList<MetaDataColumnDescriptor> result = new ArrayList<MetaDataColumnDescriptor>();
        result.add(new MetaDataColumnDescriptor("COLUMN_DEF", 12));
        result.add(new MetaDataColumnDescriptor("TABLE_NAME", 12));
        result.add(new MetaDataColumnDescriptor("COLUMN_NAME", 12));
        result.add(new MetaDataColumnDescriptor("TYPE_NAME", 12));
        result.add(new MetaDataColumnDescriptor("DATA_TYPE", 4, new Integer(1111)));
        result.add(new MetaDataColumnDescriptor("NUM_PREC_RADIX", 4, new Integer(10)));
        result.add(new MetaDataColumnDescriptor("DECIMAL_DIGITS", 4, new Integer(0)));
        result.add(new MetaDataColumnDescriptor("COLUMN_SIZE", 12));
        result.add(new MetaDataColumnDescriptor("IS_NULLABLE", 12, "YES"));
        result.add(new MetaDataColumnDescriptor("IS_AUTOINCREMENT", 12, "YES"));
        result.add(new MetaDataColumnDescriptor("REMARKS", 12));
        return result;
    }

    protected List<MetaDataColumnDescriptor> initColumnsForPK() {
        ArrayList<MetaDataColumnDescriptor> result = new ArrayList<MetaDataColumnDescriptor>();
        result.add(new MetaDataColumnDescriptor("COLUMN_NAME", 12));
        result.add(new MetaDataColumnDescriptor("TABLE_NAME", 12));
        result.add(new MetaDataColumnDescriptor("PK_NAME", 12));
        return result;
    }

    protected List<MetaDataColumnDescriptor> initColumnsForFK() {
        ArrayList<MetaDataColumnDescriptor> result = new ArrayList<MetaDataColumnDescriptor>();
        result.add(new MetaDataColumnDescriptor("PKTABLE_NAME", 12));
        result.add(new MetaDataColumnDescriptor("FKTABLE_NAME", 12));
        result.add(new MetaDataColumnDescriptor("KEY_SEQ", -6, new Short(0)));
        result.add(new MetaDataColumnDescriptor("FK_NAME", 12));
        result.add(new MetaDataColumnDescriptor("PKCOLUMN_NAME", 12));
        result.add(new MetaDataColumnDescriptor("FKCOLUMN_NAME", 12));
        return result;
    }

    protected List<MetaDataColumnDescriptor> initColumnsForIndex() {
        ArrayList<MetaDataColumnDescriptor> result = new ArrayList<MetaDataColumnDescriptor>();
        result.add(new MetaDataColumnDescriptor("INDEX_NAME", 12));
        result.add(new MetaDataColumnDescriptor("TABLE_NAME", 12));
        result.add(new MetaDataColumnDescriptor("NON_UNIQUE", -7, Boolean.TRUE));
        result.add(new MetaDataColumnDescriptor("ORDINAL_POSITION", -6, new Short(0)));
        result.add(new MetaDataColumnDescriptor("COLUMN_NAME", 12));
        result.add(new MetaDataColumnDescriptor("TYPE", -6));
        return result;
    }

    public String getDefaultCatalogPattern() {
        return this._defaultCatalogPattern;
    }

    public void setDefaultCatalogPattern(String catalogPattern) {
        this._defaultCatalogPattern = catalogPattern;
    }

    public String getDefaultSchemaPattern() {
        return this._defaultSchemaPattern;
    }

    public void setDefaultSchemaPattern(String schemaPattern) {
        this._defaultSchemaPattern = schemaPattern;
    }

    public String getDefaultTablePattern() {
        return this._defaultTablePattern;
    }

    public void setDefaultTablePattern(String tablePattern) {
        this._defaultTablePattern = tablePattern;
    }

    public String getDefaultColumnPattern() {
        return this._defaultColumnPattern;
    }

    public void setDefaultColumnPattern(String columnPattern) {
        this._defaultColumnPattern = columnPattern;
    }

    public String[] getDefaultTableTypes() {
        return this._defaultTableTypes;
    }

    public void setDefaultTableTypes(String[] types) {
        this._defaultTableTypes = types;
    }

    protected List<MetaDataColumnDescriptor> getColumnsForTable() {
        return this._columnsForTable;
    }

    protected List<MetaDataColumnDescriptor> getColumnsForColumn() {
        return this._columnsForColumn;
    }

    protected List<MetaDataColumnDescriptor> getColumnsForPK() {
        return this._columnsForPK;
    }

    protected List<MetaDataColumnDescriptor> getColumnsForFK() {
        return this._columnsForFK;
    }

    protected List<MetaDataColumnDescriptor> getColumnsForIndex() {
        return this._columnsForIndex;
    }

    public Database getDatabase(Connection connection, String name) throws SQLException {
        return this.getDatabase(connection, name, null, null, null);
    }

    public Database getDatabase(Connection connection, String name, String catalog, String schema, String[] tableTypes) throws SQLException {
        Database db = new Database();
        if (name == null) {
            try {
                db.setName(connection.getCatalog());
                if (catalog == null) {
                    catalog = db.getName();
                }
            }
            catch (Exception ex) {
                this._log.info((Object)"Cannot determine the catalog name from connection.", (Throwable)ex);
            }
        } else {
            db.setName(name);
        }
        db.addTables(this.readTables(connection, catalog, schema, tableTypes));
        if (this.getPlatform().isForeignKeysSorted()) {
            this.sortForeignKeys(db);
        }
        db.initialize();
        return db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<Table> readTables(Connection connection, String catalog, String schemaPattern, String[] tableTypes) throws SQLException {
        ResultSet tableData = null;
        try {
            DatabaseMetaDataWrapper metaData = new DatabaseMetaDataWrapper();
            metaData.setMetaData(connection.getMetaData());
            metaData.setCatalog(catalog == null ? this.getDefaultCatalogPattern() : catalog);
            metaData.setSchemaPattern(schemaPattern == null ? this.getDefaultSchemaPattern() : schemaPattern);
            metaData.setTableTypes(tableTypes == null || tableTypes.length == 0 ? this.getDefaultTableTypes() : tableTypes);
            tableData = metaData.getTables(this.getDefaultTablePattern());
            ArrayList<Table> tables = new ArrayList<Table>();
            while (tableData.next()) {
                Map<String, Object> values = this.readColumns(tableData, this.getColumnsForTable());
                Table table = this.readTable(connection, metaData, values);
                if (table == null) continue;
                tables.add(table);
            }
            final Collator collator = Collator.getInstance();
            Collections.sort(tables, new Comparator<Table>(){

                @Override
                public int compare(Table obj1, Table obj2) {
                    return collator.compare(obj1.getName().toUpperCase(), obj2.getName().toUpperCase());
                }
            });
            ArrayList<Table> arrayList = tables;
            return arrayList;
        }
        finally {
            if (tableData != null) {
                tableData.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table readTable(Connection connection, String catalog, String schema, String tableName) throws SQLException {
        Table table = null;
        DatabaseMetaDataWrapper metaData = new DatabaseMetaDataWrapper();
        metaData.setMetaData(connection.getMetaData());
        metaData.setCatalog(catalog);
        metaData.setSchemaPattern(schema);
        metaData.setTableTypes(null);
        if (this.getPlatformInfo().isStoresUpperCaseInCatalog()) {
            tableName = tableName.toUpperCase();
        }
        ResultSet tableData = null;
        try {
            tableData = metaData.getTables(this.getTableNamePattern(tableName));
            while (tableData != null && tableData.next()) {
                Map<String, Object> values = this.readColumns(tableData, this.initColumnsForTable());
                table = this.readTable(connection, metaData, values);
            }
            this.close(tableData);
        }
        catch (Throwable throwable) {
            this.close(tableData);
            throw throwable;
        }
        return table;
    }

    protected void close(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    protected void close(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    protected String getTableNamePattern(String tableName) {
        return tableName;
    }

    protected Table readTable(Connection connection, DatabaseMetaDataWrapper metaData, Map<String, Object> values) throws SQLException {
        String tableName = (String)values.get("TABLE_NAME");
        Table table = null;
        if (tableName != null && tableName.length() > 0) {
            table = new Table();
            table.setName(tableName);
            table.setType((String)values.get("TABLE_TYPE"));
            table.setCatalog((String)values.get("TABLE_CAT"));
            table.setSchema((String)values.get("TABLE_SCHEM"));
            table.setDescription((String)values.get("REMARKS"));
            table.addColumns(this.readColumns(metaData, tableName));
            table.addForeignKeys(this.readForeignKeys(connection, metaData, tableName));
            table.addIndices(this.readIndices(connection, metaData, tableName));
            Collection<String> primaryKeys = this.readPrimaryKeyNames(metaData, tableName);
            Iterator<String> it = primaryKeys.iterator();
            while (it.hasNext()) {
                table.findColumn(it.next(), true).setPrimaryKey(true);
            }
            if (this.getPlatformInfo().isSystemIndicesReturned()) {
                this.removeSystemIndices(connection, metaData, table);
            }
        }
        return table;
    }

    protected void removeSystemIndices(Connection connection, DatabaseMetaDataWrapper metaData, Table table) throws SQLException {
        this.removeInternalPrimaryKeyIndex(connection, metaData, table);
        for (int fkIdx = 0; fkIdx < table.getForeignKeyCount(); ++fkIdx) {
            this.removeInternalForeignKeyIndex(connection, metaData, table, table.getForeignKey(fkIdx));
        }
    }

    protected void removeInternalPrimaryKeyIndex(Connection connection, DatabaseMetaDataWrapper metaData, Table table) throws SQLException {
        Column[] pks = table.getPrimaryKeyColumns();
        ArrayList<String> columnNames = new ArrayList<String>();
        for (int columnIdx = 0; columnIdx < pks.length; ++columnIdx) {
            columnNames.add(pks[columnIdx].getName());
        }
        int indexIdx = 0;
        while (indexIdx < table.getIndexCount()) {
            Index index = table.getIndex(indexIdx);
            if (index.isUnique() && this.matches(index, columnNames) && this.isInternalPrimaryKeyIndex(connection, metaData, table, index)) {
                table.removeIndex(indexIdx);
                continue;
            }
            ++indexIdx;
        }
    }

    protected void removeInternalForeignKeyIndex(Connection connection, DatabaseMetaDataWrapper metaData, Table table, ForeignKey fk) throws SQLException {
        ArrayList<String> columnNames = new ArrayList<String>();
        boolean mustBeUnique = !this.getPlatformInfo().isSystemForeignKeyIndicesAlwaysNonUnique();
        for (int columnIdx = 0; columnIdx < fk.getReferenceCount(); ++columnIdx) {
            String name = fk.getReference(columnIdx).getLocalColumnName();
            Column localColumn = table.findColumn(name, this.getPlatform().isDelimitedIdentifierModeOn());
            if (mustBeUnique && !localColumn.isPrimaryKey()) {
                mustBeUnique = false;
            }
            columnNames.add(name);
        }
        int indexIdx = 0;
        while (indexIdx < table.getIndexCount()) {
            Index index = table.getIndex(indexIdx);
            if (mustBeUnique == index.isUnique() && this.matches(index, columnNames) && this.isInternalForeignKeyIndex(connection, metaData, table, fk, index)) {
                fk.setAutoIndexPresent(true);
                table.removeIndex(indexIdx);
                continue;
            }
            ++indexIdx;
        }
    }

    protected boolean matches(Index index, List<String> columnsToSearchFor) {
        if (index.getColumnCount() != columnsToSearchFor.size()) {
            return false;
        }
        for (int columnIdx = 0; columnIdx < index.getColumnCount(); ++columnIdx) {
            if (columnsToSearchFor.get(columnIdx).equals(index.getColumn(columnIdx).getName())) continue;
            return false;
        }
        return true;
    }

    protected boolean isInternalPrimaryKeyIndex(Connection connection, DatabaseMetaDataWrapper metaData, Table table, Index index) throws SQLException {
        return false;
    }

    protected boolean isInternalForeignKeyIndex(Connection connection, DatabaseMetaDataWrapper metaData, Table table, ForeignKey fk, Index index) throws SQLException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<Column> readColumns(DatabaseMetaDataWrapper metaData, String tableName) throws SQLException {
        ResultSet columnData = null;
        try {
            columnData = metaData.getColumns(this.getTableNamePattern(tableName), this.getDefaultColumnPattern());
            ArrayList<Column> columns = new ArrayList<Column>();
            while (columnData.next()) {
                Map<String, Object> values = this.readColumns(columnData, this.getColumnsForColumn());
                columns.add(this.readColumn(metaData, values));
            }
            ArrayList<Column> arrayList = columns;
            this.close(columnData);
            return arrayList;
        }
        catch (Throwable throwable) {
            this.close(columnData);
            throw throwable;
        }
    }

    protected Integer overrideJdbcTypeForColumn(Map<String, Object> values) {
        return null;
    }

    protected Column readColumn(DatabaseMetaDataWrapper metaData, Map<String, Object> values) throws SQLException {
        Integer jdbcType;
        Column column = new Column();
        column.setName((String)values.get("COLUMN_NAME"));
        String defaultValue = (String)values.get("COLUMN_DEF");
        if (defaultValue != null) {
            column.setDefaultValue(defaultValue.trim());
        }
        if ((jdbcType = this.overrideJdbcTypeForColumn(values)) != null) {
            column.setTypeCode(jdbcType);
        } else {
            column.setTypeCode((Integer)values.get("DATA_TYPE"));
        }
        column.setPrecisionRadix((Integer)values.get("NUM_PREC_RADIX"));
        String size = (String)values.get("COLUMN_SIZE");
        int scale = (Integer)values.get("DECIMAL_DIGITS");
        if (size == null) {
            size = this._defaultSizes.get(new Integer(column.getTypeCode()));
        }
        column.setSize(size);
        if (scale != 0) {
            column.setScale(scale);
        }
        column.setRequired("NO".equalsIgnoreCase(((String)values.get("IS_NULLABLE")).trim()));
        column.setDescription((String)values.get("REMARKS"));
        column.setJdbcTypeName((String)values.get("TYPE_NAME"));
        return column;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<String> readPrimaryKeyNames(DatabaseMetaDataWrapper metaData, String tableName) throws SQLException {
        ArrayList<String> pks = new ArrayList<String>();
        ResultSet pkData = null;
        try {
            pkData = metaData.getPrimaryKeys(this.getTableNamePattern(tableName));
            while (pkData.next()) {
                Map<String, Object> values = this.readColumns(pkData, this.getColumnsForPK());
                pks.add(this.readPrimaryKeyName(metaData, values));
            }
            this.close(pkData);
        }
        catch (Throwable throwable) {
            this.close(pkData);
            throw throwable;
        }
        return pks;
    }

    protected String readPrimaryKeyName(DatabaseMetaDataWrapper metaData, Map<String, Object> values) throws SQLException {
        return (String)values.get("COLUMN_NAME");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<ForeignKey> readForeignKeys(Connection connection, DatabaseMetaDataWrapper metaData, String tableName) throws SQLException {
        LinkedHashMap<String, ForeignKey> fks = new LinkedHashMap<String, ForeignKey>();
        ResultSet fkData = null;
        try {
            fkData = metaData.getForeignKeys(tableName);
            while (fkData.next()) {
                Map<String, Object> values = this.readColumns(fkData, this.getColumnsForFK());
                this.readForeignKey(metaData, values, fks);
            }
        }
        finally {
            this.close(fkData);
        }
        return fks.values();
    }

    protected void readForeignKey(DatabaseMetaDataWrapper metaData, Map<String, Object> values, Map<String, ForeignKey> knownFks) throws SQLException {
        String fkName = (String)values.get("FK_NAME");
        ForeignKey fk = knownFks.get(fkName);
        if (fk == null) {
            fk = new ForeignKey(fkName);
            fk.setForeignTableName((String)values.get("PKTABLE_NAME"));
            knownFks.put(fkName, fk);
        }
        Reference ref = new Reference();
        ref.setForeignColumnName((String)values.get("PKCOLUMN_NAME"));
        ref.setLocalColumnName((String)values.get("FKCOLUMN_NAME"));
        if (values.containsKey("KEY_SEQ")) {
            ref.setSequenceValue(((Short)values.get("KEY_SEQ")).intValue());
        }
        fk.addReference(ref);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<Index> readIndices(Connection connection, DatabaseMetaDataWrapper metaData, String tableName) throws SQLException {
        LinkedHashMap<String, Index> indices = new LinkedHashMap<String, Index>();
        ResultSet indexData = null;
        try {
            indexData = metaData.getIndices(this.getTableNamePattern(tableName), false, false);
            while (indexData.next()) {
                Map<String, Object> values = this.readColumns(indexData, this.getColumnsForIndex());
                this.readIndex(metaData, values, indices);
            }
            this.close(indexData);
        }
        catch (Throwable throwable) {
            this.close(indexData);
            throw throwable;
        }
        return indices.values();
    }

    protected void readIndex(DatabaseMetaDataWrapper metaData, Map<String, Object> values, Map<String, Index> knownIndices) throws SQLException {
        Short indexType = (Short)values.get("TYPE");
        if (indexType != null && indexType == 0) {
            return;
        }
        String indexName = (String)values.get("INDEX_NAME");
        if (indexName != null) {
            Index index = knownIndices.get(indexName);
            if (index == null) {
                index = (Boolean)values.get("NON_UNIQUE") != false ? new NonUniqueIndex() : new UniqueIndex();
                index.setName(indexName);
                knownIndices.put(indexName, index);
            }
            IndexColumn indexColumn = new IndexColumn();
            indexColumn.setName((String)values.get("COLUMN_NAME"));
            if (values.containsKey("ORDINAL_POSITION")) {
                indexColumn.setOrdinalPosition(((Short)values.get("ORDINAL_POSITION")).intValue());
            }
            index.addColumn(indexColumn);
        }
    }

    protected Map<String, Object> readColumns(ResultSet resultSet, List<MetaDataColumnDescriptor> columnDescriptors) throws SQLException {
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (MetaDataColumnDescriptor descriptor : columnDescriptors) {
            values.put(descriptor.getName(), descriptor.readColumn(resultSet));
        }
        return values;
    }

    protected void determineAutoIncrementFromResultSetMetaData(Connection conn, Table table, Column[] columnsToCheck) throws SQLException {
        this.determineAutoIncrementFromResultSetMetaData(conn, table, columnsToCheck, ".");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void determineAutoIncrementFromResultSetMetaData(Connection conn, Table table, Column[] columnsToCheck, String catalogSeparator) throws SQLException {
        StringBuilder query = new StringBuilder();
        try {
            if (columnsToCheck == null || columnsToCheck.length == 0) {
                return;
            }
            query.append("SELECT ");
            for (int idx = 0; idx < columnsToCheck.length; ++idx) {
                if (idx > 0) {
                    query.append(",");
                }
                query.append("t.");
                this.appendIdentifier(query, columnsToCheck[idx].getName());
            }
            query.append(" FROM ");
            if (table.getCatalog() != null && !table.getCatalog().trim().equals("")) {
                this.appendIdentifier(query, table.getCatalog());
                query.append(catalogSeparator);
            }
            if (table.getSchema() != null && !table.getSchema().trim().equals("")) {
                this.appendIdentifier(query, table.getSchema()).append(".");
            }
            this.appendIdentifier(query, table.getName()).append(" t WHERE 1 = 0");
            Statement stmt = null;
            try {
                stmt = conn.createStatement();
                ResultSet rs = stmt.executeQuery(query.toString());
                ResultSetMetaData rsMetaData = rs.getMetaData();
                for (int idx = 0; idx < columnsToCheck.length; ++idx) {
                    if (!rsMetaData.isAutoIncrement(idx + 1)) continue;
                    columnsToCheck[idx].setAutoIncrement(true);
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        catch (SQLException ex) {
            StringBuilder msg = new StringBuilder("Failed to determine auto increment columns using this query: '" + query + "'.  This is probably not harmful, but should be fixed.  ");
            msg.append("\n");
            msg.append(table.toString());
            if (columnsToCheck != null) {
                for (Column col : columnsToCheck) {
                    msg.append("\n");
                    msg.append(col.toString());
                }
            }
            this._log.warn((Object)msg);
        }
    }

    public StringBuilder appendIdentifier(StringBuilder query, String identifier) {
        if (this.getPlatform().isDelimitedIdentifierModeOn()) {
            query.append(this.getPlatformInfo().getDelimiterToken());
        }
        query.append(identifier);
        if (this.getPlatform().isDelimitedIdentifierModeOn()) {
            query.append(this.getPlatformInfo().getDelimiterToken());
        }
        return query;
    }

    protected void sortForeignKeys(Database model) {
        for (int tableIdx = 0; tableIdx < model.getTableCount(); ++tableIdx) {
            model.getTable(tableIdx).sortForeignKeys(this.getPlatform().isDelimitedIdentifierModeOn());
        }
    }

    protected String unescape(String text, String unescaped, String escaped) {
        String result = text;
        if (result != null) {
            result = escaped.equals("''") ? (result.length() > 2 && result.startsWith("'") && result.endsWith("'") ? "'" + StringUtils.replace((String)result.substring(1, result.length() - 1), (String)escaped, (String)unescaped) + "'" : StringUtils.replace((String)result, (String)escaped, (String)unescaped)) : StringUtils.replace((String)result, (String)escaped, (String)unescaped);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String determineSchemaOf(Connection connection, String schemaPattern, Table table) throws SQLException {
        ResultSet tableData = null;
        ResultSet columnData = null;
        try {
            DatabaseMetaDataWrapper metaData = new DatabaseMetaDataWrapper();
            metaData.setMetaData(connection.getMetaData());
            metaData.setCatalog(this.getDefaultCatalogPattern());
            metaData.setSchemaPattern(schemaPattern == null ? this.getDefaultSchemaPattern() : schemaPattern);
            metaData.setTableTypes(this.getDefaultTableTypes());
            String tablePattern = table.getName();
            if (this.getPlatform().isDelimitedIdentifierModeOn()) {
                tablePattern = tablePattern.toUpperCase();
            }
            tableData = metaData.getTables(tablePattern);
            boolean found = false;
            String schema = null;
            while (!found && tableData.next()) {
                Map<String, Object> values = this.readColumns(tableData, this.getColumnsForTable());
                String tableName = (String)values.get("TABLE_NAME");
                if (tableName == null || tableName.length() <= 0) continue;
                schema = (String)values.get("TABLE_SCHEM");
                columnData = metaData.getColumns(tableName, this.getDefaultColumnPattern());
                found = true;
                while (found && columnData.next()) {
                    values = this.readColumns(columnData, this.getColumnsForColumn());
                    if (table.findColumn((String)values.get("COLUMN_NAME"), this.getPlatform().isDelimitedIdentifierModeOn()) != null) continue;
                    found = false;
                }
                columnData.close();
                columnData = null;
            }
            String string = found ? schema : null;
            this.close(columnData);
            this.close(tableData);
            return string;
        }
        catch (Throwable throwable) {
            this.close(columnData);
            this.close(tableData);
            throw throwable;
        }
    }
}

