/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.ddl.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.jumpmind.symmetric.ddl.model.ModelException;
import org.jumpmind.symmetric.ddl.model.TypeMap;
import org.jumpmind.symmetric.ddl.util.Jdbc3Utils;

public class Column
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -6226348998874210093L;
    private String name;
    private String javaName;
    private String description;
    private boolean primaryKey;
    private boolean required;
    private boolean autoIncrement;
    private int typeCode;
    private String type;
    private String size;
    private Integer sizeAsInt;
    private int scale;
    private String defaultValue;
    private String jdbcTypeName;
    private boolean distributionKey;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getJavaName() {
        return this.javaName;
    }

    public void setJavaName(String javaName) {
        this.javaName = javaName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(boolean primaryKey) {
        this.primaryKey = primaryKey;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    public void setAutoIncrement(boolean autoIncrement) {
        this.autoIncrement = autoIncrement;
    }

    public int getTypeCode() {
        return this.typeCode;
    }

    public void setTypeCode(int typeCode) {
        this.type = TypeMap.getJdbcTypeName(typeCode);
        if (this.type == null) {
            throw new ModelException("Unknown JDBC type code " + typeCode);
        }
        this.typeCode = typeCode;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        Integer typeCode = TypeMap.getJdbcTypeCode(type);
        if (typeCode == null) {
            throw new ModelException("Unknown JDBC type " + type);
        }
        this.typeCode = typeCode;
        this.type = TypeMap.getJdbcTypeName(typeCode);
    }

    public boolean isOfNumericType() {
        return TypeMap.isNumericType(this.getTypeCode());
    }

    public boolean isOfTextType() {
        return TypeMap.isTextType(this.getTypeCode());
    }

    public boolean isOfBinaryType() {
        return TypeMap.isBinaryType(this.getTypeCode());
    }

    public boolean isOfSpecialType() {
        return TypeMap.isSpecialType(this.getTypeCode());
    }

    public String getSize() {
        return this.size;
    }

    public int getSizeAsInt() {
        return this.sizeAsInt == null ? 0 : this.sizeAsInt;
    }

    public void setSize(String size) {
        if (size != null) {
            int pos = size.indexOf(",");
            this.size = size;
            if (pos < 0) {
                this.scale = 0;
                this.sizeAsInt = new Integer(size);
            } else {
                this.sizeAsInt = new Integer(size.substring(0, pos));
                this.scale = Integer.parseInt(size.substring(pos + 1));
            }
        } else {
            size = null;
            this.sizeAsInt = null;
            this.scale = 0;
        }
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.setSizeAndScale(this.getSizeAsInt(), scale);
    }

    public void setSizeAndScale(int size, int scale) {
        this.sizeAsInt = new Integer(size);
        this.scale = scale;
        this.size = String.valueOf(size);
        if (scale > 0) {
            this.size = this.size + "," + scale;
        }
    }

    public int getPrecisionRadix() {
        return this.getSizeAsInt();
    }

    public void setPrecisionRadix(int precisionRadix) {
        this.sizeAsInt = new Integer(precisionRadix);
        this.size = String.valueOf(precisionRadix);
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public Object getParsedDefaultValue() {
        if (this.defaultValue != null && this.defaultValue.length() > 0) {
            try {
                switch (this.typeCode) {
                    case -6: 
                    case 5: {
                        return new Short(this.defaultValue);
                    }
                    case 4: {
                        return new Integer(this.defaultValue);
                    }
                    case -5: {
                        return new Long(this.defaultValue);
                    }
                    case 2: 
                    case 3: {
                        return new BigDecimal(this.defaultValue);
                    }
                    case 7: {
                        return new Float(this.defaultValue);
                    }
                    case 6: 
                    case 8: {
                        return new Double(this.defaultValue);
                    }
                    case 91: {
                        return Date.valueOf(this.defaultValue);
                    }
                    case 92: {
                        return Time.valueOf(this.defaultValue);
                    }
                    case 93: {
                        return Timestamp.valueOf(this.defaultValue);
                    }
                    case -7: {
                        return ConvertUtils.convert((String)this.defaultValue, Boolean.class);
                    }
                }
                if (Jdbc3Utils.supportsJava14JdbcTypes() && this.typeCode == Jdbc3Utils.determineBooleanTypeCode()) {
                    return ConvertUtils.convert((String)this.defaultValue, Boolean.class);
                }
            }
            catch (NumberFormatException ex) {
                return null;
            }
            catch (IllegalArgumentException ex) {
                return null;
            }
        }
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public Object clone() throws CloneNotSupportedException {
        Column result = (Column)super.clone();
        result.name = this.name;
        result.javaName = this.javaName;
        result.primaryKey = this.primaryKey;
        result.required = this.required;
        result.autoIncrement = this.autoIncrement;
        result.typeCode = this.typeCode;
        result.type = this.type;
        result.size = this.size;
        result.defaultValue = this.defaultValue;
        result.scale = this.scale;
        result.size = this.size;
        result.sizeAsInt = this.sizeAsInt;
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Column) {
            Column other = (Column)obj;
            EqualsBuilder comparator = new EqualsBuilder();
            comparator.append((Object)this.name, (Object)other.name);
            comparator.append(this.primaryKey, other.primaryKey);
            comparator.append(this.required, other.required);
            comparator.append(this.autoIncrement, other.autoIncrement);
            comparator.append(this.typeCode, other.typeCode);
            comparator.append(this.getParsedDefaultValue(), other.getParsedDefaultValue());
            if (this.typeCode == 2 || this.typeCode == 3) {
                comparator.append((Object)this.size, (Object)other.size);
                comparator.append(this.scale, other.scale);
            } else if (this.typeCode == 1 || this.typeCode == 12 || this.typeCode == -2 || this.typeCode == -3) {
                comparator.append((Object)this.size, (Object)other.size);
            }
            return comparator.isEquals();
        }
        return false;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder(17, 37);
        builder.append((Object)this.name);
        builder.append(this.primaryKey);
        builder.append(this.required);
        builder.append(this.autoIncrement);
        builder.append(this.typeCode);
        builder.append((Object)this.type);
        builder.append(this.scale);
        builder.append(this.getParsedDefaultValue());
        if (!TypeMap.isNumericType(this.typeCode)) {
            builder.append((Object)this.size);
        }
        return builder.toHashCode();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("Column [name=");
        result.append(this.getName());
        result.append("; type=");
        result.append(this.getType());
        result.append("]");
        return result.toString();
    }

    public String toVerboseString() {
        StringBuffer result = new StringBuffer();
        result.append("Column [name=");
        result.append(this.getName());
        result.append("; javaName=");
        result.append(this.getJavaName());
        result.append("; type=");
        result.append(this.getType());
        result.append("; typeCode=");
        result.append(this.getTypeCode());
        result.append("; size=");
        result.append(this.getSize());
        result.append("; required=");
        result.append(this.isRequired());
        result.append("; primaryKey=");
        result.append(this.isPrimaryKey());
        result.append("; autoIncrement=");
        result.append(this.isAutoIncrement());
        result.append("; defaultValue=");
        result.append(this.getDefaultValue());
        result.append("; precisionRadix=");
        result.append(this.getPrecisionRadix());
        result.append("; scale=");
        result.append(this.getScale());
        result.append("]");
        return result.toString();
    }

    public void setJdbcTypeName(String jdbcTypeName) {
        this.jdbcTypeName = jdbcTypeName;
    }

    public String getJdbcTypeName() {
        return this.jdbcTypeName;
    }

    public boolean isDistributionKey() {
        return this.distributionKey;
    }

    public void setDistributionKey(boolean distributionKey) {
        this.distributionKey = distributionKey;
    }
}

