/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.ddl.alteration;

import org.jumpmind.symmetric.ddl.alteration.TableChangeImplBase;
import org.jumpmind.symmetric.ddl.model.Column;
import org.jumpmind.symmetric.ddl.model.Database;
import org.jumpmind.symmetric.ddl.model.Table;

public class RemovePrimaryKeyChange
extends TableChangeImplBase {
    private Column[] _primaryKeyColumns;

    public RemovePrimaryKeyChange(Table table, Column[] primaryKeyColumns) {
        super(table);
        this._primaryKeyColumns = primaryKeyColumns;
    }

    public Column[] getPrimaryKeyColumns() {
        return this._primaryKeyColumns;
    }

    public void apply(Database database, boolean caseSensitive) {
        Table table = database.findTable(this.getChangedTable().getName(), caseSensitive);
        for (int idx = 0; idx < this._primaryKeyColumns.length; ++idx) {
            Column column = table.findColumn(this._primaryKeyColumns[idx].getName(), caseSensitive);
            column.setPrimaryKey(false);
        }
    }
}

