/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.ddl.alteration;

import org.jumpmind.symmetric.ddl.alteration.TableChangeImplBase;
import org.jumpmind.symmetric.ddl.model.Column;
import org.jumpmind.symmetric.ddl.model.Database;
import org.jumpmind.symmetric.ddl.model.Table;

public class PrimaryKeyChange
extends TableChangeImplBase {
    private Column[] _oldPrimaryKeyColumns;
    private Column[] _newPrimaryKeyColumns;

    public PrimaryKeyChange(Table table, Column[] oldPrimaryKeyColumns, Column[] newPrimaryKeyColumns) {
        super(table);
        this._oldPrimaryKeyColumns = oldPrimaryKeyColumns;
        this._newPrimaryKeyColumns = newPrimaryKeyColumns;
    }

    public Column[] getOldPrimaryKeyColumns() {
        return this._oldPrimaryKeyColumns;
    }

    public Column[] getNewPrimaryKeyColumns() {
        return this._newPrimaryKeyColumns;
    }

    public void apply(Database database, boolean caseSensitive) {
        Column column;
        int idx;
        Table table = database.findTable(this.getChangedTable().getName(), caseSensitive);
        for (idx = 0; idx < this._oldPrimaryKeyColumns.length; ++idx) {
            column = table.findColumn(this._oldPrimaryKeyColumns[idx].getName(), caseSensitive);
            column.setPrimaryKey(false);
        }
        for (idx = 0; idx < this._newPrimaryKeyColumns.length; ++idx) {
            column = table.findColumn(this._newPrimaryKeyColumns[idx].getName(), caseSensitive);
            column.setPrimaryKey(true);
        }
    }
}

