/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.ddl.alteration;

import org.jumpmind.symmetric.ddl.DdlUtilsException;
import org.jumpmind.symmetric.ddl.alteration.TableChangeImplBase;
import org.jumpmind.symmetric.ddl.model.Database;
import org.jumpmind.symmetric.ddl.model.ForeignKey;
import org.jumpmind.symmetric.ddl.model.Table;

public class AddForeignKeyChange
extends TableChangeImplBase {
    private ForeignKey _newForeignKey;

    public AddForeignKeyChange(Table table, ForeignKey newForeignKey) {
        super(table);
        this._newForeignKey = newForeignKey;
    }

    public ForeignKey getNewForeignKey() {
        return this._newForeignKey;
    }

    public void apply(Database database, boolean caseSensitive) {
        ForeignKey newFK = null;
        try {
            newFK = (ForeignKey)this._newForeignKey.clone();
            newFK.setForeignTable(database.findTable(this._newForeignKey.getForeignTableName(), caseSensitive));
        }
        catch (CloneNotSupportedException ex) {
            throw new DdlUtilsException(ex);
        }
        database.findTable(this.getChangedTable().getName()).addForeignKey(newFK);
    }
}

