/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.ddl;

import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jumpmind.symmetric.ddl.DdlUtilsException;
import org.jumpmind.symmetric.ddl.Platform;
import org.jumpmind.symmetric.ddl.PlatformUtils;
import org.jumpmind.symmetric.ddl.platform.cloudscape.CloudscapePlatform;
import org.jumpmind.symmetric.ddl.platform.db2.Db2v8Platform;
import org.jumpmind.symmetric.ddl.platform.derby.DerbyPlatform;
import org.jumpmind.symmetric.ddl.platform.firebird.FirebirdPlatform;
import org.jumpmind.symmetric.ddl.platform.greenplum.GreenplumPlatform;
import org.jumpmind.symmetric.ddl.platform.h2.H2Platform;
import org.jumpmind.symmetric.ddl.platform.hsqldb.HsqlDbPlatform;
import org.jumpmind.symmetric.ddl.platform.hsqldb2.HsqlDb2Platform;
import org.jumpmind.symmetric.ddl.platform.informix.InformixPlatform;
import org.jumpmind.symmetric.ddl.platform.interbase.InterbasePlatform;
import org.jumpmind.symmetric.ddl.platform.mssql.MSSqlPlatform;
import org.jumpmind.symmetric.ddl.platform.mysql.MySql50Platform;
import org.jumpmind.symmetric.ddl.platform.mysql.MySqlPlatform;
import org.jumpmind.symmetric.ddl.platform.oracle.Oracle10Platform;
import org.jumpmind.symmetric.ddl.platform.oracle.Oracle8Platform;
import org.jumpmind.symmetric.ddl.platform.oracle.Oracle9Platform;
import org.jumpmind.symmetric.ddl.platform.postgresql.PostgreSqlPlatform;
import org.jumpmind.symmetric.ddl.platform.sqlite.SqLitePlatform;
import org.jumpmind.symmetric.ddl.platform.sybase.SybaseASE15Platform;
import org.jumpmind.symmetric.ddl.platform.sybase.SybasePlatform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlatformFactory {
    private static final Log _log = LogFactory.getLog(PlatformFactory.class);
    private static Map<String, Class<? extends Platform>> _platforms = null;

    private static synchronized Map<String, Class<? extends Platform>> getPlatforms() {
        if (_platforms == null) {
            _platforms = new HashMap<String, Class<? extends Platform>>();
            PlatformFactory.registerPlatforms();
        }
        return _platforms;
    }

    public static synchronized Platform createNewPlatformInstance(String databaseName) throws DdlUtilsException {
        Class<? extends Platform> platformClass = PlatformFactory.getPlatforms().get(databaseName.toLowerCase());
        try {
            return platformClass != null ? platformClass.newInstance() : null;
        }
        catch (Exception ex) {
            throw new DdlUtilsException("Could not create platform for database " + databaseName, ex);
        }
    }

    public static synchronized Platform createNewPlatformInstance(String jdbcDriver, String jdbcConnectionUrl) throws DdlUtilsException {
        return PlatformFactory.createNewPlatformInstance(PlatformUtils.determineDatabaseType(jdbcDriver, jdbcConnectionUrl));
    }

    public static synchronized Platform createNewPlatformInstance(DataSource dataSource) throws DdlUtilsException {
        String nameVersion = PlatformUtils.determineDatabaseNameVersion(dataSource);
        Platform platform = PlatformFactory.createNewPlatformInstance(nameVersion);
        if (platform == null) {
            String dbType = PlatformUtils.determineDatabaseType(dataSource);
            _log.debug((Object)("The name/version pair returned for the database, " + nameVersion + ",  was not mapped to a known database platform.  Defaulting to using just the database type of " + dbType));
            platform = PlatformFactory.createNewPlatformInstance(dbType);
        }
        platform.setDataSource(dataSource);
        return platform;
    }

    public static synchronized String[] getSupportedPlatforms() {
        return PlatformFactory.getPlatforms().keySet().toArray(new String[0]);
    }

    public static boolean isPlatformSupported(String platformName) {
        return PlatformFactory.getPlatforms().containsKey(platformName.toLowerCase());
    }

    public static synchronized void registerPlatform(String platformName, Class<? extends Platform> platformClass) {
        PlatformFactory.addPlatform(PlatformFactory.getPlatforms(), platformName, platformClass);
    }

    private static void registerPlatforms() {
        for (String name : H2Platform.DATABASENAMES) {
            PlatformFactory.addPlatform(_platforms, name, H2Platform.class);
        }
        PlatformFactory.addPlatform(_platforms, "SQLite3", SqLitePlatform.class);
        PlatformFactory.addPlatform(_platforms, "Informix Dynamic Server11", InformixPlatform.class);
        PlatformFactory.addPlatform(_platforms, "Cloudscape", CloudscapePlatform.class);
        PlatformFactory.addPlatform(_platforms, Db2v8Platform.DATABASENAMES, Db2v8Platform.class);
        PlatformFactory.addPlatform(_platforms, "Derby", DerbyPlatform.class);
        PlatformFactory.addPlatform(_platforms, "Firebird", FirebirdPlatform.class);
        PlatformFactory.addPlatform(_platforms, "Greenplum4", GreenplumPlatform.class);
        PlatformFactory.addPlatform(_platforms, "HsqlDb", HsqlDbPlatform.class);
        PlatformFactory.addPlatform(_platforms, "HSQL Database Engine2", HsqlDb2Platform.class);
        PlatformFactory.addPlatform(_platforms, "Interbase", InterbasePlatform.class);
        PlatformFactory.addPlatform(_platforms, "MsSql", MSSqlPlatform.class);
        PlatformFactory.addPlatform(_platforms, "MySQL", MySqlPlatform.class);
        PlatformFactory.addPlatform(_platforms, "MySQL5", MySql50Platform.class);
        PlatformFactory.addPlatform(_platforms, "Oracle", Oracle8Platform.class);
        PlatformFactory.addPlatform(_platforms, "Oracle9", Oracle9Platform.class);
        PlatformFactory.addPlatform(_platforms, "Oracle10", Oracle10Platform.class);
        PlatformFactory.addPlatform(_platforms, "Oracle11", Oracle10Platform.class);
        PlatformFactory.addPlatform(_platforms, "PostgreSql", PostgreSqlPlatform.class);
        PlatformFactory.addPlatform(_platforms, "Sybase", SybasePlatform.class);
        PlatformFactory.addPlatform(_platforms, "SybaseASE15", SybaseASE15Platform.class);
    }

    private static synchronized void addPlatform(Map<String, Class<? extends Platform>> platformMap, String[] platformNames, Class<? extends Platform> platformClass) {
        for (String platformName : platformNames) {
            PlatformFactory.addPlatform(platformMap, platformName, platformClass);
        }
    }

    private static synchronized void addPlatform(Map<String, Class<? extends Platform>> platformMap, String platformName, Class<? extends Platform> platformClass) {
        if (!Platform.class.isAssignableFrom(platformClass)) {
            throw new IllegalArgumentException("Cannot register class " + platformClass.getName() + " because it does not implement the " + Platform.class.getName() + " interface");
        }
        platformMap.put(platformName.toLowerCase(), platformClass);
    }
}

