/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.symmetricds.router;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jumpmind.symmetric.model.DataMetaData;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.Router;
import org.jumpmind.symmetric.route.AbstractDataRouter;
import org.jumpmind.symmetric.route.IDataRouter;
import org.jumpmind.symmetric.route.IRouterContext;

public class RjDokumentRouter
extends AbstractDataRouter
implements IDataRouter {
    static final String EXPRESSION_KEY = String.format("%s.Expression.", RjDokumentRouter.class.getName());

    public Set<String> routeToNodes(IRouterContext routingContext, DataMetaData dataMetaData, Set<Node> nodes, boolean arg3) {
        Set nodeIds = null;
        Map<String, String> expressions = this.getExpressions(dataMetaData.getTriggerRouter().getRouter(), routingContext);
        Map columnValues = this.getDataMap(dataMetaData);
        String rj = (String)columnValues.get("OZNRJ");
        if (StringUtils.isBlank((String)rj)) {
            return null;
        }
        String nid = expressions.get(rj);
        if (columnValues != null) {
            for (Node node : nodes) {
                if (!node.getNodeId().equals(nid)) continue;
                nodeIds = this.addNodeId(node.getNodeId(), nodeIds, nodes);
                break;
            }
        }
        return nodeIds;
    }

    protected Map<String, String> getExpressions(Router router, IRouterContext context) {
        String KEY = String.valueOf(EXPRESSION_KEY) + router.getRouterId();
        Map<String, String> rjmap = (Map<String, String>)context.getContextCache().get(KEY);
        if (rjmap == null) {
            rjmap = this.parse(router.getRouterExpression());
            context.getContextCache().put(KEY, rjmap);
        }
        return rjmap;
    }

    protected Map<String, String> parse(String routerExpression) {
        HashMap<String, String> rjmap = new HashMap<String, String>();
        if (!StringUtils.isBlank((String)routerExpression)) {
            String[] expTokens = routerExpression.split(";");
            if (expTokens != null) {
                String[] stringArray = expTokens;
                int n = expTokens.length;
                int n2 = 0;
                while (n2 < n) {
                    String t = stringArray[n2];
                    if (!StringUtils.isBlank((String)t)) {
                        String[] tokens = t.split("=");
                        if (tokens.length == 2) {
                            rjmap.put(tokens[0], tokens[1]);
                        } else {
                            this.log.warn("The provided rj-dokument map expression was invalid: {}.  The full expression is {}.", new Object[]{t, routerExpression});
                        }
                    }
                    ++n2;
                }
            }
        } else {
            this.log.warn("The provided rj-dokument map expression was invalid: {}.  The full expression is {}.", new Object[]{routerExpression, routerExpression});
        }
        return rjmap;
    }
}

