/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionArithmetic;
import org.hsqldb.ExpressionValue;
import org.hsqldb.FunctionSQL;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.Session;
import org.hsqldb.SortAndSlice;
import org.hsqldb.Tokens;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.IntKeyIntValueHashMap;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.persist.Crypto;
import org.hsqldb.store.BitMap;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.ArrayType;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BinaryType;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.CharacterType;
import org.hsqldb.types.ClobData;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.IntervalMonthData;
import org.hsqldb.types.IntervalSecondData;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.LobData;
import org.hsqldb.types.NumberType;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public class FunctionCustom
extends FunctionSQL {
    public static final String[] openGroupNumericFunctions = new String[]{"ABS", "ACOS", "ASIN", "ATAN", "ATAN2", "BITAND", "BITOR", "BITXOR", "CEILING", "COS", "COT", "DEGREES", "EXP", "FLOOR", "LOG", "LOG10", "MOD", "PI", "POWER", "RADIANS", "RAND", "ROUND", "ROUNDMAGIC", "SIGN", "SIN", "SQRT", "TAN", "TRUNCATE"};
    public static final String[] openGroupStringFunctions = new String[]{"ASCII", "CHAR", "CONCAT", "DIFFERENCE", "HEXTORAW", "INSERT", "LCASE", "LEFT", "LENGTH", "LOCATE", "LTRIM", "RAWTOHEX", "REPEAT", "REPLACE", "RIGHT", "RTRIM", "SOUNDEX", "SPACE", "SUBSTR", "UCASE"};
    public static final String[] openGroupDateTimeFunctions = new String[]{"CURDATE", "CURTIME", "DATEDIFF", "DAYNAME", "DAYOFMONTH", "DAYOFWEEK", "DAYOFYEAR", "HOUR", "MINUTE", "MONTH", "MONTHNAME", "NOW", "QUARTER", "SECOND", "SECONDS_SINCE_MIDNIGHT", "TIMESTAMPADD", "TIMESTAMPDIFF", "TO_CHAR", "WEEK", "YEAR"};
    public static final String[] openGroupSystemFunctions = new String[]{"DATABASE", "IFNULL", "USER"};
    private static final int FUNC_ACOS = 71;
    private static final int FUNC_ACTION_ID = 72;
    private static final int FUNC_ASCII = 73;
    private static final int FUNC_ASIN = 74;
    private static final int FUNC_ATAN = 75;
    private static final int FUNC_ATAN2 = 76;
    private static final int FUNC_BITAND = 77;
    private static final int FUNC_BITOR = 78;
    private static final int FUNC_BITXOR = 79;
    private static final int FUNC_CHAR = 80;
    private static final int FUNC_CONCAT = 81;
    private static final int FUNC_COS = 82;
    private static final int FUNC_COT = 83;
    private static final int FUNC_CRYPT_KEY = 84;
    private static final int FUNC_DATABASE = 85;
    private static final int FUNC_DATABASE_ISOLATION_LEVEL = 86;
    private static final int FUNC_DATABASE_NAME = 87;
    private static final int FUNC_DATABASE_TIMEZONE = 88;
    private static final int FUNC_DATABASE_VERSION = 89;
    private static final int FUNC_DATEADD = 90;
    private static final int FUNC_DATEDIFF = 91;
    private static final int FUNC_DEGREES = 92;
    private static final int FUNC_DIAGNOSTICS = 93;
    private static final int FUNC_DIFFERENCE = 94;
    private static final int FUNC_HEXTORAW = 95;
    private static final int FUNC_IDENTITY = 96;
    private static final int FUNC_ISAUTOCOMMIT = 97;
    private static final int FUNC_ISOLATION_LEVEL = 98;
    private static final int FUNC_ISREADONLYDATABASE = 99;
    private static final int FUNC_ISREADONLYDATABASEFILES = 100;
    private static final int FUNC_ISREADONLYSESSION = 101;
    private static final int FUNC_LEFT = 102;
    private static final int FUNC_LOAD_FILE = 103;
    private static final int FUNC_LOB_ID = 104;
    private static final int FUNC_LOCATE = 105;
    private static final int FUNC_LOG10 = 106;
    private static final int FUNC_LPAD = 107;
    private static final int FUNC_LTRIM = 108;
    private static final int FUNC_PI = 109;
    private static final int FUNC_POSITION_ARRAY = 110;
    private static final int FUNC_RADIANS = 111;
    private static final int FUNC_RAND = 112;
    private static final int FUNC_RAWTOHEX = 113;
    private static final int FUNC_REGEXP_MATCHES = 114;
    private static final int FUNC_REGEXP_SUBSTRING = 115;
    private static final int FUNC_REGEXP_SUBSTRING_ARRAY = 116;
    private static final int FUNC_REPEAT = 117;
    private static final int FUNC_REPLACE = 118;
    private static final int FUNC_REVERSE = 119;
    private static final int FUNC_RIGHT = 120;
    private static final int FUNC_ROUND = 121;
    private static final int FUNC_ROUNDMAGIC = 122;
    private static final int FUNC_RPAD = 123;
    private static final int FUNC_RTRIM = 124;
    private static final int FUNC_SECONDS_MIDNIGHT = 125;
    private static final int FUNC_SEQUENCE_ARRAY = 126;
    private static final int FUNC_SESSION_ID = 127;
    private static final int FUNC_SESSION_ISOLATION_LEVEL = 128;
    private static final int FUNC_SESSION_TIMEZONE = 129;
    private static final int FUNC_SIGN = 130;
    private static final int FUNC_SIN = 131;
    private static final int FUNC_SOUNDEX = 132;
    private static final int FUNC_SORT_ARRAY = 133;
    private static final int FUNC_SPACE = 134;
    private static final int FUNC_SUBSTR = 135;
    private static final int FUNC_SYSDATE = 136;
    private static final int FUNC_TAN = 137;
    private static final int FUNC_TIMESTAMP = 138;
    private static final int FUNC_TIMESTAMPADD = 139;
    private static final int FUNC_TIMESTAMPDIFF = 140;
    private static final int FUNC_TIMEZONE = 141;
    private static final int FUNC_TO_CHAR = 142;
    private static final int FUNC_TO_DATE = 143;
    private static final int FUNC_TO_NUMBER = 144;
    private static final int FUNC_TO_TIMESTAMP = 145;
    private static final int FUNC_TRANSACTION_CONTROL = 146;
    private static final int FUNC_TRANSACTION_ID = 147;
    private static final int FUNC_TRANSACTION_SIZE = 148;
    private static final int FUNC_TRUNC = 149;
    private static final int FUNC_TRUNCATE = 150;
    private static final int FUNC_UUID = 151;
    private static final int FUNC_UNIX_TIMESTAMP = 152;
    static final IntKeyIntValueHashMap customRegularFuncMap = new IntKeyIntValueHashMap();
    static final IntKeyIntValueHashMap customValueFuncMap;
    private int extractSpec;
    private Pattern pattern;

    public static FunctionSQL newCustomFunction(String string, int n) {
        int n2 = customRegularFuncMap.get(n, -1);
        if (n2 == -1) {
            n2 = customValueFuncMap.get(n, -1);
        }
        if (n2 == -1) {
            return null;
        }
        switch (n) {
            case 431: 
            case 649: 
            case 687: 
            case 692: 
            case 703: 
            case 730: 
            case 739: 
            case 755: {
                return new FunctionSQL(n2);
            }
            case 702: {
                FunctionSQL functionSQL = new FunctionSQL(n2);
                functionSQL.parseList = optionalNoParamList;
                return functionSQL;
            }
            case 657: 
            case 658: {
                FunctionSQL functionSQL = new FunctionSQL(n2);
                functionSQL.parseList = emptyParamList;
                return functionSQL;
            }
            case 729: {
                FunctionSQL functionSQL = new FunctionSQL(n2);
                functionSQL.parseList = tripleParamList;
                return functionSQL;
            }
        }
        FunctionCustom functionCustom = new FunctionCustom(n2);
        if (n2 == 31) {
            switch (n) {
                case 695: {
                    functionCustom.extractSpec = 151;
                    break;
                }
                case 717: {
                    functionCustom.extractSpec = 286;
                }
            }
        }
        if (n2 == 5) {
            switch (n) {
                case 669: {
                    functionCustom.extractSpec = 665;
                    break;
                }
                case 698: {
                    functionCustom.extractSpec = 697;
                    break;
                }
                case 670: {
                    functionCustom.extractSpec = 666;
                    break;
                }
                case 671: {
                    functionCustom.extractSpec = 667;
                    break;
                }
                case 672: {
                    functionCustom.extractSpec = 668;
                    break;
                }
                case 758: {
                    functionCustom.extractSpec = 759;
                    break;
                }
                default: {
                    functionCustom.extractSpec = n;
                }
            }
        }
        if (functionCustom.name == null) {
            functionCustom.name = string;
        }
        return functionCustom;
    }

    public static boolean isRegularFunction(int n) {
        return customRegularFuncMap.get(n, -1) != -1;
    }

    public static boolean isValueFunction(int n) {
        return customValueFuncMap.get(n, -1) != -1;
    }

    private FunctionCustom(int n) {
        this.funcType = n;
        this.isDeterministic = !nonDeterministicFuncSet.contains(n);
        switch (n) {
            case 72: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 109: 
            case 127: 
            case 128: 
            case 129: 
            case 141: 
            case 146: 
            case 147: 
            case 148: {
                this.parseList = emptyParamList;
                break;
            }
            case 71: 
            case 73: 
            case 74: 
            case 75: 
            case 80: 
            case 82: 
            case 83: 
            case 92: 
            case 95: 
            case 104: 
            case 106: 
            case 111: 
            case 113: 
            case 119: 
            case 122: 
            case 130: 
            case 131: 
            case 132: 
            case 134: 
            case 137: 
            case 144: {
                this.parseList = singleParamList;
                break;
            }
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 81: 
            case 84: 
            case 94: 
            case 102: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 120: 
            case 142: 
            case 143: 
            case 145: {
                this.parseList = doubleParamList;
                break;
            }
            case 90: 
            case 91: 
            case 118: 
            case 126: {
                this.parseList = tripleParamList;
                break;
            }
            case 1: 
            case 107: 
            case 123: {
                this.parseList = new short[]{786, 788, 774, 788, 842, 2, 774, 788, 772};
                break;
            }
            case 151: 
            case 152: {
                this.parseList = optionalSingleParamList;
                break;
            }
            case 5: {
                this.name = "EXTRACT";
                this.parseList = singleParamList;
                break;
            }
            case 31: {
                this.name = "TRIM";
                this.parseList = singleParamList;
                break;
            }
            case 32: {
                this.name = "OVERLAY";
                this.parseList = quadParamList;
                break;
            }
            case 96: {
                this.name = "IDENTITY";
                this.parseList = emptyParamList;
                break;
            }
            case 93: {
                this.parseList = new short[]{786, 495, 772};
                break;
            }
            case 110: {
                this.parseList = new short[]{786, 788, 130, 788, 842, 2, 115, 788, 772};
                break;
            }
            case 133: {
                this.parseList = new short[]{786, 788, 842, 4, 841, 2, 338, 389, 842, 5, 451, 841, 2, 401, 430, 772};
                break;
            }
            case 139: {
                this.name = "TIMESTAMPADD";
                this.parseList = new short[]{786, 841, 10, 831, 832, 833, 834, 835, 836, 837, 838, 839, 840, 774, 788, 774, 788, 772};
                break;
            }
            case 140: {
                this.name = "TIMESTAMPDIFF";
                this.parseList = new short[]{786, 841, 10, 831, 832, 833, 834, 835, 836, 837, 838, 839, 840, 774, 788, 774, 788, 772};
                break;
            }
            case 103: 
            case 121: 
            case 138: 
            case 149: 
            case 150: {
                this.parseList = new short[]{786, 788, 842, 2, 774, 788, 772};
                break;
            }
            case 112: {
                this.parseList = optionalSingleParamList;
                break;
            }
            default: {
                throw Error.runtimeError(201, "FunctionCustom");
            }
        }
    }

    @Override
    public void setArguments(Expression[] expressionArray) {
        switch (this.funcType) {
            case 1: {
                Expression[] expressionArray2 = new Expression[4];
                expressionArray2[0] = expressionArray[0];
                expressionArray2[1] = expressionArray[1];
                expressionArray2[3] = expressionArray[2];
                expressionArray = expressionArray2;
                break;
            }
            case 32: {
                Expression expression = expressionArray[1];
                Expression expression2 = expressionArray[2];
                expressionArray[1] = expressionArray[3];
                expressionArray[2] = expression;
                expressionArray[3] = expression2;
                break;
            }
            case 5: {
                Expression[] expressionArray3 = new Expression[]{new ExpressionValue(ValuePool.getInt(this.extractSpec), Type.SQL_INTEGER), expressionArray[0]};
                expressionArray = expressionArray3;
                break;
            }
            case 31: {
                Expression[] expressionArray4 = new Expression[]{new ExpressionValue(ValuePool.getInt(this.extractSpec), Type.SQL_INTEGER), new ExpressionValue(" ", Type.SQL_CHAR), expressionArray[0]};
                expressionArray = expressionArray4;
            }
        }
        super.setArguments(expressionArray);
    }

    @Override
    public Expression getFunctionExpression() {
        switch (this.funcType) {
            case 81: {
                return new ExpressionArithmetic(36, this.nodes[0], this.nodes[1]);
            }
        }
        return super.getFunctionExpression();
    }

    @Override
    Object getValue(Session session, Object[] objectArray) {
        switch (this.funcType) {
            case 1: 
            case 5: 
            case 31: 
            case 32: {
                return super.getValue(session, objectArray);
            }
            case 85: {
                return session.getDatabase().getPath();
            }
            case 87: {
                return session.getDatabase().getUniqueName();
            }
            case 97: {
                return session.isAutoCommit() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 101: {
                return session.isReadOnlyDefault() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 99: {
                return session.getDatabase().databaseReadOnly ? Boolean.TRUE : Boolean.FALSE;
            }
            case 100: {
                return session.getDatabase().isFilesReadOnly() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 98: {
                return Session.getIsolationString(session.isolationLevel);
            }
            case 128: {
                return Session.getIsolationString(session.isolationLevelDefault);
            }
            case 86: {
                return Session.getIsolationString(session.database.defaultIsolationLevel);
            }
            case 146: {
                switch (session.database.txManager.getTransactionControl()) {
                    case 2: {
                        return "MVCC";
                    }
                    case 1: {
                        return "MVLOCKS";
                    }
                }
                return "LOCKS";
            }
            case 141: {
                return new IntervalSecondData(session.getZoneSeconds(), 0);
            }
            case 129: {
                return new IntervalSecondData(session.sessionTimeZoneSeconds, 0);
            }
            case 88: {
                int n = HsqlDateTime.getZoneSeconds(HsqlDateTime.tempCalDefault);
                return new IntervalSecondData(n, 0);
            }
            case 89: {
                return "2.2.4";
            }
            case 127: {
                return session.getId();
            }
            case 72: {
                return session.actionTimestamp;
            }
            case 147: {
                return session.transactionTimestamp;
            }
            case 148: {
                return (long)session.actionIndex;
            }
            case 104: {
                LobData lobData = (LobData)objectArray[0];
                if (lobData == null) {
                    return null;
                }
                return lobData.getId();
            }
            case 96: {
                Number number = session.getLastIdentity();
                if (number instanceof Long) {
                    return number;
                }
                return ValuePool.getLong(number.longValue());
            }
            case 93: {
                return session.sessionContext.diagnosticsVariables[this.exprSubType];
            }
            case 126: {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] != null) continue;
                    return null;
                }
                HsqlArrayList hsqlArrayList = new HsqlArrayList();
                Object object = objectArray[0];
                Type type = this.nodes[0].getDataType();
                boolean bl = type.compare(session, objectArray[1], objectArray[0]) >= 0;
                while (true) {
                    int n = type.compare(session, object, objectArray[1]);
                    if (bl ? n > 0 : n < 0) break;
                    hsqlArrayList.add(object);
                    Object object2 = type.add(object, objectArray[2], this.nodes[2].getDataType());
                    n = type.compare(session, object, object2);
                    if (bl ? n >= 0 : n <= 0) break;
                    object = object2;
                }
                Object[] objectArray2 = hsqlArrayList.toArray();
                return objectArray2;
            }
            case 139: {
                if (objectArray[1] == null || objectArray[2] == null) {
                    return null;
                }
                objectArray[1] = Type.SQL_BIGINT.convertToType(session, objectArray[1], this.nodes[1].getDataType());
                int n = ((Number)this.nodes[0].valueData).intValue();
                long l = ((Number)objectArray[1]).longValue();
                TimestampData timestampData = (TimestampData)objectArray[2];
                switch (n) {
                    case 831: {
                        long l2 = l / 1000000000L;
                        int n2 = (int)(l % 1000000000L);
                        IntervalType intervalType = Type.SQL_INTERVAL_SECOND_MAX_FRACTION;
                        IntervalSecondData intervalSecondData = new IntervalSecondData(l2, n2, intervalType);
                        return this.dataType.add(timestampData, intervalSecondData, intervalType);
                    }
                    case 832: {
                        long l3 = l / 1000L;
                        int n3 = (int)(l % 1000L) * 1000000;
                        IntervalType intervalType = Type.SQL_INTERVAL_SECOND_MAX_FRACTION;
                        IntervalSecondData intervalSecondData = new IntervalSecondData(l3, n3, intervalType);
                        return this.dataType.add(timestampData, intervalSecondData, intervalType);
                    }
                    case 833: {
                        IntervalType intervalType = Type.SQL_INTERVAL_SECOND_MAX_PRECISION;
                        IntervalSecondData intervalSecondData = IntervalSecondData.newIntervalSeconds(l, intervalType);
                        return this.dataType.add(timestampData, intervalSecondData, intervalType);
                    }
                    case 834: {
                        IntervalType intervalType = Type.SQL_INTERVAL_MINUTE_MAX_PRECISION;
                        IntervalSecondData intervalSecondData = IntervalSecondData.newIntervalMinute(l, intervalType);
                        return this.dataType.add(timestampData, intervalSecondData, intervalType);
                    }
                    case 835: {
                        IntervalType intervalType = Type.SQL_INTERVAL_HOUR_MAX_PRECISION;
                        IntervalSecondData intervalSecondData = IntervalSecondData.newIntervalHour(l, intervalType);
                        return this.dataType.add(timestampData, intervalSecondData, intervalType);
                    }
                    case 836: {
                        IntervalType intervalType = Type.SQL_INTERVAL_DAY_MAX_PRECISION;
                        IntervalSecondData intervalSecondData = IntervalSecondData.newIntervalDay(l, intervalType);
                        return this.dataType.add(timestampData, intervalSecondData, intervalType);
                    }
                    case 837: {
                        IntervalType intervalType = Type.SQL_INTERVAL_DAY_MAX_PRECISION;
                        IntervalSecondData intervalSecondData = IntervalSecondData.newIntervalDay(l * 7L, intervalType);
                        return this.dataType.add(timestampData, intervalSecondData, intervalType);
                    }
                    case 838: {
                        IntervalType intervalType = Type.SQL_INTERVAL_MONTH_MAX_PRECISION;
                        IntervalMonthData intervalMonthData = IntervalMonthData.newIntervalMonth(l, intervalType);
                        return this.dataType.add(timestampData, intervalMonthData, intervalType);
                    }
                    case 839: {
                        IntervalType intervalType = Type.SQL_INTERVAL_MONTH_MAX_PRECISION;
                        IntervalMonthData intervalMonthData = IntervalMonthData.newIntervalMonth(l * 3L, intervalType);
                        return this.dataType.add(timestampData, intervalMonthData, intervalType);
                    }
                    case 840: {
                        IntervalType intervalType = Type.SQL_INTERVAL_YEAR_MAX_PRECISION;
                        IntervalMonthData intervalMonthData = IntervalMonthData.newIntervalMonth(l * 12L, intervalType);
                        return this.dataType.add(timestampData, intervalMonthData, intervalType);
                    }
                }
                throw Error.runtimeError(201, "FunctionCustom");
            }
            case 140: {
                if (objectArray[1] == null || objectArray[2] == null) {
                    return null;
                }
                int n = ((Number)this.nodes[0].valueData).intValue();
                TimestampData timestampData = (TimestampData)objectArray[2];
                TimestampData timestampData2 = (TimestampData)objectArray[1];
                if (this.nodes[2].dataType.isDateTimeTypeWithZone()) {
                    timestampData = (TimestampData)Type.SQL_TIMESTAMP.convertToType(session, timestampData, Type.SQL_TIMESTAMP_WITH_TIME_ZONE);
                }
                if (this.nodes[1].dataType.isDateTimeTypeWithZone()) {
                    timestampData2 = (TimestampData)Type.SQL_TIMESTAMP.convertToType(session, timestampData2, Type.SQL_TIMESTAMP_WITH_TIME_ZONE);
                }
                switch (n) {
                    case 831: {
                        IntervalType intervalType = Type.SQL_INTERVAL_SECOND_MAX_PRECISION;
                        IntervalSecondData intervalSecondData = (IntervalSecondData)intervalType.subtract(timestampData, timestampData2, null);
                        return new Long(1000000000L * intervalSecondData.getSeconds() + (long)intervalSecondData.getNanos());
                    }
                    case 832: {
                        IntervalType intervalType = Type.SQL_INTERVAL_SECOND_MAX_PRECISION;
                        IntervalSecondData intervalSecondData = (IntervalSecondData)intervalType.subtract(timestampData, timestampData2, null);
                        return new Long(1000L * intervalSecondData.getSeconds() + (long)(intervalSecondData.getNanos() / 1000000));
                    }
                    case 833: {
                        IntervalType intervalType = Type.SQL_INTERVAL_SECOND_MAX_PRECISION;
                        return new Long(intervalType.convertToLong(intervalType.subtract(timestampData, timestampData2, null)));
                    }
                    case 834: {
                        IntervalType intervalType = Type.SQL_INTERVAL_MINUTE_MAX_PRECISION;
                        return new Long(intervalType.convertToLong(intervalType.subtract(timestampData, timestampData2, null)));
                    }
                    case 835: {
                        IntervalType intervalType = Type.SQL_INTERVAL_HOUR_MAX_PRECISION;
                        return new Long(intervalType.convertToLong(intervalType.subtract(timestampData, timestampData2, null)));
                    }
                    case 836: {
                        IntervalType intervalType = Type.SQL_INTERVAL_DAY_MAX_PRECISION;
                        return new Long(intervalType.convertToLong(intervalType.subtract(timestampData, timestampData2, null)));
                    }
                    case 837: {
                        IntervalType intervalType = Type.SQL_INTERVAL_DAY_MAX_PRECISION;
                        return new Long(intervalType.convertToLong(intervalType.subtract(timestampData, timestampData2, null)) / 7L);
                    }
                    case 838: {
                        IntervalType intervalType = Type.SQL_INTERVAL_MONTH_MAX_PRECISION;
                        return new Long(intervalType.convertToLong(intervalType.subtract(timestampData, timestampData2, null)));
                    }
                    case 839: {
                        IntervalType intervalType = Type.SQL_INTERVAL_MONTH_MAX_PRECISION;
                        return new Long(intervalType.convertToLong(intervalType.subtract(timestampData, timestampData2, null)) / 3L);
                    }
                    case 840: {
                        IntervalType intervalType = Type.SQL_INTERVAL_YEAR_MAX_PRECISION;
                        return new Long(intervalType.convertToLong(intervalType.subtract(timestampData, timestampData2, null)));
                    }
                }
                throw Error.runtimeError(201, "FunctionCustom");
            }
            case 121: 
            case 149: {
                int n = 103;
                if (objectArray[0] == null) {
                    return null;
                }
                if (this.dataType.isDateTimeType()) {
                    DateTimeType dateTimeType = (DateTimeType)this.dataType;
                    if (this.nodes.length > 1 && this.nodes[1] != null) {
                        if (objectArray[1] == null) {
                            return null;
                        }
                        n = HsqlDateTime.toStandardIntervalPart((String)objectArray[1]);
                    }
                    if (n < 0) {
                        throw Error.error(5566, (String)objectArray[1]);
                    }
                    return this.funcType == 121 ? dateTimeType.round(objectArray[0], n) : dateTimeType.truncate(objectArray[0], n);
                }
            }
            case 150: {
                int n = 0;
                if (objectArray[0] == null) {
                    return null;
                }
                if (this.nodes.length > 1) {
                    if (objectArray[1] == null) {
                        return null;
                    }
                    objectArray[1] = Type.SQL_INTEGER.convertToType(session, objectArray[1], this.nodes[1].getDataType());
                    n = ((Number)objectArray[1]).intValue();
                }
                return this.funcType == 121 ? ((NumberType)this.dataType).round(objectArray[0], n) : ((NumberType)this.dataType).truncate(objectArray[0], n);
            }
            case 142: {
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
                SimpleDateFormat simpleDateFormat = session.getSimpleDateFormatGMT();
                Date date = (Date)((DateTimeType)this.nodes[0].dataType).convertSQLToJavaGMT(session, objectArray[0]);
                return HsqlDateTime.toFormattedDate(date, (String)objectArray[1], simpleDateFormat);
            }
            case 144: {
                if (objectArray[0] == null) {
                    return null;
                }
                return this.dataType.convertToType(session, objectArray[0], this.nodes[0].dataType);
            }
            case 143: 
            case 145: {
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
                SimpleDateFormat simpleDateFormat = session.getSimpleDateFormatGMT();
                Date date = HsqlDateTime.toDate((String)objectArray[0], (String)objectArray[1], simpleDateFormat);
                long l = date.getTime();
                int n = 0;
                if (this.funcType == 143) {
                    l = HsqlDateTime.convertToNormalisedDate(l, simpleDateFormat.getCalendar());
                } else {
                    n = (int)(l % 1000L) * 100000;
                }
                return new TimestampData(l / 1000L, n);
            }
            case 138: {
                boolean bl;
                boolean bl2 = bl = this.nodes[1] == null;
                if (objectArray[0] == null) {
                    return null;
                }
                if (bl) {
                    return Type.SQL_TIMESTAMP.convertToType(session, objectArray[0], this.nodes[0].dataType);
                }
                if (objectArray[1] == null) {
                    return null;
                }
                TimestampData timestampData = (TimestampData)Type.SQL_DATE.convertToType(session, objectArray[0], this.nodes[0].dataType);
                TimeData timeData = (TimeData)Type.SQL_TIME.convertToType(session, objectArray[1], this.nodes[1].dataType);
                return new TimestampData(timestampData.getSeconds() + (long)timeData.getSeconds(), timeData.getNanos());
            }
            case 109: {
                return new Double(Math.PI);
            }
            case 112: {
                if (this.nodes[0] == null) {
                    return new Double(session.random());
                }
                objectArray[0] = Type.SQL_BIGINT.convertToType(session, objectArray[0], this.nodes[0].getDataType());
                long l = ((Number)objectArray[0]).longValue();
                return new Double(session.random(l));
            }
            case 151: {
                if (this.nodes[0] == null) {
                    UUID uUID = UUID.randomUUID();
                    long l = uUID.getMostSignificantBits();
                    long l4 = uUID.getLeastSignificantBits();
                    return new BinaryData(ArrayUtil.toByteArray(l, l4), false);
                }
                if (objectArray[0] == null) {
                    return null;
                }
                if (this.dataType.isBinaryType()) {
                    return new BinaryData(StringConverter.toBinaryUUID((String)objectArray[0]), false);
                }
                return StringConverter.toStringUUID(((BinaryData)objectArray[0]).getBytes());
            }
            case 152: {
                if (this.nodes[0] == null) {
                    TimestampData timestampData = session.getCurrentTimestamp(false);
                    return timestampData.getSeconds();
                }
                if (objectArray[0] == null) {
                    return null;
                }
                return ((TimestampData)objectArray[0]).getSeconds();
            }
            case 71: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return new Double(Math.acos(d));
            }
            case 74: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return new Double(Math.asin(d));
            }
            case 75: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return new Double(Math.atan(d));
            }
            case 82: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return new Double(Math.cos(d));
            }
            case 83: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                double d2 = 1.0 / Math.tan(d);
                return new Double(d2);
            }
            case 92: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return new Double(Math.toDegrees(d));
            }
            case 131: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return new Double(Math.sin(d));
            }
            case 137: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return new Double(Math.tan(d));
            }
            case 106: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return new Double(Math.log10(d));
            }
            case 111: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return new Double(Math.toRadians(d));
            }
            case 130: {
                if (objectArray[0] == null) {
                    return null;
                }
                int n = ((NumberType)this.nodes[0].dataType).compareToZero(objectArray[0]);
                return ValuePool.getInt(n);
            }
            case 76: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                double d3 = NumberType.toDouble(objectArray[1]);
                return new Double(Math.atan2(d, d3));
            }
            case 73: {
                if (objectArray[0] == null) {
                    return null;
                }
                String string = this.nodes[0].dataType.isLobType() ? ((ClobData)objectArray[0]).getSubString(session, 0L, 1) : (String)objectArray[0];
                if (string.length() == 0) {
                    return null;
                }
                return ValuePool.getInt(string.charAt(0));
            }
            case 80: {
                if (objectArray[0] == null) {
                    return null;
                }
                objectArray[0] = Type.SQL_INTEGER.convertToType(session, objectArray[0], this.nodes[0].getDataType());
                int n = ((Number)objectArray[0]).intValue();
                if (Character.isValidCodePoint(n) && Character.isValidCodePoint((char)n)) {
                    return String.valueOf((char)n);
                }
                throw Error.error(3472);
            }
            case 122: {
                int n = 0;
                if (objectArray[0] == null) {
                    return null;
                }
                if (this.nodes.length > 1) {
                    if (objectArray[1] == null) {
                        return null;
                    }
                    n = ((Number)objectArray[1]).intValue();
                }
                return ((NumberType)this.dataType).round(objectArray[0], n);
            }
            case 132: {
                if (objectArray[0] == null) {
                    return null;
                }
                String string = (String)objectArray[0];
                return new String(FunctionCustom.soundex(string), 0, 4);
            }
            case 77: 
            case 78: 
            case 79: {
                byte[] byArray;
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] != null) continue;
                    return null;
                }
                if (this.dataType.isNumberType()) {
                    objectArray[0] = Type.SQL_BIGINT.convertToType(session, objectArray[0], this.nodes[0].getDataType());
                    objectArray[1] = Type.SQL_BIGINT.convertToType(session, objectArray[1], this.nodes[1].getDataType());
                    long l = 0L;
                    long l5 = ((Number)objectArray[0]).longValue();
                    long l6 = ((Number)objectArray[1]).longValue();
                    switch (this.funcType) {
                        case 77: {
                            l = l5 & l6;
                            break;
                        }
                        case 78: {
                            l = l5 | l6;
                            break;
                        }
                        case 79: {
                            l = l5 ^ l6;
                        }
                    }
                    switch (this.dataType.typeCode) {
                        case 2: 
                        case 3: {
                            return BigDecimal.valueOf(l);
                        }
                        case 25: {
                            return ValuePool.getLong(l);
                        }
                        case 4: {
                            return ValuePool.getInt((int)l);
                        }
                        case 5: {
                            return ValuePool.getInt((int)l & 0xFFFF);
                        }
                        case -6: {
                            return ValuePool.getInt((int)l & 0xFF);
                        }
                    }
                    throw Error.error(5561);
                }
                byte[] byArray2 = ((BinaryData)objectArray[0]).getBytes();
                byte[] byArray3 = ((BinaryData)objectArray[1]).getBytes();
                switch (this.funcType) {
                    case 77: {
                        byArray = BitMap.and(byArray2, byArray3);
                        break;
                    }
                    case 78: {
                        byArray = BitMap.or(byArray2, byArray3);
                        break;
                    }
                    case 79: {
                        byArray = BitMap.xor(byArray2, byArray3);
                        break;
                    }
                    default: {
                        throw Error.error(5561);
                    }
                }
                return new BinaryData(byArray, this.dataType.precision);
            }
            case 94: {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] != null) continue;
                    return null;
                }
                char[] cArray = FunctionCustom.soundex((String)objectArray[0]);
                char[] cArray2 = FunctionCustom.soundex((String)objectArray[1]);
                int n = 0;
                if (cArray[0] == cArray2[0]) {
                    ++n;
                }
                if (n == 4) {
                    return ValuePool.getInt(n);
                }
                int n4 = 1;
                for (int i = 1; i < 4; ++i) {
                    for (int j = n4; j < 4; ++j) {
                        if (cArray[j] != cArray2[i]) continue;
                        ++n;
                        ++i;
                        ++n4;
                    }
                }
                n = 0;
                return ValuePool.getInt(n);
            }
            case 95: {
                if (objectArray[0] == null) {
                    return null;
                }
                return this.dataType.convertToType(session, objectArray[0], this.nodes[0].dataType);
            }
            case 113: {
                if (objectArray[0] == null) {
                    return null;
                }
                BlobData blobData = (BlobData)objectArray[0];
                byte[] byArray = blobData.getBytes(session, 0L, (int)blobData.length(session));
                return StringConverter.byteArrayToHexString(byArray);
            }
            case 117: {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] != null) continue;
                    return null;
                }
                objectArray[1] = Type.SQL_INTEGER.convertToType(session, objectArray[1], this.nodes[1].getDataType());
                String string = (String)objectArray[0];
                int n = ((Number)objectArray[1]).intValue();
                StringBuffer stringBuffer = new StringBuffer(string.length() * n);
                while (n-- > 0) {
                    stringBuffer.append(string);
                }
                return stringBuffer.toString();
            }
            case 118: {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] != null) continue;
                    return null;
                }
                String string = (String)objectArray[0];
                String string2 = (String)objectArray[1];
                String string3 = (String)objectArray[2];
                StringBuffer stringBuffer = new StringBuffer();
                int n = 0;
                while (true) {
                    int n5;
                    if ((n5 = string.indexOf(string2, n)) == -1) break;
                    stringBuffer.append(string.substring(n, n5));
                    stringBuffer.append(string3);
                    n = n5 + string2.length();
                }
                stringBuffer.append(string.substring(n));
                return stringBuffer.toString();
            }
            case 102: 
            case 120: {
                int n;
                for (n = 0; n < objectArray.length; ++n) {
                    if (objectArray[n] != null) continue;
                    return null;
                }
                n = ((Number)objectArray[1]).intValue();
                return ((CharacterType)this.dataType).substring(session, objectArray[0], 0L, n, true, this.funcType == 120);
            }
            case 134: {
                if (objectArray[0] == null) {
                    return null;
                }
                objectArray[0] = Type.SQL_INTEGER.convertToType(session, objectArray[0], this.nodes[0].getDataType());
                int n = ((Number)objectArray[0]).intValue();
                char[] cArray = new char[n];
                ArrayUtil.fillArray(cArray, 0, ' ');
                return String.valueOf(cArray);
            }
            case 119: {
                if (objectArray[0] == null) {
                    return null;
                }
                StringBuffer stringBuffer = new StringBuffer((String)objectArray[0]);
                stringBuffer = stringBuffer.reverse();
                return stringBuffer.toString();
            }
            case 114: 
            case 115: 
            case 116: {
                Object object;
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] != null) continue;
                    return null;
                }
                Object object3 = this.pattern;
                if (object3 == null) {
                    object = (String)objectArray[1];
                    object3 = Pattern.compile((String)object);
                }
                object = ((Pattern)object3).matcher((String)objectArray[0]);
                switch (this.funcType) {
                    case 114: {
                        boolean bl = ((Matcher)object).matches();
                        return bl;
                    }
                    case 115: {
                        boolean bl = ((Matcher)object).find();
                        if (bl) {
                            return ((Matcher)object).group();
                        }
                        return null;
                    }
                    case 116: {
                        HsqlArrayList hsqlArrayList = new HsqlArrayList();
                        while (((Matcher)object).find()) {
                            hsqlArrayList.add(((Matcher)object).group());
                        }
                        return hsqlArrayList.toArray();
                    }
                }
            }
            case 84: {
                Object object3 = Crypto.getNewKey((String)objectArray[0], (String)objectArray[1]);
                return StringConverter.byteArrayToHexString((byte[])object3);
            }
            case 103: {
                String string = (String)objectArray[0];
                if (string == null) {
                    return null;
                }
                switch (this.dataType.typeCode) {
                    case 40: {
                        return session.sessionData.createClobFromFile(string, (String)objectArray[1]);
                    }
                }
                return session.sessionData.createBlobFromFile(string);
            }
            case 107: 
            case 123: {
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
                String string = this.nodes[0].dataType.isCharacterType() && !this.nodes[0].dataType.isLobType() ? (String)objectArray[0] : this.nodes[0].dataType.convertToString(objectArray[0]);
                int n = (Integer)Type.SQL_INTEGER.convertToType(session, objectArray[1], this.nodes[1].dataType);
                String string4 = " ";
                if (this.nodes[2] != null && (string4 = this.nodes[2].dataType.convertToString(objectArray[2])).length() == 0) {
                    string4 = " ";
                }
                string = (String)Type.SQL_VARCHAR.trim(session, string, 32, true, true);
                string = StringUtil.toPaddedString(string, n, string4, this.funcType == 123);
                if (this.dataType.isLobType()) {
                    return this.dataType.convertToType(session, string, Type.SQL_VARCHAR);
                }
                return string;
            }
            case 110: {
                if (objectArray[1] == null) {
                    return null;
                }
                if (objectArray[2] == null) {
                    return null;
                }
                Object[] objectArray3 = (Object[])objectArray[1];
                ArrayType arrayType = (ArrayType)this.nodes[1].dataType;
                Type type = arrayType.collectionBaseType();
                int n = ((Number)Type.SQL_INTEGER.convertToType(session, objectArray[2], this.nodes[2].dataType)).intValue();
                if (n <= 0) {
                    throw Error.error(3403);
                }
                for (int i = --n; i < objectArray3.length; ++i) {
                    if (type.compare(session, objectArray[0], objectArray3[i]) != 0) continue;
                    return ValuePool.getInt(i + 1);
                }
                return ValuePool.INTEGER_0;
            }
            case 133: {
                if (objectArray[0] == null) {
                    return null;
                }
                ArrayType arrayType = (ArrayType)this.dataType;
                SortAndSlice sortAndSlice = new SortAndSlice();
                sortAndSlice.prepareSingleColumn(1);
                sortAndSlice.sortDescending[0] = ((Number)objectArray[1]).intValue() == 389;
                sortAndSlice.sortNullsLast[0] = ((Number)objectArray[2]).intValue() == 430;
                Object object = ArrayUtil.duplicateArray(objectArray[0]);
                arrayType.sort(session, object, sortAndSlice);
                return object;
            }
        }
        throw Error.runtimeError(201, "FunctionCustom");
    }

    @Override
    public void resolveTypes(Session session, Expression expression) {
        int n;
        for (n = 0; n < this.nodes.length; ++n) {
            if (this.nodes[n] == null) continue;
            this.nodes[n].resolveTypes(session, this);
        }
        block0 : switch (this.funcType) {
            case 1: 
            case 5: 
            case 31: 
            case 32: {
                super.resolveTypes(session, expression);
                return;
            }
            case 85: {
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                return;
            }
            case 87: {
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                return;
            }
            case 97: 
            case 99: 
            case 100: 
            case 101: {
                this.dataType = Type.SQL_BOOLEAN;
                return;
            }
            case 86: 
            case 89: 
            case 98: 
            case 128: 
            case 146: {
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                return;
            }
            case 88: 
            case 129: 
            case 141: {
                this.dataType = Type.SQL_INTERVAL_HOUR_TO_MINUTE;
                return;
            }
            case 72: 
            case 96: 
            case 104: 
            case 127: 
            case 147: 
            case 148: {
                this.dataType = Type.SQL_BIGINT;
                return;
            }
            case 93: {
                this.exprSubType = 2;
                this.dataType = Type.SQL_INTEGER;
                return;
            }
            case 126: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = this.nodes[1].dataType;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = this.nodes[0].dataType;
                }
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_INTEGER;
                    this.nodes[1].dataType = Type.SQL_INTEGER;
                }
                if (this.nodes[0].dataType.isNumberType()) {
                    if (this.nodes[2].dataType == null) {
                        this.nodes[2].dataType = this.nodes[0].dataType;
                    }
                } else if (this.nodes[0].dataType.isDateTimeType()) {
                    if (this.nodes[2].dataType == null) {
                        throw Error.error(5561);
                    }
                    if (!this.nodes[2].dataType.isIntervalType()) {
                        throw Error.error(5561);
                    }
                }
                this.dataType = new ArrayType(this.nodes[0].getDataType(), 0x100000);
                return;
            }
            case 90: {
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                n = this.getTSIToken((String)this.nodes[0].valueData);
                this.nodes[0].valueData = ValuePool.getInt(n);
                this.nodes[0].dataType = Type.SQL_INTEGER;
                this.funcType = 139;
            }
            case 139: {
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_BIGINT;
                }
                if (this.nodes[2].dataType == null) {
                    this.nodes[2].dataType = Type.SQL_TIMESTAMP;
                }
                if (!this.nodes[1].dataType.isIntegralType()) {
                    throw Error.error(5561);
                }
                if (this.nodes[2].dataType.typeCode != 91 && this.nodes[2].dataType.typeCode != 93 && this.nodes[2].dataType.typeCode != 95) {
                    throw Error.error(5561);
                }
                this.dataType = this.nodes[2].dataType;
                return;
            }
            case 91: {
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5563);
                }
                n = this.getTSIToken((String)this.nodes[0].valueData);
                this.nodes[0].valueData = ValuePool.getInt(n);
                this.nodes[0].dataType = Type.SQL_INTEGER;
                this.funcType = 140;
            }
            case 140: {
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = this.nodes[2].dataType;
                }
                if (this.nodes[2].dataType == null) {
                    this.nodes[2].dataType = this.nodes[1].dataType;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_TIMESTAMP;
                    this.nodes[2].dataType = Type.SQL_TIMESTAMP;
                }
                block46 : switch (this.nodes[1].dataType.typeCode) {
                    case 91: {
                        if (this.nodes[2].dataType.typeCode != 91) {
                            throw Error.error(5563);
                        }
                        switch ((Integer)this.nodes[0].valueData) {
                            case 836: 
                            case 837: 
                            case 838: 
                            case 839: 
                            case 840: {
                                break block46;
                            }
                        }
                        throw Error.error(5563);
                    }
                    case 93: 
                    case 95: {
                        if (this.nodes[2].dataType.typeCode == 93 || this.nodes[2].dataType.typeCode == 95) break;
                        throw Error.error(5563);
                    }
                    default: {
                        throw Error.error(5563);
                    }
                }
                this.dataType = Type.SQL_BIGINT;
                return;
            }
            case 121: 
            case 149: {
                int n2 = n = this.nodes.length == 1 || this.nodes[1] == null ? 1 : 0;
                if (this.nodes[0].dataType == null) {
                    if (n != 0) {
                        this.nodes[0].dataType = Type.SQL_DECIMAL;
                    } else {
                        if (this.nodes[1].dataType == null) {
                            this.nodes[1].dataType = Type.SQL_INTEGER;
                        }
                        this.nodes[0].dataType = this.nodes[1].dataType.isNumberType() ? Type.SQL_DECIMAL : Type.SQL_TIMESTAMP;
                    }
                }
                if (this.nodes[0].dataType.isDateTimeType()) {
                    if (n == 0 && !this.nodes[1].dataType.isCharacterType()) {
                        throw Error.error(5566);
                    }
                    this.dataType = this.nodes[0].dataType;
                    break;
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5561);
                }
            }
            case 150: {
                Number number = null;
                if (this.nodes[0].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5563);
                }
                if (this.nodes[1] == null) {
                    this.nodes[1] = new ExpressionValue(ValuePool.INTEGER_0, Type.SQL_INTEGER);
                    number = ValuePool.INTEGER_0;
                } else {
                    if (this.nodes[1].dataType == null) {
                        this.nodes[1].dataType = Type.SQL_INTEGER;
                    } else if (!this.nodes[1].dataType.isIntegralType()) {
                        throw Error.error(5563);
                    }
                    if (this.nodes[1].opType == 1) {
                        number = (Number)this.nodes[1].getValue(session);
                    }
                }
                this.dataType = this.nodes[0].dataType;
                if (number != null) {
                    int n3 = number;
                    if (n3 < 0) {
                        n3 = 0;
                    } else if (n3 > this.dataType.scale) {
                        n3 = this.dataType.scale;
                    }
                    if ((this.dataType.typeCode == 3 || this.dataType.typeCode == 2) && n3 != this.dataType.scale) {
                        this.dataType = new NumberType(this.dataType.typeCode, this.dataType.precision - (long)this.dataType.scale + (long)n3, n3);
                    }
                }
                return;
            }
            case 142: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_TIMESTAMP;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (!this.nodes[1].dataType.isCharacterType()) {
                    throw Error.error(5563);
                }
                if (!this.nodes[0].dataType.isDateTimeType()) {
                    throw Error.error(5563);
                }
                this.dataType = CharacterType.getCharacterType(12, 64L);
                return;
            }
            case 144: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_DECIMAL_DEFAULT;
                return;
            }
            case 143: 
            case 145: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (!this.nodes[0].dataType.isCharacterType() || !this.nodes[1].dataType.isCharacterType()) {
                    throw Error.error(5567);
                }
                this.dataType = this.funcType == 143 ? Type.SQL_DATE : Type.SQL_TIMESTAMP;
                return;
            }
            case 138: {
                Type type = this.nodes[0].dataType;
                if (this.nodes[1] == null) {
                    if (type == null) {
                        type = this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                    }
                    if (!type.isCharacterType() && type.typeCode != 93 && type.typeCode != 95) {
                        throw Error.error(5561);
                    }
                } else {
                    if (type == null) {
                        if (this.nodes[1].dataType == null) {
                            this.nodes[0].dataType = this.nodes[1].dataType = Type.SQL_VARCHAR_DEFAULT;
                            type = this.nodes[1].dataType;
                        } else {
                            type = this.nodes[1].dataType.isCharacterType() ? (this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT) : (this.nodes[0].dataType = Type.SQL_DATE);
                        }
                    }
                    if (this.nodes[1].dataType == null) {
                        if (type.isCharacterType()) {
                            this.nodes[1].dataType = Type.SQL_VARCHAR_DEFAULT;
                        } else if (type.typeCode == 91) {
                            this.nodes[1].dataType = Type.SQL_TIME;
                        }
                    }
                    if (!(type.typeCode == 91 && this.nodes[1].dataType.typeCode == 92 || type.isCharacterType() && this.nodes[1].dataType.isCharacterType())) {
                        throw Error.error(5561);
                    }
                }
                this.dataType = Type.SQL_TIMESTAMP;
                return;
            }
            case 109: {
                this.dataType = Type.SQL_DOUBLE;
                break;
            }
            case 151: {
                if (this.nodes[0] == null) {
                    this.dataType = Type.SQL_BINARY_16;
                    break;
                }
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                    this.dataType = Type.SQL_BINARY_16;
                    break;
                }
                if (this.nodes[0].dataType.isCharacterType()) {
                    this.dataType = Type.SQL_BINARY_16;
                    break;
                }
                if (this.nodes[0].dataType.isBinaryType() && !this.nodes[0].dataType.isLobType()) {
                    this.dataType = Type.SQL_CHAR_16;
                    break;
                }
                throw Error.error(5563);
            }
            case 152: {
                if (this.nodes[0] != null) {
                    if (this.nodes[0].dataType == null) {
                        this.nodes[0].dataType = Type.SQL_TIMESTAMP;
                    } else if (!this.nodes[0].dataType.isDateTimeType() || this.nodes[0].dataType.typeCode == 92 || this.nodes[0].dataType.typeCode == 94) {
                        throw Error.error(5563);
                    }
                }
                this.dataType = Type.SQL_BIGINT;
                break;
            }
            case 112: {
                if (this.nodes[0] != null) {
                    if (this.nodes[0].dataType == null) {
                        this.nodes[0].dataType = Type.SQL_BIGINT;
                    } else if (!this.nodes[0].dataType.isExactNumberType()) {
                        throw Error.error(5563);
                    }
                }
                this.dataType = Type.SQL_DOUBLE;
                break;
            }
            case 71: 
            case 74: 
            case 75: 
            case 82: 
            case 83: 
            case 92: 
            case 106: 
            case 111: 
            case 122: 
            case 131: 
            case 137: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DOUBLE;
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_DOUBLE;
                break;
            }
            case 130: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DOUBLE;
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_INTEGER;
                break;
            }
            case 76: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DOUBLE;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_DOUBLE;
                }
                if (!this.nodes[0].dataType.isNumberType() || !this.nodes[1].dataType.isNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_DOUBLE;
                break;
            }
            case 132: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                this.dataType = CharacterType.getCharacterType(12, 4L);
                break;
            }
            case 77: 
            case 78: 
            case 79: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = this.nodes[1].dataType;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = this.nodes[0].dataType;
                }
                for (n = 0; n < this.nodes.length; ++n) {
                    if (this.nodes[n].dataType != null) continue;
                    this.nodes[n].dataType = Type.SQL_INTEGER;
                }
                this.dataType = this.nodes[0].dataType.getAggregateType(this.nodes[1].dataType);
                switch (this.dataType.typeCode) {
                    case -6: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 8: 
                    case 25: {
                        break block0;
                    }
                    case 14: 
                    case 15: {
                        break block0;
                    }
                }
                throw Error.error(5561);
            }
            case 73: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_INTEGER;
                break;
            }
            case 80: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_INTEGER;
                }
                if (!this.nodes[0].dataType.isExactNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = CharacterType.getCharacterType(12, 1L);
                break;
            }
            case 94: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR;
                }
                this.dataType = Type.SQL_INTEGER;
                break;
            }
            case 95: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                this.dataType = this.nodes[0].dataType.precision == 0L ? Type.SQL_VARBINARY_DEFAULT : BinaryType.getBinaryType(61, this.nodes[0].dataType.precision / 2L);
                break;
            }
            case 113: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARBINARY;
                }
                if (!this.nodes[0].dataType.isBinaryType()) {
                    throw Error.error(5561);
                }
                this.dataType = this.nodes[0].dataType.precision == 0L ? Type.SQL_VARCHAR_DEFAULT : CharacterType.getCharacterType(12, this.nodes[0].dataType.precision * 2L);
                break;
            }
            case 117: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if ((n = (int)(this.nodes[0].dataType.isCharacterType() ? 1 : 0)) == 0 && !this.nodes[0].dataType.isBinaryType()) {
                    throw Error.error(5561);
                }
                if (!this.nodes[1].dataType.isExactNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = n != 0 ? Type.SQL_VARCHAR_DEFAULT : Type.SQL_VARBINARY_DEFAULT;
                break;
            }
            case 118: {
                for (n = 0; n < this.nodes.length; ++n) {
                    if (this.nodes[n].dataType == null) {
                        this.nodes[n].dataType = Type.SQL_VARCHAR;
                        continue;
                    }
                    if (this.nodes[n].dataType.isCharacterType()) continue;
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                break;
            }
            case 102: 
            case 120: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_INTEGER;
                }
                if (!this.nodes[1].dataType.isExactNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = this.nodes[0].dataType.precision == 0L ? Type.SQL_VARCHAR_DEFAULT : ((CharacterType)this.nodes[0].dataType).getCharacterType(this.nodes[0].dataType.precision);
                break;
            }
            case 134: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_INTEGER;
                }
                if (!this.nodes[0].dataType.isIntegralType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                break;
            }
            case 119: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                this.dataType = this.nodes[0].dataType;
                if (this.dataType.isCharacterType() && !this.dataType.isLobType()) break;
                throw Error.error(5561);
            }
            case 114: 
            case 115: 
            case 116: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (!this.nodes[0].dataType.isCharacterType() || !this.nodes[1].dataType.isCharacterType() || this.nodes[1].dataType.isLobType()) {
                    throw Error.error(5561);
                }
                if (this.nodes[1].exprSubType == 1) {
                    String string = (String)this.nodes[1].getValue(session);
                    this.pattern = Pattern.compile(string);
                }
                switch (this.funcType) {
                    case 114: {
                        this.dataType = Type.SQL_BOOLEAN;
                        break;
                    }
                    case 115: {
                        this.dataType = Type.SQL_VARCHAR_DEFAULT;
                        break;
                    }
                    case 116: {
                        this.dataType = Type.getDefaultArrayType(12);
                    }
                }
                break;
            }
            case 84: {
                for (n = 0; n < this.nodes.length; ++n) {
                    if (this.nodes[n].dataType == null) {
                        this.nodes[n].dataType = Type.SQL_VARCHAR;
                        continue;
                    }
                    if (this.nodes[n].dataType.isCharacterType()) continue;
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                break;
            }
            case 103: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                if (this.nodes[1] == null) {
                    this.dataType = Type.SQL_BLOB;
                    break;
                }
                this.dataType = Type.SQL_CLOB;
                if (this.nodes[1].dataType != null && this.nodes[1].dataType.isCharacterType()) break;
                throw Error.error(5561);
            }
            case 107: 
            case 123: {
                Number number;
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_INTEGER;
                }
                if (!this.nodes[1].dataType.isIntegralType()) {
                    throw Error.error(5561);
                }
                if (this.nodes[2] != null) {
                    if (this.nodes[2].dataType == null) {
                        this.nodes[2].dataType = Type.SQL_VARCHAR_DEFAULT;
                    }
                    if (!this.nodes[2].dataType.isCharacterType()) {
                        throw Error.error(5561);
                    }
                }
                this.dataType = this.nodes[0].dataType;
                if (this.dataType.typeCode != 40) {
                    this.dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (this.nodes[1].opType != 1 || (number = (Number)this.nodes[1].getValue(session)) == null) break;
                this.dataType = ((CharacterType)this.dataType).getCharacterType(number.longValue());
                break;
            }
            case 110: {
                if (this.nodes[1].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[1].dataType.isArrayType()) {
                    throw Error.error(5563);
                }
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = ((ArrayType)this.nodes[1].dataType).collectionBaseType();
                }
                if (((ArrayType)this.nodes[1].dataType).collectionBaseType().typeComparisonGroup != this.nodes[0].dataType.typeComparisonGroup) {
                    throw Error.error(5563);
                }
                if (this.nodes[2] == null) {
                    this.nodes[2] = new ExpressionValue(ValuePool.INTEGER_1, Type.SQL_INTEGER);
                }
                if (this.nodes[2].dataType == null) {
                    this.nodes[2].dataType = Type.SQL_INTEGER;
                }
                if (!this.nodes[2].dataType.isIntegralType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_INTEGER;
                break;
            }
            case 133: {
                if (this.nodes[0].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[0].dataType.isArrayType()) {
                    throw Error.error(5563);
                }
                if (this.nodes[1] == null) {
                    this.nodes[1] = new ExpressionValue(ValuePool.getInt(338), Type.SQL_INTEGER);
                }
                if (this.nodes[2] == null) {
                    this.nodes[2] = new ExpressionValue(ValuePool.getInt(401), Type.SQL_INTEGER);
                }
                this.dataType = this.nodes[0].dataType;
                break;
            }
            default: {
                throw Error.runtimeError(201, "FunctionCustom");
            }
        }
    }

    @Override
    public String getSQL() {
        switch (this.funcType) {
            case 1: {
                StringBuffer stringBuffer = new StringBuffer("LOCATE").append("(").append(this.nodes[0].getSQL()).append(",").append(this.nodes[1].getSQL());
                if (this.nodes.length > 3 && this.nodes[3] != null) {
                    stringBuffer.append(",").append(this.nodes[3].getSQL());
                }
                stringBuffer.append(")").toString();
                return stringBuffer.toString();
            }
            case 107: 
            case 123: {
                StringBuffer stringBuffer = new StringBuffer(this.name);
                stringBuffer.append("(").append(this.nodes[0].getSQL());
                stringBuffer.append(",").append(this.nodes[1].getSQL());
                if (this.nodes[2] != null) {
                    stringBuffer.append(",").append(this.nodes[2].getSQL());
                }
                stringBuffer.append(")").toString();
                return stringBuffer.toString();
            }
            case 5: 
            case 31: 
            case 32: {
                return super.getSQL();
            }
            case 110: {
                StringBuffer stringBuffer = new StringBuffer(this.name).append('(');
                stringBuffer.append(this.nodes[0].getSQL()).append(' ').append("IN");
                stringBuffer.append(' ').append(this.nodes[1].getSQL());
                if (((Number)this.nodes[1].valueData).intValue() == 389) {
                    stringBuffer.append(' ').append("FROM");
                    stringBuffer.append(' ').append(this.nodes[2].getSQL());
                }
                stringBuffer.append(')');
                return stringBuffer.toString();
            }
            case 133: {
                StringBuffer stringBuffer = new StringBuffer(this.name).append('(');
                stringBuffer.append(this.nodes[0].getSQL());
                if (((Number)this.nodes[1].valueData).intValue() == 389) {
                    stringBuffer.append(' ').append("DESC");
                }
                if (((Number)this.nodes[2].valueData).intValue() == 430) {
                    stringBuffer.append(' ').append("NULLS").append(' ');
                    stringBuffer.append("LAST");
                }
                stringBuffer.append(')');
                return stringBuffer.toString();
            }
            case 72: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 109: 
            case 127: 
            case 128: 
            case 129: 
            case 141: 
            case 146: 
            case 147: 
            case 148: {
                return new StringBuffer(this.name).append("(").append(")").toString();
            }
            case 139: {
                String string = Tokens.getSQLTSIString(((Number)this.nodes[0].getValue(null)).intValue());
                return new StringBuffer("TIMESTAMPADD").append("(").append(string).append(",").append(this.nodes[1].getSQL()).append(",").append(this.nodes[2].getSQL()).append(")").toString();
            }
            case 140: {
                String string = Tokens.getSQLTSIString(((Number)this.nodes[0].getValue(null)).intValue());
                return new StringBuffer("TIMESTAMPDIFF").append("(").append(string).append(",").append(this.nodes[1].getSQL()).append(",").append(this.nodes[2].getSQL()).append(")").toString();
            }
            case 112: 
            case 152: {
                StringBuffer stringBuffer = new StringBuffer(this.name).append('(');
                if (this.nodes[0] != null) {
                    stringBuffer.append(this.nodes[0].getSQL());
                }
                stringBuffer.append(')');
                return stringBuffer.toString();
            }
            case 103: 
            case 121: 
            case 144: 
            case 149: 
            case 150: {
                StringBuffer stringBuffer = new StringBuffer(this.name).append('(');
                stringBuffer.append(this.nodes[0].getSQL());
                if (this.nodes[0] != null) {
                    stringBuffer.append(',').append(this.nodes[0].getSQL());
                }
                stringBuffer.append(')');
                return stringBuffer.toString();
            }
            case 71: 
            case 73: 
            case 74: 
            case 75: 
            case 80: 
            case 82: 
            case 83: 
            case 92: 
            case 95: 
            case 104: 
            case 106: 
            case 111: 
            case 113: 
            case 119: 
            case 122: 
            case 130: 
            case 131: 
            case 132: 
            case 134: 
            case 137: {
                return new StringBuffer(this.name).append('(').append(this.nodes[0].getSQL()).append(')').toString();
            }
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 84: 
            case 94: 
            case 102: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 120: 
            case 138: 
            case 142: 
            case 143: 
            case 145: {
                return new StringBuffer(this.name).append('(').append(this.nodes[0].getSQL()).append(",").append(this.nodes[1].getSQL()).append(')').toString();
            }
            case 93: {
                StringBuffer stringBuffer = new StringBuffer(this.name).append('(');
                stringBuffer.append("ROW_COUNT");
                stringBuffer.append(')');
                return stringBuffer.toString();
            }
            case 118: 
            case 126: {
                return new StringBuffer(this.name).append('(').append(this.nodes[0].getSQL()).append(",").append(this.nodes[1].getSQL()).append(",").append(this.nodes[2].getSQL()).append(')').toString();
            }
        }
        return super.getSQL();
    }

    public static char[] soundex(String string) {
        if (string == null) {
            return null;
        }
        string = string.toUpperCase(Locale.ENGLISH);
        int n = string.length();
        char[] cArray = new char[]{'0', '0', '0', '0'};
        int n2 = 48;
        int n3 = 0;
        for (int i = 0; i < n && n3 < 4; ++i) {
            int n4;
            char c = string.charAt(i);
            if ("AEIOUY".indexOf(c) != -1) {
                n4 = 55;
            } else if (c == 'H' || c == 'W') {
                n4 = 56;
            } else if ("BFPV".indexOf(c) != -1) {
                n4 = 49;
            } else if ("CGJKQSXZ".indexOf(c) != -1) {
                n4 = 50;
            } else if (c == 'D' || c == 'T') {
                n4 = 51;
            } else if (c == 'L') {
                n4 = 52;
            } else if (c == 'M' || c == 'N') {
                n4 = 53;
            } else {
                if (c != 'R') continue;
                n4 = 54;
            }
            if (n3 == 0) {
                cArray[n3++] = c;
                n2 = n4;
                continue;
            }
            if (n4 <= 54) {
                if (n4 == n2) continue;
                cArray[n3++] = n4;
                n2 = n4;
                continue;
            }
            if (n4 != 55) continue;
            n2 = n4;
        }
        return cArray;
    }

    int getTSIToken(String string) {
        int n;
        if ("yy".equalsIgnoreCase(string)) {
            n = 840;
        } else if ("mm".equalsIgnoreCase(string)) {
            n = 838;
        } else if ("dd".equalsIgnoreCase(string)) {
            n = 836;
        } else if ("hh".equalsIgnoreCase(string)) {
            n = 835;
        } else if ("mi".equalsIgnoreCase(string)) {
            n = 834;
        } else if ("ss".equalsIgnoreCase(string)) {
            n = 833;
        } else if ("ms".equalsIgnoreCase(string)) {
            n = 832;
        } else {
            throw Error.error(5566, string);
        }
        return n;
    }

    static {
        nonDeterministicFuncSet.add(72);
        nonDeterministicFuncSet.add(84);
        nonDeterministicFuncSet.add(85);
        nonDeterministicFuncSet.add(86);
        nonDeterministicFuncSet.add(88);
        nonDeterministicFuncSet.add(96);
        nonDeterministicFuncSet.add(97);
        nonDeterministicFuncSet.add(101);
        nonDeterministicFuncSet.add(99);
        nonDeterministicFuncSet.add(100);
        nonDeterministicFuncSet.add(98);
        nonDeterministicFuncSet.add(127);
        nonDeterministicFuncSet.add(128);
        nonDeterministicFuncSet.add(129);
        nonDeterministicFuncSet.add(138);
        nonDeterministicFuncSet.add(141);
        nonDeterministicFuncSet.add(146);
        nonDeterministicFuncSet.add(147);
        nonDeterministicFuncSet.add(148);
        nonDeterministicFuncSet.add(151);
        nonDeterministicFuncSet.add(152);
        customRegularFuncMap.put(640, 71);
        customRegularFuncMap.put(641, 72);
        customRegularFuncMap.put(642, 133);
        customRegularFuncMap.put(643, 73);
        customRegularFuncMap.put(644, 74);
        customRegularFuncMap.put(645, 75);
        customRegularFuncMap.put(646, 76);
        customRegularFuncMap.put(648, 77);
        customRegularFuncMap.put(649, 6);
        customRegularFuncMap.put(650, 78);
        customRegularFuncMap.put(651, 79);
        customRegularFuncMap.put(33, 80);
        customRegularFuncMap.put(652, 80);
        customRegularFuncMap.put(653, 81);
        customRegularFuncMap.put(654, 82);
        customRegularFuncMap.put(655, 83);
        customRegularFuncMap.put(656, 84);
        customRegularFuncMap.put(657, 43);
        customRegularFuncMap.put(658, 51);
        customRegularFuncMap.put(580, 85);
        customRegularFuncMap.put(660, 87);
        customRegularFuncMap.put(659, 86);
        customRegularFuncMap.put(661, 88);
        customRegularFuncMap.put(662, 89);
        customRegularFuncMap.put(663, 90);
        customRegularFuncMap.put(664, 91);
        customRegularFuncMap.put(73, 5);
        customRegularFuncMap.put(669, 5);
        customRegularFuncMap.put(670, 5);
        customRegularFuncMap.put(671, 5);
        customRegularFuncMap.put(672, 5);
        customRegularFuncMap.put(674, 92);
        customRegularFuncMap.put(391, 93);
        customRegularFuncMap.put(675, 94);
        customRegularFuncMap.put(677, 95);
        customRegularFuncMap.put(127, 5);
        customRegularFuncMap.put(128, 96);
        customRegularFuncMap.put(135, 32);
        customRegularFuncMap.put(681, 97);
        customRegularFuncMap.put(682, 99);
        customRegularFuncMap.put(683, 100);
        customRegularFuncMap.put(684, 101);
        customRegularFuncMap.put(685, 98);
        customRegularFuncMap.put(687, 26);
        customRegularFuncMap.put(153, 102);
        customRegularFuncMap.put(431, 7);
        customRegularFuncMap.put(689, 103);
        customRegularFuncMap.put(696, 104);
        customRegularFuncMap.put(690, 1);
        customRegularFuncMap.put(692, 14);
        customRegularFuncMap.put(693, 106);
        customRegularFuncMap.put(694, 107);
        customRegularFuncMap.put(695, 31);
        customRegularFuncMap.put(169, 5);
        customRegularFuncMap.put(173, 5);
        customRegularFuncMap.put(698, 5);
        customRegularFuncMap.put(703, 8);
        customRegularFuncMap.put(704, 109);
        customRegularFuncMap.put(705, 110);
        customRegularFuncMap.put(706, 5);
        customRegularFuncMap.put(707, 111);
        customRegularFuncMap.put(708, 112);
        customRegularFuncMap.put(709, 113);
        customRegularFuncMap.put(710, 114);
        customRegularFuncMap.put(711, 115);
        customRegularFuncMap.put(712, 116);
        customRegularFuncMap.put(234, 117);
        customRegularFuncMap.put(713, 118);
        customRegularFuncMap.put(714, 119);
        customRegularFuncMap.put(240, 120);
        customRegularFuncMap.put(715, 121);
        customRegularFuncMap.put(716, 122);
        customRegularFuncMap.put(718, 123);
        customRegularFuncMap.put(717, 31);
        customRegularFuncMap.put(250, 5);
        customRegularFuncMap.put(719, 5);
        customRegularFuncMap.put(720, 126);
        customRegularFuncMap.put(721, 127);
        customRegularFuncMap.put(722, 128);
        customRegularFuncMap.put(723, 129);
        customRegularFuncMap.put(724, 130);
        customRegularFuncMap.put(725, 131);
        customRegularFuncMap.put(726, 133);
        customRegularFuncMap.put(727, 132);
        customRegularFuncMap.put(514, 134);
        customRegularFuncMap.put(729, 23);
        customRegularFuncMap.put(731, 137);
        customRegularFuncMap.put(282, 138);
        customRegularFuncMap.put(732, 139);
        customRegularFuncMap.put(733, 140);
        customRegularFuncMap.put(734, 141);
        customRegularFuncMap.put(735, 142);
        customRegularFuncMap.put(736, 143);
        customRegularFuncMap.put(737, 144);
        customRegularFuncMap.put(738, 145);
        customRegularFuncMap.put(741, 146);
        customRegularFuncMap.put(742, 147);
        customRegularFuncMap.put(743, 148);
        customRegularFuncMap.put(744, 149);
        customRegularFuncMap.put(295, 150);
        customRegularFuncMap.put(755, 27);
        customRegularFuncMap.put(756, 152);
        customRegularFuncMap.put(757, 151);
        customRegularFuncMap.put(758, 5);
        customRegularFuncMap.put(323, 5);
        customValueFuncMap = new IntKeyIntValueHashMap();
        customValueFuncMap.put(730, 52);
        customValueFuncMap.put(739, 43);
        customValueFuncMap.put(702, 52);
    }
}

