/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.web.compression;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CompressionResponseStream
extends ServletOutputStream {
    static final Log logger = LogFactory.getLog(CompressionResponseStream.class);
    protected OutputStream gzipstream = null;
    protected boolean closed = false;
    protected HttpServletResponse response = null;

    public CompressionResponseStream(HttpServletResponse response, final int compressionLevel, final int compressionStrategy) throws IOException {
        this.response = response;
        response.addHeader("Content-Encoding", "gzip");
        this.gzipstream = new GZIPOutputStream((OutputStream)response.getOutputStream()){
            {
                super(x0);
                this.def.setLevel(compressionLevel);
                this.def.setStrategy(compressionStrategy);
            }
        };
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        if (this.gzipstream != null) {
            this.gzipstream.close();
            this.gzipstream = null;
        }
        this.closed = true;
    }

    public void flush() throws IOException {
        if (this.closed) {
            return;
        }
        if (this.gzipstream != null) {
            this.gzipstream.flush();
        }
    }

    public void write(int b) throws IOException {
        if (this.closed) {
            return;
        }
        this.write(new byte[]{(byte)b});
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.closed || len == 0) {
            return;
        }
        this.gzipstream.write(b, off, len);
    }

    public boolean closed() {
        return this.closed;
    }
}

