/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.web;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.jumpmind.symmetric.SymmetricEngineHolder;

public class SymmetricContextListener
implements ServletContextListener {
    public void contextInitialized(ServletContextEvent sce) {
        SymmetricEngineHolder engineHolder = new SymmetricEngineHolder();
        ServletContext ctx = sce.getServletContext();
        String multiServerMode = ctx.getInitParameter("multiServerMode");
        engineHolder.setMultiServerMode(multiServerMode != null && multiServerMode.equalsIgnoreCase("true"));
        ctx.setAttribute("symmetricEngineHolder", (Object)engineHolder);
        engineHolder.start();
    }

    public void contextDestroyed(ServletContextEvent sce) {
        ServletContext ctx = sce.getServletContext();
        SymmetricEngineHolder engineHolder = (SymmetricEngineHolder)ctx.getAttribute("symmetricEngineHolder");
        if (engineHolder != null) {
            engineHolder.stop();
            ctx.removeAttribute("symmetricEngineHolder");
        }
    }
}

