/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.web;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.StandaloneSymmetricEngine;
import org.jumpmind.symmetric.SymmetricEngineHolder;
import org.jumpmind.symmetric.service.IParameterService;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class ServletUtils {
    public static boolean sendError(HttpServletResponse resp, int statusCode) throws IOException {
        return ServletUtils.sendError(resp, statusCode, null);
    }

    public static boolean sendError(HttpServletResponse resp, int statusCode, String message) throws IOException {
        boolean retVal = false;
        if (!resp.isCommitted()) {
            resp.sendError(statusCode, message);
            retVal = true;
        }
        return retVal;
    }

    public static boolean sendError(ServletResponse resp, int statusCode) throws IOException {
        return ServletUtils.sendError(resp, statusCode, null);
    }

    public static boolean sendError(ServletResponse resp, int statusCode, String message) throws IOException {
        boolean retVal = false;
        if (resp instanceof HttpServletResponse) {
            retVal = ServletUtils.sendError((HttpServletResponse)resp, statusCode, message);
        }
        return retVal;
    }

    public static ApplicationContext getApplicationContext(ServletContext servletContext) {
        WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext);
        if (!ctx.containsBean("parameterService") || !(ctx.getBean("parameterService") instanceof IParameterService)) {
            ISymmetricEngine engine = null;
            engine = ctx != null && ctx.containsBean("symmetricEngine") ? (ISymmetricEngine)ctx.getBean("symmetricEngine") : StandaloneSymmetricEngine.getEngine();
            if (engine != null) {
                ctx = engine.getApplicationContext();
            }
        }
        return ctx;
    }

    public static String normalizeRequestUri(HttpServletRequest httpRequest) {
        String servletPath;
        String contextPath;
        String retVal = httpRequest.getRequestURI();
        if (retVal.startsWith(contextPath = httpRequest.getContextPath())) {
            retVal = retVal.substring(contextPath.length());
        }
        if (retVal.startsWith(servletPath = httpRequest.getServletPath())) {
            retVal = retVal.substring(servletPath.length());
        }
        return retVal;
    }

    public static String getParameter(HttpServletRequest request, String name) {
        return StringUtils.trimToNull((String)request.getParameter(name));
    }

    public static String getParameter(HttpServletRequest request, String name, String defaultValue) {
        return StringUtils.defaultIfEmpty((String)StringUtils.trimToNull((String)request.getParameter(name)), (String)defaultValue);
    }

    public static long getParameterAsNumber(HttpServletRequest request, String name) {
        return NumberUtils.toLong((String)StringUtils.trimToNull((String)request.getParameter(name)));
    }

    public static SymmetricEngineHolder getSymmetricEngineHolder(ServletContext ctx) {
        return (SymmetricEngineHolder)ctx.getAttribute("symmetricEngineHolder");
    }
}

