/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.web;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.jumpmind.symmetric.model.ChannelMap;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.statistic.IStatisticManager;
import org.jumpmind.symmetric.transport.IConcurrentConnectionManager;
import org.jumpmind.symmetric.web.IInterceptor;
import org.jumpmind.symmetric.web.ServletUtils;

public class NodeConcurrencyInterceptor
implements IInterceptor {
    private IConcurrentConnectionManager concurrentConnectionManager;
    private IConfigurationService configurationService;
    private IStatisticManager statisticManager;

    public boolean before(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        String poolId = req.getRequestURI();
        String nodeId = this.getNodeId(req);
        String method = req.getMethod();
        if (method.equals("HEAD") && ServletUtils.normalizeRequestUri(req).contains("push")) {
            resp.setContentLength(0);
            if (!this.concurrentConnectionManager.reserveConnection(nodeId, poolId, IConcurrentConnectionManager.ReservationType.SOFT)) {
                this.statisticManager.incrementNodesRejected(1L);
                ServletUtils.sendError(resp, 503);
            } else {
                this.buildSuspendIgnoreResponseHeaders(nodeId, (ServletResponse)resp);
            }
            return false;
        }
        if (this.concurrentConnectionManager.reserveConnection(nodeId, poolId, IConcurrentConnectionManager.ReservationType.HARD)) {
            this.buildSuspendIgnoreResponseHeaders(nodeId, (ServletResponse)resp);
            return true;
        }
        this.statisticManager.incrementNodesRejected(1L);
        ServletUtils.sendError(resp, 503);
        return false;
    }

    protected String getNodeId(HttpServletRequest req) {
        String nodeId = StringUtils.trimToNull((String)req.getParameter("nodeId"));
        if (StringUtils.isBlank((String)nodeId)) {
            nodeId = StringUtils.trimToNull((String)req.getParameter("externalId"));
        }
        return nodeId;
    }

    public void after(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        String poolId = req.getRequestURI();
        String nodeId = this.getNodeId(req);
        this.concurrentConnectionManager.releaseConnection(nodeId, poolId);
    }

    protected void buildSuspendIgnoreResponseHeaders(String nodeId, ServletResponse resp) {
        HttpServletResponse httpResponse = (HttpServletResponse)resp;
        ChannelMap suspendIgnoreChannels = this.configurationService.getSuspendIgnoreChannelLists(nodeId);
        httpResponse.setHeader("Suspended-Channels", suspendIgnoreChannels.getSuspendChannelsAsString());
        httpResponse.setHeader("Ignored-Channels", suspendIgnoreChannels.getIgnoreChannelsAsString());
    }

    public void setConcurrentConnectionManager(IConcurrentConnectionManager concurrentConnectionManager) {
        this.concurrentConnectionManager = concurrentConnectionManager;
    }

    public void setConfigurationService(IConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public void setStatisticManager(IStatisticManager statisticManager) {
        this.statisticManager = statisticManager;
    }
}

