/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.web;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.jumpmind.symmetric.service.IDataExtractorService;
import org.jumpmind.symmetric.transport.IOutgoingTransport;
import org.jumpmind.symmetric.web.AbstractCompressionUriHandler;
import org.jumpmind.symmetric.web.ServletUtils;

public class BatchUriHandler
extends AbstractCompressionUriHandler {
    private IDataExtractorService dataExtractorService;

    public void handleWithCompression(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        res.setContentType("text/plain");
        String path = req.getPathInfo();
        if (!StringUtils.isBlank((String)path)) {
            int batchIdStartIndex = path.lastIndexOf("/") + 1;
            String batchId = path.substring(batchIdStartIndex);
            if (!this.write(batchId, (OutputStream)res.getOutputStream())) {
                ServletUtils.sendError(res, 404);
            } else {
                res.flushBuffer();
            }
        } else {
            res.sendError(404);
        }
    }

    public boolean write(String batchId, OutputStream os) throws IOException {
        IOutgoingTransport transport = this.createOutgoingTransport(os);
        boolean foundBatch = this.dataExtractorService.extractBatchRange(transport, batchId, batchId);
        transport.close();
        return foundBatch;
    }

    public void setDataExtractorService(IDataExtractorService dataExtractorService) {
        this.dataExtractorService = dataExtractorService;
    }
}

