/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.web;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jumpmind.symmetric.model.BatchInfo;
import org.jumpmind.symmetric.service.IAcknowledgeService;
import org.jumpmind.symmetric.transport.AbstractTransportManager;
import org.jumpmind.symmetric.web.AbstractUriHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AckUriHandler
extends AbstractUriHandler {
    private static final Comparator<BatchInfo> BATCH_ID_COMPARATOR = new Comparator<BatchInfo>(){

        @Override
        public int compare(BatchInfo batchInfo1, BatchInfo batchInfo2) {
            Long batchId1 = batchInfo1.getBatchId();
            Long batchId2 = batchInfo1.getBatchId();
            return batchId1.compareTo(batchId2);
        }
    };
    private IAcknowledgeService acknowledgeService;

    @Override
    public void handle(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("DataAckReading", new Object[]{req.getParameterMap()});
        }
        List batches = AbstractTransportManager.readAcknowledgement((Map)req.getParameterMap());
        Collections.sort(batches, BATCH_ID_COMPARATOR);
        this.ack(batches);
    }

    protected void ack(List<BatchInfo> batches) throws IOException {
        for (BatchInfo batchInfo : batches) {
            this.acknowledgeService.ack(batchInfo);
        }
    }

    public void setAcknowledgeService(IAcknowledgeService acknowledgeService) {
        this.acknowledgeService = acknowledgeService;
    }
}

